/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.core.IRelationshipEnd;
import org.xmind.gef.GEF;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.SelectionFigure;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.ui.decorations.IRelationshipDecoration;
import org.xmind.ui.internal.figures.RelationshipFigure;
import org.xmind.ui.internal.tools.RelationshipDummy;
import org.xmind.ui.mindmap.INodePart;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.tools.DummyMoveTool;
import org.xmind.ui.util.MindMapUtils;

public class RelationshipMoveTool
extends DummyMoveTool {
    private int pointId = -1;
    private RelationshipDummy relDummy = null;
    private Point newPosition = null;
    private IPart newNode = null;
    private IFeedbackService feedbackService = null;

    public void setSource(IGraphicalEditPart source) {
        Assert.isTrue((boolean)(source instanceof IRelationshipPart));
        super.setSource(source);
    }

    protected IRelationshipPart getSourceRelationship() {
        return (IRelationshipPart)super.getSource();
    }

    @Override
    protected IFigure createDummy() {
        Layer layer;
        IRelationshipPart sourceRel = this.getSourceRelationship();
        if (sourceRel == null) {
            return null;
        }
        Point pos = this.getStartingPosition();
        if (pos != null) {
            this.pointId = sourceRel.getPointId(pos);
        }
        if (this.pointId == -1) {
            return null;
        }
        if (this.relDummy == null && (layer = this.getTargetViewer().getLayer(GEF.LAYER_PRESENTATION)) != null) {
            this.relDummy = this.createRelationshipDummy((IFigure)layer, sourceRel);
        }
        if (this.relDummy != null) {
            return this.relDummy.getRelDummy().getFigure();
        }
        return null;
    }

    protected RelationshipDummy createRelationshipDummy(IFigure layer, IRelationshipPart sourceRel) {
        return new RelationshipDummy(layer, sourceRel, this.pointId, this.getTargetViewer());
    }

    @Override
    protected void destroyDummy() {
        this.pointId = -1;
        this.newPosition = null;
        this.setNewNode(null);
        this.feedbackService = null;
        if (this.relDummy != null) {
            this.relDummy.dispose();
            this.relDummy = null;
        }
        super.destroyDummy();
    }

    private void setNewNode(IPart node) {
        IPart oldNode = this.newNode;
        if (node == oldNode) {
            return;
        }
        if (oldNode != null) {
            this.removeNodeFeedback(oldNode);
        }
        this.newNode = node;
        if (node != null) {
            this.addNodeFeedback(node);
        }
    }

    private void addNodeFeedback(IPart node) {
        IFigure nodeFigure;
        if (node instanceof IGraphicalPart && (nodeFigure = ((IGraphicalPart)node).getFigure()) != null) {
            if (this.feedbackService == null) {
                this.feedbackService = (IFeedbackService)this.getTargetViewer().getService(IFeedbackService.class);
            }
            if (this.feedbackService != null) {
                SelectionFigure figure = this.feedbackService.addSelection(nodeFigure);
                figure.setPreselected(true);
            }
        }
    }

    private void removeNodeFeedback(IPart node) {
        IFigure nodeFigure;
        if (this.feedbackService != null && node instanceof IGraphicalPart && (nodeFigure = ((IGraphicalPart)node).getFigure()) != null) {
            this.feedbackService.removeSelection(nodeFigure);
        }
    }

    private IPart findRelationshipEndPart(IPart part) {
        if (part != null) {
            IRelationshipPart rel = this.getSourceRelationship();
            if (part == rel.getSourceNode() || part == rel.getTargetNode()) {
                return null;
            }
            Object m = MindMapUtils.getRealModel(part);
            if (m instanceof IRelationshipEnd) {
                return part;
            }
        }
        return null;
    }

    @Override
    protected void onMoving(Point currentPos, MouseDragEvent me) {
        super.onMoving(currentPos, me);
        if (this.pointId == 1 || this.pointId == 2) {
            this.setNewNode(this.findRelationshipEndPart(me.target));
        }
    }

    @Override
    protected void updateDummyPosition(Point pos) {
        RelationshipFigure rf;
        IRelationshipDecoration dec;
        IFigure fig;
        if (this.relDummy == null) {
            return;
        }
        if (this.pointId == 1 || this.pointId == 2) {
            INodePart node = this.pointId == 1 ? this.relDummy.getSourceNodeDummy() : this.relDummy.getTargetNodeDummy();
            if (node != null) {
                IFigure fig2 = node.getFigure();
                if (fig2 instanceof IReferencedFigure) {
                    ((IReferencedFigure)fig2).setReference(pos);
                } else {
                    fig2.setLocation(pos);
                }
            }
        } else if ((this.pointId == 3 || this.pointId == 4) && (fig = this.relDummy.getRelDummy().getFigure()) != null && fig instanceof RelationshipFigure && (dec = (rf = (RelationshipFigure)fig).getDecoration()) != null) {
            boolean sourceOrTarget = this.pointId == 3;
            this.updateControlPointPosition(pos, rf, dec, sourceOrTarget);
        }
        this.relDummy.refreshFeedback();
    }

    private void updateControlPointPosition(Point pos, RelationshipFigure figure, IRelationshipDecoration decoration, boolean sourceOrTarget) {
        PrecisionPoint ref = sourceOrTarget ? figure.getSourceAnchor().getReferencePoint() : figure.getTargetAnchor().getReferencePoint();
        this.newPosition = new Point((int)((double)pos.x - ref.x), (int)((double)pos.y - ref.y));
        if (sourceOrTarget) {
            decoration.setRelativeSourceControlPoint((IFigure)figure, this.newPosition);
        } else {
            decoration.setRelativeTargetControlPoint((IFigure)figure, this.newPosition);
        }
        this.relDummy.getRelDummy().getRelationship().getControlPoint(sourceOrTarget ? 0 : 1).setPosition(this.newPosition.x, this.newPosition.y);
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        if (this.pointId == 1 || this.pointId == 2) {
            return Cursors.HAND;
        }
        if (this.pointId == 3 || this.pointId == 4) {
            return Cursors.CROSS;
        }
        return super.getCurrentCursor(pos, host);
    }

    @Override
    protected Request createRequest() {
        Request request = null;
        if (this.pointId == 1 || this.pointId == 2) {
            if (this.newNode != null) {
                request = new Request("retarget_relationship");
                request.setParameter("moveRel.newNode", (Object)this.newNode);
            }
        } else if ((this.pointId == 3 || this.pointId == 4) && this.newPosition != null) {
            request = new Request("move_control_point");
            request.setParameter("position", (Object)this.newPosition);
        }
        if (request != null) {
            request.setPrimaryTarget((IPart)this.getSourceRelationship());
            request.setDomain(this.getDomain());
            request.setViewer((IViewer)this.getTargetViewer());
            request.setParameter("moveRel.pointId", (Object)this.pointId);
        }
        return request;
    }
}

