/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.layouts;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IRotatableFigure;
import org.xmind.gef.draw2d.ReferencedLayoutData;
import org.xmind.ui.internal.layouts.MindMapLayoutBase;
import org.xmind.ui.internal.mindmap.InfoItemContentPart;
import org.xmind.ui.mindmap.IInfoItemPart;
import org.xmind.ui.mindmap.IInfoPart;

public class InformationLayout
extends MindMapLayoutBase {
    private int spacing = 5;

    public InformationLayout(IInfoPart part) {
        super(part);
    }

    protected void fillLayoutData(IFigure container, ReferencedLayoutData data) {
        IInfoPart information = (IInfoPart)this.getPart();
        List<IInfoItemPart> icons = information.getInfoItemIcons();
        List<InfoItemContentPart> contents = information.getInfoItemContents();
        if (!icons.isEmpty() && !contents.isEmpty()) {
            int i = 0;
            while (i < Math.max(icons.size(), contents.size())) {
                Rectangle r;
                Rectangle area;
                Point ref = data.getReference();
                IFigure itemFig = null;
                Dimension itemSize = new Dimension();
                if (i < icons.size()) {
                    IInfoItemPart item = icons.get(i);
                    itemFig = item.getFigure();
                    itemSize = this.getChildPreferredSize(itemFig);
                }
                IFigure contentFig = null;
                Dimension contentSize = new Dimension();
                if (i < contents.size()) {
                    InfoItemContentPart content = contents.get(i);
                    contentFig = content.getFigure();
                    contentSize = this.getChildPreferredSize(contentFig);
                }
                if (itemFig != null) {
                    area = data.getClientArea();
                    if (area == null) {
                        r = this.createBounds(ref, itemSize);
                    } else {
                        int x = area.width < itemSize.width ? area.x - (itemSize.width + area.width) / 2 : area.x;
                        r = new Rectangle(x, area.bottom() + this.spacing + (contentSize.height - itemSize.height) / 4, itemSize.width, itemSize.height);
                    }
                    data.put(itemFig, r);
                }
                if (contentFig != null) {
                    area = data.getClientArea();
                    r = area == null ? this.createBounds(ref, contentSize) : new Rectangle(area.x + itemSize.width + this.spacing, area.bottom() - (contentSize.height + itemSize.height) / 2, contentSize.width, contentSize.height);
                    data.put(contentFig, r);
                }
                ++i;
            }
        }
    }

    private Rectangle createBounds(Point ref, Dimension size) {
        return new Rectangle(ref.x - size.width / 2, ref.y, size.width, size.height);
    }

    private Dimension getChildPreferredSize(IFigure child) {
        if (child instanceof IRotatableFigure) {
            return ((IRotatableFigure)child).getNormalPreferredSize(-1, -1).toDraw2DDimension();
        }
        return child.getPreferredSize();
    }
}

