/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.comments;

import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.util.TopicIterator;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.comments.CommentAction;
import org.xmind.ui.internal.comments.CommentsPopup;
import org.xmind.ui.internal.comments.CommentsUtils;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class ShowNextTopicCommentsAction
extends CommentAction {
    private ITopic topic;
    private CommentsPopup dialog;

    public ShowNextTopicCommentsAction(IGraphicalEditor editor, CommentsPopup dialog) {
        super(editor);
        this.topic = dialog.getTopic();
        this.dialog = dialog;
        this.setId("org.xmind.ui.action.showNextTopicComments2");
        this.setText(MindMapMessages.ShowNextTopicComments_text);
        this.setImageDescriptor(MindMapUI.getImages().get("next-topic.png", true));
        this.setToolTipText(MindMapMessages.ShowNextTopicComments_tooltip);
    }

    @Override
    public void run() {
        if (this.topic == null) {
            return;
        }
        ITopic nextTopic = this.findNextTopicWithComments(this.topic);
        if (nextTopic == null || nextTopic == this.topic) {
            return;
        }
        ITopicPart topicPart = MindMapUtils.findTopicPart((IViewer)this.getTargetEditor().getAdapter(IGraphicalViewer.class), nextTopic);
        if (topicPart == null) {
            return;
        }
        this.dialog.close();
        CommentsUtils.reveal(this.getTargetEditor(), nextTopic);
        CommentsPopup popup = new CommentsPopup(this.getTargetEditor().getSite().getWorkbenchWindow(), topicPart, true);
        popup.open();
    }

    private ITopic findNextTopicWithComments(ITopic sourceTopic) {
        ITopic nextTopic;
        ISheet sheet = sourceTopic.getOwnedSheet();
        if (sheet == null) {
            return null;
        }
        TopicIterator it = new TopicIterator(sheet.getRootTopic());
        boolean sourceFound = false;
        while (it.hasNext()) {
            nextTopic = it.next();
            if (!sourceFound) {
                if (nextTopic != sourceTopic) continue;
                sourceFound = true;
                continue;
            }
            if (!nextTopic.getOwnedWorkbook().getCommentManager().hasComments(nextTopic.getId())) continue;
            return nextTopic;
        }
        if (sourceFound) {
            it = new TopicIterator(sheet.getRootTopic());
            while (it.hasNext()) {
                nextTopic = it.next();
                if (nextTopic == sourceTopic) break;
                if (!nextTopic.getOwnedWorkbook().getCommentManager().hasComments(nextTopic.getId())) continue;
                return nextTopic;
            }
        }
        return null;
    }
}

