/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.imports.opml;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.imports.ImportMessages;
import org.xmind.ui.internal.imports.ImportPlugin;
import org.xmind.ui.internal.imports.opml.OpmlImporter;
import org.xmind.ui.wizards.AbstractMindMapImportPage;
import org.xmind.ui.wizards.AbstractMindMapImportWizard;
import org.xmind.ui.wizards.MindMapImporter;

public class OpmlImportWizard
extends AbstractMindMapImportWizard {
    private static final String SETTINGS_ID = "org.xmind.ui.imports.Opml";
    private static final String PAGE_ID = "importOPML";
    private static final String DOCUMENT_FILTER = "*.opml";
    private static final String DOCUMENT_EXT = "*.opml";

    public OpmlImportWizard() {
        IDialogSettings settings = ImportPlugin.getDefault().getDialogSettings().getSection(SETTINGS_ID);
        if (settings == null) {
            settings = ImportPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_ID);
        }
        this.setDialogSettings(settings);
    }

    public void addPages() {
        this.addPage((IWizardPage)new OpmlImportPage());
    }

    protected MindMapImporter createImporter(String sourcePath, IWorkbook targetWorkbook) {
        return new OpmlImporter(sourcePath, targetWorkbook);
    }

    protected String getApplicationId() {
        return "Opml";
    }

    private class OpmlImportPage
    extends AbstractMindMapImportPage {
        protected OpmlImportPage() {
            super(OpmlImportWizard.PAGE_ID, ImportMessages.OpmlImportWizard_windowTitle);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            Control destinationControl = this.createDestinationControl(composite);
            destinationControl.setLayoutData((Object)new GridData(4, 4, true, true));
            this.updateStatus();
            parent.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    OpmlImportPage.this.openBrowseDialog();
                }
            });
        }

        protected FileDialog createBrowseDialog() {
            FileDialog dialog = super.createBrowseDialog();
            dialog.setFilterExtensions(new String[]{"*.opml"});
            dialog.setFilterNames(new String[]{NLS.bind((String)ImportMessages.OpmlImportPage_FilterName, (Object)"*.opml")});
            return dialog;
        }
    }
}

