/* vntr.c was originally generated by the autoSql program, which also 
 * generated vntr.h and vntr.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "vntr.h"


void vntrStaticLoad(char **row, struct vntr *ret)
/* Load a row from vntr table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->repeatCount = atof(row[4]);
ret->distanceToLast = sqlSigned(row[5]);
ret->distanceToNext = sqlSigned(row[6]);
ret->forwardPrimer = row[7];
ret->reversePrimer = row[8];
ret->pcrLength = row[9];
}

struct vntr *vntrLoad(char **row)
/* Load a vntr from row fetched with select * from vntr
 * from database.  Dispose of this with vntrFree(). */
{
struct vntr *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->repeatCount = atof(row[4]);
ret->distanceToLast = sqlSigned(row[5]);
ret->distanceToNext = sqlSigned(row[6]);
ret->forwardPrimer = cloneString(row[7]);
ret->reversePrimer = cloneString(row[8]);
ret->pcrLength = cloneString(row[9]);
return ret;
}

struct vntr *vntrLoadAll(char *fileName) 
/* Load all vntr from a whitespace-separated file.
 * Dispose of this with vntrFreeList(). */
{
struct vntr *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = vntrLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct vntr *vntrLoadAllByChar(char *fileName, char chopper) 
/* Load all vntr from a chopper separated file.
 * Dispose of this with vntrFreeList(). */
{
struct vntr *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = vntrLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct vntr *vntrCommaIn(char **pS, struct vntr *ret)
/* Create a vntr out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new vntr */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->repeatCount = sqlFloatComma(&s);
ret->distanceToLast = sqlSignedComma(&s);
ret->distanceToNext = sqlSignedComma(&s);
ret->forwardPrimer = sqlStringComma(&s);
ret->reversePrimer = sqlStringComma(&s);
ret->pcrLength = sqlStringComma(&s);
*pS = s;
return ret;
}

void vntrFree(struct vntr **pEl)
/* Free a single dynamically allocated vntr such as created
 * with vntrLoad(). */
{
struct vntr *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->forwardPrimer);
freeMem(el->reversePrimer);
freeMem(el->pcrLength);
freez(pEl);
}

void vntrFreeList(struct vntr **pList)
/* Free a list of dynamically allocated vntr's */
{
struct vntr *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    vntrFree(&el);
    }
*pList = NULL;
}

void vntrOutput(struct vntr *el, FILE *f, char sep, char lastSep) 
/* Print out vntr.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->repeatCount);
fputc(sep,f);
fprintf(f, "%d", el->distanceToLast);
fputc(sep,f);
fprintf(f, "%d", el->distanceToNext);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->forwardPrimer);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->reversePrimer);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->pcrLength);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

