/* hgFindSpec.c was originally generated by the autoSql program, which also 
 * generated hgFindSpec.h and hgFindSpec.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "hgFindSpec.h"


void hgFindSpecStaticLoad(char **row, struct hgFindSpec *ret)
/* Load a row from hgFindSpec table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->searchName = row[0];
ret->searchTable = row[1];
ret->searchMethod = row[2];
ret->searchType = row[3];
ret->shortCircuit = sqlUnsigned(row[4]);
ret->termRegex = row[5];
ret->query = row[6];
ret->xrefTable = row[7];
ret->xrefQuery = row[8];
ret->searchPriority = atof(row[9]);
ret->searchDescription = row[10];
ret->searchSettings = row[11];
}

struct hgFindSpec *hgFindSpecLoad(char **row)
/* Load a hgFindSpec from row fetched with select * from hgFindSpec
 * from database.  Dispose of this with hgFindSpecFree(). */
{
struct hgFindSpec *ret;

AllocVar(ret);
ret->searchName = cloneString(row[0]);
ret->searchTable = cloneString(row[1]);
ret->searchMethod = cloneString(row[2]);
ret->searchType = cloneString(row[3]);
ret->shortCircuit = sqlUnsigned(row[4]);
ret->termRegex = cloneString(row[5]);
ret->query = cloneString(row[6]);
ret->xrefTable = cloneString(row[7]);
ret->xrefQuery = cloneString(row[8]);
ret->searchPriority = atof(row[9]);
ret->searchDescription = cloneString(row[10]);
ret->searchSettings = cloneString(row[11]);
return ret;
}

struct hgFindSpec *hgFindSpecLoadAll(char *fileName) 
/* Load all hgFindSpec from a whitespace-separated file.
 * Dispose of this with hgFindSpecFreeList(). */
{
struct hgFindSpec *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[12];

while (lineFileRow(lf, row))
    {
    el = hgFindSpecLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct hgFindSpec *hgFindSpecLoadAllByChar(char *fileName, char chopper) 
/* Load all hgFindSpec from a chopper separated file.
 * Dispose of this with hgFindSpecFreeList(). */
{
struct hgFindSpec *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[12];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = hgFindSpecLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct hgFindSpec *hgFindSpecCommaIn(char **pS, struct hgFindSpec *ret)
/* Create a hgFindSpec out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hgFindSpec */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->searchName = sqlStringComma(&s);
ret->searchTable = sqlStringComma(&s);
ret->searchMethod = sqlStringComma(&s);
ret->searchType = sqlStringComma(&s);
ret->shortCircuit = sqlUnsignedComma(&s);
ret->termRegex = sqlStringComma(&s);
ret->query = sqlStringComma(&s);
ret->xrefTable = sqlStringComma(&s);
ret->xrefQuery = sqlStringComma(&s);
ret->searchPriority = sqlFloatComma(&s);
ret->searchDescription = sqlStringComma(&s);
ret->searchSettings = sqlStringComma(&s);
*pS = s;
return ret;
}

void hgFindSpecFree(struct hgFindSpec **pEl)
/* Free a single dynamically allocated hgFindSpec such as created
 * with hgFindSpecLoad(). */
{
struct hgFindSpec *el;

if ((el = *pEl) == NULL) return;
freeMem(el->searchName);
freeMem(el->searchTable);
freeMem(el->searchMethod);
freeMem(el->searchType);
freeMem(el->termRegex);
freeMem(el->query);
freeMem(el->xrefTable);
freeMem(el->xrefQuery);
freeMem(el->searchDescription);
freeMem(el->searchSettings);
freez(pEl);
}

void hgFindSpecFreeList(struct hgFindSpec **pList)
/* Free a list of dynamically allocated hgFindSpec's */
{
struct hgFindSpec *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    hgFindSpecFree(&el);
    }
*pList = NULL;
}

void hgFindSpecOutput(struct hgFindSpec *el, FILE *f, char sep, char lastSep) 
/* Print out hgFindSpec.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->searchName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->searchTable);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->searchMethod);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->searchType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->shortCircuit);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->termRegex);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->query);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->xrefTable);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->xrefQuery);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->searchPriority);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->searchDescription);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->searchSettings);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

