/* cnpSharp.c was originally generated by the autoSql program, which also 
 * generated cnpSharp.h and cnpSharp.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "cnpSharp.h"


void cnpSharpStaticLoad(char **row, struct cnpSharp *ret)
/* Load a row from cnpSharp table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->variationType = row[4];
ret->cytoName = row[5];
ret->cytoStrain = row[6];
ret->dupPercent = atof(row[7]);
ret->repeatsPercent = atof(row[8]);
ret->LINEpercent = atof(row[9]);
ret->SINEpercent = atof(row[10]);
ret->LTRpercent = atof(row[11]);
ret->DNApercent = atof(row[12]);
ret->diseaseSpotsPercent = atof(row[13]);
}

struct cnpSharp *cnpSharpLoad(char **row)
/* Load a cnpSharp from row fetched with select * from cnpSharp
 * from database.  Dispose of this with cnpSharpFree(). */
{
struct cnpSharp *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->variationType = cloneString(row[4]);
ret->cytoName = cloneString(row[5]);
ret->cytoStrain = cloneString(row[6]);
ret->dupPercent = atof(row[7]);
ret->repeatsPercent = atof(row[8]);
ret->LINEpercent = atof(row[9]);
ret->SINEpercent = atof(row[10]);
ret->LTRpercent = atof(row[11]);
ret->DNApercent = atof(row[12]);
ret->diseaseSpotsPercent = atof(row[13]);
return ret;
}

struct cnpSharp *cnpSharpLoadAll(char *fileName) 
/* Load all cnpSharp from a whitespace-separated file.
 * Dispose of this with cnpSharpFreeList(). */
{
struct cnpSharp *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileRow(lf, row))
    {
    el = cnpSharpLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cnpSharp *cnpSharpLoadAllByChar(char *fileName, char chopper) 
/* Load all cnpSharp from a chopper separated file.
 * Dispose of this with cnpSharpFreeList(). */
{
struct cnpSharp *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cnpSharpLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cnpSharp *cnpSharpCommaIn(char **pS, struct cnpSharp *ret)
/* Create a cnpSharp out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cnpSharp */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->variationType = sqlStringComma(&s);
ret->cytoName = sqlStringComma(&s);
ret->cytoStrain = sqlStringComma(&s);
ret->dupPercent = sqlFloatComma(&s);
ret->repeatsPercent = sqlFloatComma(&s);
ret->LINEpercent = sqlFloatComma(&s);
ret->SINEpercent = sqlFloatComma(&s);
ret->LTRpercent = sqlFloatComma(&s);
ret->DNApercent = sqlFloatComma(&s);
ret->diseaseSpotsPercent = sqlFloatComma(&s);
*pS = s;
return ret;
}

void cnpSharpFree(struct cnpSharp **pEl)
/* Free a single dynamically allocated cnpSharp such as created
 * with cnpSharpLoad(). */
{
struct cnpSharp *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->variationType);
freeMem(el->cytoName);
freeMem(el->cytoStrain);
freez(pEl);
}

void cnpSharpFreeList(struct cnpSharp **pList)
/* Free a list of dynamically allocated cnpSharp's */
{
struct cnpSharp *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cnpSharpFree(&el);
    }
*pList = NULL;
}

void cnpSharpOutput(struct cnpSharp *el, FILE *f, char sep, char lastSep) 
/* Print out cnpSharp.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->variationType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->cytoName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->cytoStrain);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->dupPercent);
fputc(sep,f);
fprintf(f, "%g", el->repeatsPercent);
fputc(sep,f);
fprintf(f, "%g", el->LINEpercent);
fputc(sep,f);
fprintf(f, "%g", el->SINEpercent);
fputc(sep,f);
fprintf(f, "%g", el->LTRpercent);
fputc(sep,f);
fprintf(f, "%g", el->DNApercent);
fputc(sep,f);
fprintf(f, "%g", el->diseaseSpotsPercent);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

