/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryingCallable<V>
implements Callable<V> {
    private final Logger logger = LoggerFactory.getLogger(RetryingCallable.class);
    private final Callable<V> callable;
    private final int retries;

    public RetryingCallable(int retries, Callable<V> callable) {
        this.retries = retries;
        this.callable = callable;
    }

    @Override
    public V call() throws Exception {
        int retried = 0;
        ArrayList<Exception> exceptions = Lists.newArrayList();
        while (true) {
            try {
                return this.callable.call();
            }
            catch (Exception e) {
                exceptions.add(e);
                if (++retried == this.retries) {
                    StringBuilder exceptionsString = new StringBuilder();
                    for (int i = 0; i < exceptions.size(); ++i) {
                        exceptionsString.append("\nFailure " + (i + 1) + ": " + exceptions.get(i));
                    }
                    throw new RuntimeException("Failed after " + retried + " tries." + exceptionsString, e);
                }
                this.logger.info("Retrying statement; number of times failed: " + retried + "; exception\n:" + e);
                continue;
            }
            break;
        }
    }
}

