/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc.wellcheck;

import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.erc.wellcheck.NetValues;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;

public class WellCon {
    private Rectangle2D bound;
    private Point2D center;
    private int netNum;
    private NetValues wellNum = null;
    private boolean onProperRail;
    private boolean onRail;
    private PrimitiveNode.Function fun;
    private NodeInst ni;
    private AtomicBoolean marked = new AtomicBoolean(false);

    public WellCon(Rectangle2D bound, int netNum, NetValues wellNum, boolean onProperRail, boolean onRail, PrimitiveNode.Function fun, NodeInst ni) {
        this.bound = bound;
        this.center = new Point2D.Double(bound.getCenterX(), bound.getCenterY());
        this.netNum = netNum;
        this.wellNum = wellNum;
        this.onProperRail = onProperRail;
        this.onRail = onRail;
        this.fun = fun;
        this.ni = ni;
    }

    public Rectangle2D getBound() {
        return this.bound;
    }

    public Point2D getCenter() {
        return this.center;
    }

    public int getNetNum() {
        return this.netNum;
    }

    public NetValues getWellNum() {
        return this.wellNum;
    }

    public void setWellNum(NetValues wn) {
        this.wellNum = wn;
    }

    public boolean isOnProperRail() {
        return this.onProperRail;
    }

    public void setOnProperRail(boolean opr) {
        this.onProperRail = opr;
    }

    public boolean isOnRail() {
        return this.onRail;
    }

    public void setOnRail(boolean or) {
        this.onRail = or;
    }

    public PrimitiveNode.Function getFun() {
        return this.fun;
    }

    public NodeInst getNi() {
        return this.ni;
    }

    public AtomicBoolean getMarked() {
        return this.marked;
    }

    public static class WellConComparator
    implements Comparator<WellCon> {
        private WellCon base;

        public WellConComparator(WellCon base) {
            this.base = base;
        }

        @Override
        public int compare(WellCon o1, WellCon o2) {
            Double o1Dist = new Double(o1.getCenter().distance(this.base.getCenter()));
            Double o2Dist = new Double(o2.getCenter().distance(this.base.getCenter()));
            return Double.compare(o1Dist, o2Dist);
        }
    }
}

