/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.yura.mobile.util.Comparator;
import net.yura.mobile.util.StringUtil;

public class SystemUtil {
    public static void hashtablePutAll(Hashtable src, Hashtable dest) {
        Enumeration en = src.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            dest.put(key, src.get(key));
        }
    }

    public static Vector asList(Object[] a) {
        Vector<Object> vec = new Vector<Object>(a.length);
        for (int c = 0; c < a.length; ++c) {
            vec.addElement(a[c]);
        }
        return vec;
    }

    public static void addAll(Vector des, Vector src) {
        for (int c = 0; c < src.size(); ++c) {
            des.addElement(src.elementAt(c));
        }
    }

    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1.equals(obj2)) {
            return true;
        }
        if (obj1 instanceof Hashtable && obj2 instanceof Hashtable) {
            Hashtable hash1 = (Hashtable)obj1;
            Hashtable hash2 = (Hashtable)obj2;
            if (hash1.size() != hash2.size()) {
                return false;
            }
            Enumeration enum1 = hash1.keys();
            while (enum1.hasMoreElements()) {
                Object objKey1 = enum1.nextElement();
                Object objValue1 = hash1.get(objKey1);
                boolean found = false;
                Enumeration enum2 = hash2.keys();
                while (enum2.hasMoreElements()) {
                    Object objKey2 = enum2.nextElement();
                    Object objValue2 = hash2.get(objKey2);
                    if (!SystemUtil.equals(objKey1, objKey2)) continue;
                    if (!SystemUtil.equals(objValue1, objValue2)) break;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        if (obj1 instanceof Vector && obj2 instanceof Vector) {
            Vector vector1 = (Vector)obj1;
            Vector vector2 = (Vector)obj2;
            if (vector1.size() != vector2.size()) {
                return false;
            }
            for (int i = 0; i < vector1.size(); ++i) {
                if (SystemUtil.equals(vector1.elementAt(i), vector2.elementAt(i))) continue;
                return false;
            }
            return true;
        }
        if (obj1 instanceof Object[] && obj2 instanceof Object[]) {
            Object[] objArray1 = (Object[])obj1;
            Object[] objArray2 = (Object[])obj2;
            if (objArray1.length != objArray2.length) {
                return false;
            }
            for (int i = 0; i < objArray1.length; ++i) {
                if (SystemUtil.equals(objArray1[i], objArray2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void sort(Vector vec) {
        SystemUtil.quickSort(vec, 0, vec.size() - 1, null);
    }

    public static void sort(Vector vec, Comparator comp) {
        SystemUtil.quickSort(vec, 0, vec.size() - 1, comp);
    }

    private static void quickSort(Vector vec, int lo0, int hi0, Comparator comp) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            Object mid = vec.elementAt((lo0 + hi0) / 2);
            while (lo <= hi) {
                while (lo < hi0 && (comp == null ? String.valueOf(vec.elementAt(lo)).compareTo(String.valueOf(mid)) : comp.compare(vec.elementAt(lo), mid)) < 0) {
                    ++lo;
                }
                while (hi > lo0 && (comp == null ? String.valueOf(vec.elementAt(hi)).compareTo(String.valueOf(mid)) : comp.compare(vec.elementAt(hi), mid)) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                Object t1 = vec.elementAt(hi);
                vec.setElementAt(vec.elementAt(lo), hi);
                vec.setElementAt(t1, lo);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                SystemUtil.quickSort(vec, lo0, hi, comp);
            }
            if (lo < hi0) {
                SystemUtil.quickSort(vec, lo, hi0, comp);
            }
        }
    }

    public static int binarySearch(Vector l, Object key, Comparator c) {
        int low = 0;
        int high = l.size() - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            Object midVal = l.elementAt(mid);
            int n = cmp = c != null ? c.compare(midVal, key) : String.valueOf(midVal).compareTo(String.valueOf(key));
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static String getFileSafeName(String name) {
        String invalid = "/?<>\\:*|\" ";
        for (int c = 0; c < invalid.length(); ++c) {
            name = StringUtil.replaceAll(name, String.valueOf(invalid.charAt(c)), "");
        }
        return name;
    }

    public static byte[] getData(InputStream iStrm, int length) throws IOException {
        byte[] imageData;
        if (length != -1) {
            imageData = new byte[length];
            DataInputStream din = new DataInputStream(iStrm);
            din.readFully(imageData);
        } else {
            int len;
            ByteArrayOutputStream bStrm = new ByteArrayOutputStream();
            byte[] buffer = new byte[Math.max(32, iStrm.available())];
            while ((len = iStrm.read(buffer)) != -1) {
                bStrm.write(buffer, 0, len);
            }
            imageData = bStrm.toByteArray();
            bStrm.close();
        }
        return imageData;
    }
}

