/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.osgi.core.OSGiManifestParser;
import org.apache.ivy.plugins.parser.AbstractModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.m2.PomModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.Message;

public final class ModuleDescriptorParserRegistry
extends AbstractModuleDescriptorParser {
    private static final ModuleDescriptorParserRegistry INSTANCE = new ModuleDescriptorParserRegistry();
    private List parsers = new LinkedList();

    public static ModuleDescriptorParserRegistry getInstance() {
        return INSTANCE;
    }

    private ModuleDescriptorParserRegistry() {
        this.parsers.add(PomModuleDescriptorParser.getInstance());
        this.parsers.add(OSGiManifestParser.getInstance());
        this.parsers.add(XmlModuleDescriptorParser.getInstance());
    }

    public final ModuleDescriptorParser getParser(Resource resource) {
        for (ModuleDescriptorParser moduleDescriptorParser : this.parsers) {
            if (!moduleDescriptorParser.accept(resource)) continue;
            return moduleDescriptorParser;
        }
        return null;
    }

    @Override
    public final ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, Resource resource, boolean bl) {
        ModuleDescriptorParser moduleDescriptorParser = this.getParser(resource);
        if (moduleDescriptorParser == null) {
            Message.warn("no module descriptor parser found for " + resource);
            return null;
        }
        return moduleDescriptorParser.parseDescriptor(parserSettings, uRL, resource, bl);
    }

    @Override
    public final boolean accept(Resource resource) {
        return this.getParser(resource) != null;
    }

    @Override
    public final void toIvyFile(InputStream inputStream, Resource resource, File file2, ModuleDescriptor moduleDescriptor) {
        ModuleDescriptorParser moduleDescriptorParser = this.getParser(resource);
        if (moduleDescriptorParser == null) {
            Message.warn("no module descriptor parser found for " + resource);
            return;
        }
        moduleDescriptorParser.toIvyFile(inputStream, resource, file2, moduleDescriptor);
    }
}

