/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.utils.CoreUtility;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Logging;
import pcgen.util.enumeration.Load;

public class TotalToken
extends Token {
    public static final String TOKENNAME = "TOTAL";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        String retString = "";
        if ("TOTAL.WEIGHT".equals(tokenSource)) {
            retString = TotalToken.getWeightToken(pc.getDisplay());
        } else if ("TOTAL.VALUE".equals(tokenSource)) {
            retString = TotalToken.getValueToken(pc);
        } else if ("TOTAL.CAPACITY".equals(tokenSource)) {
            retString = TotalToken.getCapacityToken(pc.getDisplay());
        } else if ("TOTAL.LOAD".equals(tokenSource)) {
            retString = TotalToken.getLoadToken(pc.getDisplay());
        }
        return retString;
    }

    public static String getCapacityToken(CharacterDisplay display) {
        return Globals.getGameModeUnitSet().displayWeightInUnitSet(display.getMaxLoad().doubleValue());
    }

    public static String getLoadToken(CharacterDisplay display) {
        Load load = display.getLoadType();
        switch (load) {
            case LIGHT: {
                return CoreUtility.capitalizeFirstLetter(Load.LIGHT.toString());
            }
            case MEDIUM: {
                return CoreUtility.capitalizeFirstLetter(Load.MEDIUM.toString());
            }
            case HEAVY: {
                return CoreUtility.capitalizeFirstLetter(Load.HEAVY.toString());
            }
            case OVERLOAD: {
                return CoreUtility.capitalizeFirstLetter(Load.OVERLOAD.toString());
            }
        }
        Logging.errorPrint("Unknown load constant detected in TokenTotal.getLoadToken, the constant was " + (Object)((Object)load) + ".");
        return "Unknown";
    }

    public static String getValueToken(PlayerCharacter pc) {
        return BigDecimalHelper.trimZeros(pc.totalValue()) + " " + SettingsHandler.getGame().getCurrencyDisplay();
    }

    public static String getWeightToken(CharacterDisplay display) {
        return Globals.getGameModeUnitSet().displayWeightInUnitSet(display.totalWeight().doubleValue()) + Globals.getGameModeUnitSet().getWeightUnit();
    }
}

