/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.internal.component.external.model.ExternalModuleComponentGraphResolveState;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ivy.DefaultIvyComponentGraphResolveState;
import org.gradle.internal.component.external.model.ivy.IvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MavenModuleResolveMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.DefaultExternalModuleComponentGraphResolveState;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
public class ModuleComponentGraphResolveStateFactory {
    private final ComponentIdGenerator idGenerator;
    private final AttributeDesugaring attributeDesugaring;

    public ModuleComponentGraphResolveStateFactory(ComponentIdGenerator idFactory, AttributeDesugaring attributeDesugaring) {
        this.idGenerator = idFactory;
        this.attributeDesugaring = attributeDesugaring;
    }

    public ExternalModuleComponentGraphResolveState stateFor(ModuleComponentResolveMetadata metadata) {
        if (metadata instanceof IvyModuleResolveMetadata) {
            IvyModuleResolveMetadata ivyMetadata = (IvyModuleResolveMetadata)metadata;
            return new DefaultIvyComponentGraphResolveState(this.idGenerator.nextComponentId(), ivyMetadata, this.attributeDesugaring, this.idGenerator);
        }
        if (metadata instanceof MavenModuleResolveMetadata) {
            return new DefaultExternalModuleComponentGraphResolveState<ModuleComponentResolveMetadata, ModuleComponentResolveMetadata>(this.idGenerator.nextComponentId(), metadata, metadata, this.attributeDesugaring, this.idGenerator);
        }
        throw new IllegalArgumentException("Unsupported module component metadata type: " + metadata);
    }
}

