/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.promise;

import com.jgoodies.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Promise<T> {
    public State getState();

    default public boolean isPending() {
        return this.getState() == State.PENDING;
    }

    default public boolean isFulfilled() {
        return this.getState() == State.FULFILLED;
    }

    public T get();

    public Promise<T> resolve(T var1);

    public <U> Promise<U> thenApply(Function<? super T, ? extends U> var1);

    public Promise<Void> thenAccept(Consumer<? super T> var1);

    public Promise<Void> thenRun(Runnable var1);

    public <U> Promise<U> thenCompose(Function<? super T, ? extends Promise<U>> var1);

    public static <U> Promise<U> pending() {
        return new DefaultPromise();
    }

    public static <U> Promise<U> of(U value) {
        return new DefaultPromise<U>(value);
    }

    public static final class DefaultPromise<T>
    implements Promise<T> {
        private final List<PromiseWithResolution<T>> chain = new ArrayList<PromiseWithResolution<T>>();
        private State state = State.PENDING;
        private T result;

        DefaultPromise() {
        }

        DefaultPromise(T value) {
            this.resolve(value);
        }

        @Override
        public State getState() {
            return this.state;
        }

        @Override
        public T get() {
            Preconditions.checkState(this.isFulfilled(), "This Promise must be fulfilled to provide a result.");
            return this.result;
        }

        @Override
        public Promise<T> resolve(T value) {
            Preconditions.checkState(this.isPending(), "Cannot resolve, because this Promise has been resolved before: " + this);
            this.state = State.FULFILLED;
            this.result = value;
            this.handleSuccess(value);
            return this;
        }

        @Override
        public <U> Promise<U> thenApply(Function<? super T, ? extends U> fn) {
            DefaultPromise<T> promise = new DefaultPromise<T>();
            this.add(promise, (next, value) -> next.resolve(fn.apply(value)));
            if (this.isFulfilled()) {
                this.handleSuccess(this.result);
            }
            return promise;
        }

        @Override
        public Promise<Void> thenAccept(Consumer<? super T> action) {
            return this.thenApply(result -> {
                action.accept(result);
                return null;
            });
        }

        @Override
        public Promise<Void> thenRun(Runnable action) {
            return this.thenAccept(result -> action.run());
        }

        @Override
        public <U> Promise<U> thenCompose(Function<? super T, ? extends Promise<U>> fn) {
            DefaultPromise<T> promise = new DefaultPromise<T>();
            this.add(promise, (next, value) -> ((Promise)fn.apply(value)).thenAccept(next::resolve));
            if (this.isFulfilled()) {
                this.handleSuccess(this.result);
            }
            return promise;
        }

        public String toString() {
            return String.format("DefaultPromise@%s [state=%s, result=%s, chainCount=%s]", new Object[]{Integer.toHexString(this.hashCode()), this.getState(), this.result, this.chain.size()});
        }

        private void add(Promise<?> promise, BiConsumer<Promise, ? super T> successHandler) {
            this.chain.add(new PromiseWithResolution<T>(promise, successHandler));
        }

        private void handleSuccess(T value) {
            for (PromiseWithResolution<T> promiseWithResolution : this.chain) {
                if (!promiseWithResolution.isPending()) continue;
                promiseWithResolution.handleSuccess(value);
            }
        }

        static final class PromiseWithResolution<T> {
            private final Promise<?> promise;
            private final BiConsumer<Promise, ? super T> successHandler;

            PromiseWithResolution(Promise<?> promise, BiConsumer<Promise, ? super T> successHandler) {
                this.promise = promise;
                this.successHandler = successHandler;
            }

            boolean isPending() {
                return this.promise.isPending();
            }

            void handleSuccess(T value) {
                this.successHandler.accept(this.promise, (Promise<?>)value);
            }
        }
    }

    public static enum State {
        PENDING,
        FULFILLED,
        REJECTED;

    }
}

