/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.tree.TreeNode;
import jrm.locale.Messages;
import jrm.profile.data.PropertyStub;
import jrm.ui.basic.AbstractNGTreeNode;
import org.apache.commons.lang3.StringUtils;

public final class CatVer
extends AbstractNGTreeNode
implements Iterable<Category>,
PropertyStub {
    private final List<Category> list_categories = new ArrayList<Category>();
    public final File file;

    private CatVer(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            TreeMap<String, Category> categories = new TreeMap<String, Category>();
            this.file = file;
            boolean in_section = false;
            while (null != (line = reader.readLine())) {
                SubCategory subcat;
                Category cat;
                String[] kv;
                if (line.equalsIgnoreCase("[Category]")) {
                    in_section = true;
                    continue;
                }
                if (line.startsWith("[") && in_section) break;
                if (!in_section || (kv = StringUtils.split((String)line, (char)'=')).length != 2) continue;
                String k = kv[0].trim();
                String[] v = StringUtils.split((String)kv[1], (char)'/');
                if (v.length != 2) continue;
                String c = v[0].trim();
                String sc = v[1].trim();
                if (!categories.containsKey(c)) {
                    cat = new Category(c, this);
                    categories.put(c, cat);
                } else {
                    cat = (Category)categories.get(c);
                }
                if (!cat.containsKey(sc)) {
                    subcat = new SubCategory(sc, cat);
                    cat.put(sc, subcat);
                } else {
                    subcat = cat.get(sc);
                }
                subcat.add(k);
            }
            this.list_categories.addAll(categories.values());
            for (Category cat : this.list_categories) {
                cat.list_subcategories.addAll(cat.subcategories.values());
            }
            if (this.list_categories.isEmpty()) {
                throw new IOException(Messages.getString("CatVer.NoCatVerData"));
            }
        }
    }

    public static CatVer read(File file) throws IOException {
        return new CatVer(file);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.list_categories.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.list_categories.size();
    }

    @Override
    public TreeNode getParent() {
        return null;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.list_categories.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.list_categories.size() == 0;
    }

    public Enumeration<Category> children() {
        return Collections.enumeration(this.list_categories);
    }

    @Override
    public Object getUserObject() {
        return String.format("%s (%d)", Messages.getString("CatVer.AllCategories"), this.list_categories.stream().flatMap(c -> ((Category)c).list_subcategories.stream().filter(SubCategory::isSelected)).mapToInt(SubCategory::size).sum());
    }

    @Override
    public Iterator<Category> iterator() {
        return this.list_categories.iterator();
    }

    @Override
    public String getPropertyName() {
        return "filter.cat";
    }

    @Override
    public void setSelected(boolean selected) {
        PropertyStub.super.setSelected(selected);
    }

    @Override
    public boolean isSelected() {
        return PropertyStub.super.isSelected();
    }

    public static final class SubCategory
    extends AbstractNGTreeNode
    implements List<String>,
    PropertyStub {
        public final String name;
        private final Category parent;
        private final List<String> games = new ArrayList<String>();

        public SubCategory(String name, Category parent) {
            this.name = name;
            this.parent = parent;
        }

        @Override
        public Iterator<String> iterator() {
            return this.games.iterator();
        }

        @Override
        public int size() {
            return this.games.size();
        }

        @Override
        public boolean isEmpty() {
            return this.games.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.games.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.games.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.games.toArray(a);
        }

        @Override
        public boolean add(String e) {
            return this.games.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.games.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.games.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            return this.games.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends String> c) {
            return this.games.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.games.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.games.retainAll(c);
        }

        @Override
        public void clear() {
            this.games.clear();
        }

        @Override
        public String get(int index) {
            return this.games.get(index);
        }

        @Override
        public String set(int index, String element) {
            return this.games.set(index, element);
        }

        @Override
        public void add(int index, String element) {
            this.games.add(index, element);
        }

        @Override
        public String remove(int index) {
            return this.games.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.games.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.games.lastIndexOf(o);
        }

        @Override
        public ListIterator<String> listIterator() {
            return this.games.listIterator();
        }

        @Override
        public ListIterator<String> listIterator(int index) {
            return this.games.listIterator(index);
        }

        @Override
        public List<String> subList(int fromIndex, int toIndex) {
            return this.games.subList(fromIndex, toIndex);
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return null;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            return 0;
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Enumeration<? extends TreeNode> children() {
            return null;
        }

        @Override
        public Object getUserObject() {
            return this.name + " (" + this.games.size() + ")";
        }

        @Override
        public String getPropertyName() {
            return "filter.cat." + this.parent.name + "." + this.name;
        }

        @Override
        public void setSelected(boolean selected) {
            PropertyStub.super.setSelected(selected);
        }

        @Override
        public boolean isSelected() {
            return PropertyStub.super.isSelected();
        }
    }

    public static final class Category
    extends AbstractNGTreeNode
    implements Map<String, SubCategory>,
    Iterable<SubCategory>,
    PropertyStub {
        public final String name;
        private final CatVer parent;
        private final Map<String, SubCategory> subcategories = new TreeMap<String, SubCategory>();
        private final List<SubCategory> list_subcategories = new ArrayList<SubCategory>();

        public Category(String name, CatVer parent) {
            this.name = name;
            this.parent = parent;
        }

        @Override
        public int size() {
            return this.subcategories.size();
        }

        @Override
        public boolean isEmpty() {
            return this.subcategories.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.subcategories.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.subcategories.containsValue(value);
        }

        @Override
        public SubCategory get(Object key) {
            return this.subcategories.get(key);
        }

        @Override
        public SubCategory put(String key, SubCategory value) {
            return this.subcategories.put(key, value);
        }

        @Override
        public SubCategory remove(Object key) {
            return this.subcategories.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends SubCategory> m) {
            this.subcategories.putAll(m);
        }

        @Override
        public void clear() {
            this.subcategories.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.subcategories.keySet();
        }

        @Override
        public Collection<SubCategory> values() {
            return this.subcategories.values();
        }

        @Override
        public Set<Map.Entry<String, SubCategory>> entrySet() {
            return this.subcategories.entrySet();
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.list_subcategories.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this.list_subcategories.size();
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.list_subcategories.indexOf(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return this.list_subcategories.size() == 0;
        }

        public Enumeration<SubCategory> children() {
            return Collections.enumeration(this.list_subcategories);
        }

        @Override
        public Object getUserObject() {
            return String.format("%s (%d)", this.name, this.list_subcategories.stream().filter(SubCategory::isSelected).mapToInt(SubCategory::size).sum());
        }

        @Override
        public Iterator<SubCategory> iterator() {
            return this.list_subcategories.iterator();
        }

        @Override
        public String getPropertyName() {
            return "filter.cat." + this.name;
        }

        @Override
        public void setSelected(boolean selected) {
            PropertyStub.super.setSelected(selected);
        }

        @Override
        public boolean isSelected() {
            return PropertyStub.super.isSelected();
        }
    }
}

