/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.xml;

import gd.xml.tiny.ParsedXML;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import megamek.common.Hex;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.ITerrain;
import megamek.common.ITerrainFactory;
import megamek.common.Terrains;
import megamek.common.util.StringUtil;

public class HexEncoder {
    public static void encode(IHex iHex, Writer writer) throws IOException {
        ITerrain iTerrain = null;
        int n = 0;
        if (null == iHex) {
            throw new IllegalArgumentException("The hex is null.");
        }
        if (null == writer) {
            throw new IllegalArgumentException("The writer is null.");
        }
        writer.write("<hex version=\"1.0\" >");
        writer.write("<terrains count=\"");
        writer.write(Integer.toString(iHex.terrainsPresent()));
        writer.write("\" elevation=\"");
        writer.write(Integer.toString(iHex.getElevation()));
        if (null != iHex.getTheme()) {
            writer.write("\" theme=\"");
            writer.write(iHex.getTheme());
        }
        writer.write("\" >");
        for (n = 0; n < Terrains.SIZE; ++n) {
            if (!iHex.containsTerrain(n)) continue;
            iTerrain = iHex.getTerrain(n);
            writer.write("<terrain type=\"");
            writer.write(Integer.toString(iTerrain.getType()));
            writer.write("\" level=\"");
            writer.write(Integer.toString(iTerrain.getLevel()));
            writer.write("\" exits=\"");
            writer.write(Integer.toString(iTerrain.getExits()));
            writer.write("\" exitsSpecified=\"");
            writer.write(iTerrain.hasExitsSpecified() ? "true" : "false");
            writer.write("\" />");
        }
        writer.write("</terrains>");
        writer.write("</hex>");
    }

    public static IHex decode(ParsedXML parsedXML, IGame iGame) {
        String string = null;
        int n = 0;
        Hex hex = null;
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        if (null == parsedXML) {
            throw new IllegalArgumentException("The hex is null.");
        }
        if (!parsedXML.getName().equals("hex")) {
            throw new IllegalStateException("Not passed a hex node.");
        }
        Enumeration enumeration = parsedXML.elements();
        while (enumeration.hasMoreElements()) {
            ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
            if (!parsedXML2.getName().equals("terrains")) continue;
            if (null != hex) {
                throw new IllegalStateException("More than one 'terrains' node in a hex node.");
            }
            ITerrain[] iTerrainArray = new ITerrain[Terrains.SIZE];
            Enumeration enumeration2 = parsedXML2.elements();
            while (enumeration2.hasMoreElements()) {
                ParsedXML parsedXML3 = (ParsedXML)enumeration2.nextElement();
                if (!parsedXML3.getName().equals("terrain")) continue;
                try {
                    int n2 = Integer.parseInt(parsedXML3.getAttribute("type"));
                    boolean bl = StringUtil.parseBoolean(parsedXML3.getAttribute("exitsSpecified"));
                    int n3 = Integer.parseInt(parsedXML3.getAttribute("level"));
                    int n4 = Integer.parseInt(parsedXML3.getAttribute("exits"));
                    iTerrainArray[n2] = iTerrainFactory.createTerrain(n2, n3, bl, n4);
                }
                catch (Throwable throwable) {
                    throw new IllegalStateException("Couldn't parse a terrain from a hex node.");
                }
            }
            string = parsedXML2.getAttribute("elevation");
            if (null == string) {
                throw new IllegalStateException("Couldn't decode the terrains for a hex node.");
            }
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Couldn't get an integer from " + string);
            }
            string = parsedXML2.getAttribute("theme");
            hex = new Hex(n, iTerrainArray, string);
        }
        return hex;
    }
}

