/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.CachingDependencyResultFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DetachedComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.api.internal.artifacts.result.DefaultResolutionResult;
import org.gradle.api.internal.artifacts.result.DefaultResolvedComponentResult;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Factory;

public class DefaultResolutionResultBuilder {
    private final Map<Long, DefaultResolvedComponentResult> modules = new HashMap<Long, DefaultResolvedComponentResult>();
    private final CachingDependencyResultFactory dependencyResultFactory = new CachingDependencyResultFactory();

    public static ResolutionResult empty(ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier) {
        DefaultResolutionResultBuilder builder = new DefaultResolutionResultBuilder();
        builder.visitComponent(new DetachedComponentResult(0L, id, VersionSelectionReasons.root(), componentIdentifier, "<empty>", (AttributeContainer)ImmutableAttributes.EMPTY, null));
        return builder.complete(0L);
    }

    public ResolutionResult complete(Long rootId) {
        return new DefaultResolutionResult(new RootFactory(this.modules.get(rootId)));
    }

    public void visitComponent(ComponentResult component) {
        this.create(component.getResultId(), component.getModuleVersion(), component.getSelectionReason(), component.getComponentId(), DefaultResolutionResultBuilder.variantDetails(component), component.getRepositoryName());
    }

    private static ResolvedVariantResult variantDetails(ComponentResult component) {
        return new DefaultResolvedVariantResult(component.getVariantName(), component.getVariantAttributes());
    }

    public void visitOutgoingEdges(Long fromComponent, Collection<? extends org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyResult> dependencies) {
        for (org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyResult dependencyResult : dependencies) {
            UnresolvedDependencyResult dependency;
            DefaultResolvedComponentResult from = this.modules.get(fromComponent);
            if (dependencyResult.getFailure() != null) {
                dependency = this.dependencyResultFactory.createUnresolvedDependency(dependencyResult.getRequested(), from, dependencyResult.getReason(), dependencyResult.getFailure());
            } else {
                DefaultResolvedComponentResult selected = this.modules.get(dependencyResult.getSelected());
                dependency = this.dependencyResultFactory.createResolvedDependency(dependencyResult.getRequested(), from, selected);
                selected.addDependent((ResolvedDependencyResult)dependency);
            }
            from.addDependency((DependencyResult)dependency);
        }
    }

    private void create(Long id, ModuleVersionIdentifier moduleVersion, ComponentSelectionReason selectionReason, ComponentIdentifier componentId, ResolvedVariantResult variant, String repoName) {
        if (!this.modules.containsKey(id)) {
            this.modules.put(id, new DefaultResolvedComponentResult(moduleVersion, selectionReason, componentId, variant, repoName));
        }
    }

    private static class RootFactory
    implements Factory<ResolvedComponentResult> {
        private DefaultResolvedComponentResult rootModule;

        public RootFactory(DefaultResolvedComponentResult rootModule) {
            this.rootModule = rootModule;
        }

        public ResolvedComponentResult create() {
            return this.rootModule;
        }
    }
}

