/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Collections;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.internal.provider.events.AbstractOperationResult;
import org.gradle.tooling.internal.provider.events.DefaultFailure;
import org.gradle.tooling.internal.provider.events.DefaultFailureResult;
import org.gradle.tooling.internal.provider.events.DefaultOperationDescriptor;
import org.gradle.tooling.internal.provider.events.DefaultOperationFinishedProgressEvent;
import org.gradle.tooling.internal.provider.events.DefaultOperationStartedProgressEvent;
import org.gradle.tooling.internal.provider.events.DefaultSuccessResult;

class ClientForwardingBuildOperationListener
implements BuildOperationListener {
    private final BuildEventConsumer eventConsumer;

    ClientForwardingBuildOperationListener(BuildEventConsumer eventConsumer) {
        this.eventConsumer = eventConsumer;
    }

    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        this.eventConsumer.dispatch((Object)new DefaultOperationStartedProgressEvent(startEvent.getStartTime(), this.toBuildOperationDescriptor(buildOperation)));
    }

    public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
    }

    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent result) {
        this.eventConsumer.dispatch((Object)new DefaultOperationFinishedProgressEvent(result.getEndTime(), this.toBuildOperationDescriptor(buildOperation), this.adaptResult(result)));
    }

    private DefaultOperationDescriptor toBuildOperationDescriptor(BuildOperationDescriptor buildOperation) {
        OperationIdentifier id = buildOperation.getId();
        String name = buildOperation.getName();
        String displayName = buildOperation.getDisplayName();
        OperationIdentifier parentId = buildOperation.getParentId();
        return new DefaultOperationDescriptor((Object)id, name, displayName, (Object)parentId);
    }

    private AbstractOperationResult adaptResult(OperationFinishEvent result) {
        Throwable failure = result.getFailure();
        long startTime = result.getStartTime();
        long endTime = result.getEndTime();
        if (failure != null) {
            return new DefaultFailureResult(startTime, endTime, Collections.singletonList(DefaultFailure.fromThrowable((Throwable)failure)));
        }
        return new DefaultSuccessResult(startTime, endTime);
    }
}

