/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		prt_sr_elements.lex
Dates:		3 Sept. 2007
Purpose:	print the subrule's symbols.
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |prt_sr_elements.lex| Grammar.\fbreak
Layout those elements on the subrule's rhs.
Its output is directed to the grammar's index document being
generated from the |prt_xrefs_docs.lex| grammar.
@/
fsm	
(fsm-id "prt_sr_elements.lex",fsm-filename prt_sr_elements,fsm-namespace NS_prt_sr_elements
,fsm-class Cprt_sr_elements{
  user-prefix-declaration
#include "o2_externs.h"
extern void XLATE_SYMBOLS_FOR_cweave(const char* Sym_to_xlate,char* Xlated_sym);
  ***
  user-declaration
    public:
      char big_buf_[BIG_BUFFER_32K];		
      std::ofstream* ow_index_file_;
      int elem_no_;
  ***
  op
elem_no_= 0;
  ***
}
,fsm-version "1.0",fsm-date "Sep. 2007",fsm-debug "false"
,fsm-comments "Print the subrule's symbol string.")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rprt_sr_elements  (){
  -> Rsubrule eog
}

Rsubrule  (){
  -> Rsubrule_def Relements
}

Rsubrule_def  (){
  -> "subrule-def" {
  op
    Cprt_sr_elements* fsm = (Cprt_sr_elements*)rule_info__.parser__->fsm_tbl__;
    fsm->elem_no_ = 0;
  ***
  }
}

Relements  (){
  -> Relement
  -> Relements Relement
}

Relement
/@
Use of \invisibleshift to make grammar lr(1).
@/ 
 
(){
  -> "refered-T" |.| {
  op
    Cprt_sr_elements* fsm = (Cprt_sr_elements*)rule_info__.parser__->fsm_tbl__;
    ++fsm->elem_no_;
       char xlated_sym[Max_cweb_item_size];
       XLATE_SYMBOLS_FOR_cweave(sf->p1__->its_t_def()->t_name()->c_str(),xlated_sym);
       strcat(xlated_sym,"\\ \\ ");
       *fsm->ow_index_file_ << xlated_sym << endl;
  ***
  }
  -> "refered-rule" {
  op
    Cprt_sr_elements* fsm = (Cprt_sr_elements*)rule_info__.parser__->fsm_tbl__;
    ++fsm->elem_no_;
       char xlated_sym[Max_cweb_item_size];
       XLATE_SYMBOLS_FOR_cweave(sf->p1__->its_rule_def()->rule_name()->c_str(),xlated_sym);
       strcat(xlated_sym,"\\ \\ ");
       *fsm->ow_index_file_ << xlated_sym << endl;
  ***
  }
  -> "eosubrule" {
  op
    Cprt_sr_elements* fsm = (Cprt_sr_elements*)rule_info__.parser__->fsm_tbl__;
    ++fsm->elem_no_;
    if(fsm->elem_no_ == 1){// epsilon
	  KCHARP eps = "$\\epsilon$";
        *fsm->ow_index_file_ << eps << endl;
	}
  ***
  }
  -> "refered-T" "refered-T" "called thread eosubrule" {
  op
    Cprt_sr_elements* fsm = (Cprt_sr_elements*)rule_info__.parser__->fsm_tbl__;
    ++fsm->elem_no_;    
       char xlated_sym[Max_cweb_item_size];
       XLATE_SYMBOLS_FOR_cweave(sf->p1__->its_t_def()->t_name()->c_str(),xlated_sym);
       strcat(xlated_sym,"\\ \\ ");
       *fsm->ow_index_file_ << xlated_sym << endl;
    ++fsm->elem_no_;
       char rtned_xlated_sym[Max_cweb_item_size];
      XLATE_SYMBOLS_FOR_cweave(sf->p2__->its_t_def()->t_name()->c_str(),rtned_xlated_sym);
       strcat(rtned_xlated_sym,"\\ \\ ");
       *fsm->ow_index_file_ << rtned_xlated_sym << endl;

    ++fsm->elem_no_;
        char thd_xlated_sym[Max_cweb_item_size];
        char full_thd_name[Max_cweb_item_size];
        KCHARP full_thd_name_template = "%s::%s";
        sprintf(full_thd_name,full_thd_name_template
              ,sf->p3__->ns()->identifier()->c_str()
              ,sf->p3__->called_thread_name()->identifier()->c_str()
              );
       XLATE_SYMBOLS_FOR_cweave((const char*)full_thd_name,thd_xlated_sym);
       *fsm->ow_index_file_ << thd_xlated_sym << endl;
  ***
  }
  -> "refered-T" "refered-T" "null call thread eosubrule" {
  op
    Cprt_sr_elements* fsm = (Cprt_sr_elements*)rule_info__.parser__->fsm_tbl__;
    ++fsm->elem_no_;    
       char xlated_sym[Max_cweb_item_size];
       XLATE_SYMBOLS_FOR_cweave(sf->p1__->its_t_def()->t_name()->c_str(),xlated_sym);
       strcat(xlated_sym,"\\ \\ ");
       *fsm->ow_index_file_ << xlated_sym << endl;
    ++fsm->elem_no_;
       char rtned_xlated_sym[Max_cweb_item_size];
       XLATE_SYMBOLS_FOR_cweave(sf->p2__->its_t_def()->t_name()->c_str(),rtned_xlated_sym);
       strcat(rtned_xlated_sym,"\\ \\ ");
       *fsm->ow_index_file_ << rtned_xlated_sym << endl;
    ++fsm->elem_no_;
       *fsm->ow_index_file_ << "NULL" << endl;
  ***
  }
  -> "refered-T" "refered-T" |.|{
  op
    Cprt_sr_elements* fsm = (Cprt_sr_elements*)rule_info__.parser__->fsm_tbl__;
    ++fsm->elem_no_;    
       char xlated_sym[Max_cweb_item_size];
       XLATE_SYMBOLS_FOR_cweave(sf->p1__->its_t_def()->t_name()->c_str(),xlated_sym);
       strcat(xlated_sym,"\\ \\ ");
       *fsm->ow_index_file_ << xlated_sym << endl;
    ++fsm->elem_no_;
       char xlated_2_sym[Max_cweb_item_size];
       XLATE_SYMBOLS_FOR_cweave(sf->p2__->its_t_def()->t_name()->c_str(),xlated_2_sym);
       strcat(xlated_2_sym,"\\ \\ ");
       *fsm->ow_index_file_ <<  xlated_2_sym << endl;
  ***
  }
}

}// end of rules
