/* MakeTeXMF -- create a missing parameter file for METAFONT.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


prog = 'MakeTeXMF';
exec = '@';

parse arg full env;

if full = '' then
  call usage;

full = extend(full, '.mf');
name = tolower(substr(full, 1, lastpos('.', full) - 1));

do i = 1
  char = substr(name, i, 1);
  if char = '' | char < 'a' | char > 'z' then
    leave;
end;

font = substr(name, 1, i - 1);
size = substr(name, i);

if font = '' | size = '' then
  call usage name||': I cannot use this font name';
if \datatype(size, 'number') then
  call usage size||': This should be a number';

base = substr(name, 1, 2);
select
  when base = 'cm' then
    do
      exec 'echo %%' full||'>' full;
      exec 'echo design_size :=' size||';>>' full;
      exec 'echo input b-'||font||';>>' full;
    end;
  when base = 'dc' then
    do
      exec 'echo %%' full||'>' full;
      exec 'echo if unknown dxbase: input dxbase fi;>>' full;
      exec 'echo gensize :=' size||'; generate' font||'>>' full;
    end;
  otherwise
    call usage font||': I don''t know how to scale this font';
end;

call output full;

return 0;


usage: procedure expose prog
  parse arg message;
  if message = '' then
    do
      call errput 'Usage:  '||prog||' <font>';
      call errput '';
      call errput '	<font>  base name of the font, e.g., `cmr10''';
    end;
  else
    call errput prog||':' message;
  exit 1;

output: procedure
  parse arg all;
  call lineout 'stdout', all;
  return result;

errput: procedure
  parse arg all;
  call lineout 'stderr', all;
  return result;


/* REXXLIB: extend tolower */

extend: procedure
  parse arg str, ext;
  len = length(ext);
  if len > 0 then
    do
      if right(str, len) \= ext then
        str = str||ext;
    end;
  return str;

tolower: procedure
  parse arg str;
  lower = 'abcdefghijklmnopqrstuvwxyz';
  upper = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  return translate(str, lower, upper);
