#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define BUF_SIZE 2048


unsigned swap(unsigned char *p)
{
  unsigned char b[2];
  b[1] = p[0];
  b[0] = p[1];
  return(*(unsigned*)b);
}

void main(int argc, char *argv[])
{
  FILE *f = stdin, *g = stdout;
  static unsigned char buf[BUF_SIZE], bytes[BUF_SIZE/16];
  int n_bytes_in_line, len, width, height, i, mask, hot_x, hot_y;
  short integer_p = 0, standard_p = 0;
  char name[64] = "bitmap";
  char outfname[64];
  char *p, *bp, *name_start;

  while (argc > 1) {
    if (!strcmp(argv[1], "-i"))
      integer_p = 1;
    else if (!strcmp(argv[1], "-s"))
      standard_p = 1;
    else
      break;
    --argc;
    ++argv;
  }
  if (argc > 1) {
    if ((f = fopen(argv[1], "r")) == NULL) {
      fprintf(stderr, "can't open %s\n", argv[1]);
      exit(1);
    }
    if (argc > 2)
      strcpy(name, argv[2]);
    else {
      name_start = strrchr(argv[1], '\\');
      if (name_start == NULL)
        name_start = argv[1];
      else
        ++name_start;
      strcpy(name, name_start);
      p = strchr(name, '.');
      if (p != NULL)
	*p = '\0';
      strlwr(name);
    }
  }
  if (fgets(buf, BUF_SIZE, f) == NULL) {
    fprintf(stderr, "empty input\n");
    exit(1);
  }
  sprintf(outfname, "bitmap\\%s.c", name);
  if ((g = fopen(outfname, "w")) == NULL) {
    fprintf(stderr, "can't open %s for output\n", outfname);
    exit(1);
  }
  fprintf(g, "/* bitmap */\n");

  if (sscanf(buf, "%d %d", &hot_x, &hot_y) == 2)
    fprintf(g, "#define %s_hot_x %d\n"
	    "#define %s_hot_y %d\n",
	    name, hot_x, name, hot_y);

  if (standard_p)
    fprintf(g, "#ifdef EXTERN_BITMAP_DECL\n"
	       "extern unsigned%s %s_bits[];\n"
	       "#else\n",
	       integer_p ? "" : " char", name);

  fprintf(g, "%sunsigned%s %s_bits[] = {\n  ",
	  standard_p ? "" : "static ",
	  integer_p ? "" : " char", name);

  height = 0;
  width = strlen(buf) - 1; buf[width] = '\0';
  n_bytes_in_line = (width + 7) / 8;
  while (fgets(buf, BUF_SIZE, f) && (len = strlen(buf)) != 0) {
    memset(bytes, 0, sizeof bytes);
    bp = bytes - 1;
    mask = 1;
    for (i = 0; i < len; ++i) {
      if ((mask >>= 1) == 0) {
	mask = 0x80;
	++bp;
      }
      if (buf[i] == '*')
	*bp |= mask;
    }
    if (integer_p) {
      for (i = 0; i < n_bytes_in_line - 2; i += 2)
	fprintf(g, "0x%04x,", swap(&bytes[i]));
      fprintf(g, "0x%04x,\n  ", swap(&bytes[i]));
    }
    else {
      for (i = 0; i < n_bytes_in_line - 1; ++i)
	fprintf(g, "0x%02x,", (unsigned)bytes[i]);
      fprintf(g, "0x%02x,\n  ", (unsigned)bytes[n_bytes_in_line - 1]);
    }
    ++height;
  }
  fprintf(g,
	  "};\n"
	  "%s"
	  "#define %s_width %d\n"
	  "#define %s_height %d\n",
	  standard_p ? "#endif\n" : "",
	  name, width, name, height);
  fclose(g);
}
