/*
 * SOURCE:  main.h
 * PROJECT: EasyTeX
 *
 * PURPOSE: function prototypes and defines
 *
 * UPDATES: 08/15/1991 - major rewrite
 *
 * (c)M.Schollmeyer
 */
#ifndef MAIN_H
#define MAIN_H

#include <bios.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <direct.h>
#include <conio.h>
#include <string.h>
#include <io.h>
#include <process.h>
#include <signal.h>
#include <ctype.h>
#include <stdarg.h>

#include "macros.h"
#include "video.h"
#include "setting.h"
#include "intui.h"
#include "bios.h"
#include "edit.h"
#include "dos.h"
#include "applic.h"
#include "profile.h"
#include "help.h"
#include "memory.h"
#include "filereq.h"
#include "compress.h"
#include "smakec.h"
#include "texerr.h"
#include "colors.h"
#include "init.h"

#if !defined RDEL_C
#include "topic.h"
#endif

/* shared memory region */
struct SharedMemory {
    long magic;
    char OvlName[127];
    char Reserved[14];
    char OvlArgs[127];
    char WaitFlag;
    char ReturnType;
    char ReturnCode;
    char ExitCode;
};

#define SM_MAGIC 0x34f65da2L

            // defaults for options
#define DEF_TEXCMD "tex %(tex) %/%b.%e"
#define DEF_PREVIEWCMD "dviscr %(preview) %p%b.dvi"
#define DEF_PRINTCMD "dvihplj %(print) %p%b.dvi"
#define DEF_PSCRIPTCMD "dvips %(postscript) %p%b.dvi"
#define DEF_PRINTOUT "prn"

        // flags for searchstring
#define QUERYSEARCH 1
#define CONTSEARCH  2

#define MENUWIDTH 63 // width of menu bar

        // flags for LaunchOverlay() */
#define LO_WAIT 1
#define LO_NOECHO 2

BOOL setvmode( int );

        // function prototypes
void ShowMenu( void );
void HideMenu( void );

int EventHandler( struct InputEvent *ie );

void searchstring( int );


void LaunchOverlay( char *, int );

void MakeShortName( char *, char *, int );
unsigned int _printtime( int );
void _interrupt _far critical_error( unsigned, unsigned, unsigned,
unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned,
unsigned, unsigned, unsigned );


BOOL _saverequest( char *);
BOOL _createrequest( char *);

void getfile( void );     /* try to load current file */

int CreateTmp( char *, unsigned int );
void DeleteTmps( void );
void DeleteTeXTmps( void );

void updatemenu( void );
void dta_datetoa( unsigned long, char _far * );

int packstr( char * ); // eliminates leading blanks, 1 if blanks detected
                       // -1 if string empty

#endif
