#include <io.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/doscalls.h>
#include <sys/dostime.h>

#define ACC(x) (((x)>>6)*0111)

static long _sys_ino = 0x10000;

int __stat (const char *name, struct stat *statbuf)
{
    struct find_t find;
    unsigned long gmt;

    if (name == NULL)
	return -1;

    /* find : dir, system, hidden */
    dos_setdta(&find);
    if (dos_findfirst(name, 0x16) == -1) {
	/* error: must be a root dir */
	char path[260];
	unsigned olddrive, newdrive;
	int ret;

	olddrive = dos_getdrive();
	if (name[1] == ':') {
	    newdrive = (unsigned) *name;
	    if (newdrive >= 'a')
		newdrive -= 0x20;
	    if (newdrive < 'A' || newdrive > 'Z')
		return -1;
	    newdrive -= 'A';
	    if (newdrive != olddrive)
		dos_setdrive(newdrive);
	} else
	    newdrive = olddrive;
	dos_getcwd(0, path);
	ret = dos_chdir(name);
	dos_chdir(path);		/* restore path */
	if (newdrive != olddrive)	/* restore drive */
	    dos_setdrive(olddrive);
	if (ret == -1)
	    return -1;		/* no root, error */
	statbuf->st_mode = S_IFDIR | ACC(S_IREAD | S_IWRITE | S_IEXEC);
	statbuf->st_size = 0L;
	statbuf->st_dev = (long) newdrive;
	gmt = 0;
    } else {
	struct file_time ft;

	if (find.attrib & 0x10) {	/* directory */
	    statbuf->st_mode = S_IFDIR | ACC(S_IREAD | S_IWRITE | S_IEXEC);
	    statbuf->st_size = 0L;
	} else {
	    statbuf->st_mode = S_IFREG; /* file */
	    statbuf->st_mode |= ACC(S_IREAD);
	    if (!(find.attrib & 0x1))	/* test read only */
		statbuf->st_mode |= ACC(S_IWRITE);	/* Read-write access */
	    statbuf->st_size = (long) find.size_hi << 16 | find.size_lo;
	}
	ft.ft_date = find.wr_date;
	ft.ft_time = find.wr_time;
	gmt = filetime2gmt(&ft);
	if (find.name[1] == ':')
	    statbuf->st_dev = (long) (find.name[0] - 'A');
	else
	    statbuf->st_dev = dos_getdrive();
    }
    /* all */
    statbuf->st_atime = gmt;
    statbuf->st_ctime = gmt;
    statbuf->st_mtime = gmt;
    statbuf->st_rdev = statbuf->st_dev;
    statbuf->st_uid = 0L;
    statbuf->st_gid = 0L;
    statbuf->st_ino = _sys_ino++;
    statbuf->st_nlink = 1L;
    statbuf->st_blksize = 4096;
    return 0;
}
