package require Cpptcl 2.0
package require Itcl 2.2

option add *Hierarchy.borderWidth 2 widgetDefault
option add *Hierarchy.relief sunken widgetDefault
option add *Hierarchy.scrollMargin 3 widgetDefault
option add *Hierarchy.vscrollMode static widgetDefault
option add *Hierarchy.hscrollMode static widgetDefault
option add *Hierarchy.width 200 widgetDefault
option add *Hierarchy.height 230 widgetDefault
option add *Hierarchy.labelPos n widgetDefault
option add *Hierarchy.autoResize 1 widgetDefault
#option add *Hierarchy.autoMargin 20 widgetDefault

itk::usual cpp::Hierarchy {
    keep -activebackground -activerelief -background -borderwidth -cursor \
         -elementborderwidth -foreground -highlightcolor \
         -highlightthickness -insertbackground -insertborderwidth \
         -insertofftime -insertontime -insertwidth -jump -labelfont \
         -selectbackground -selectborderwidth -selectforeground \
         -textbackground -troughcolor
}

itcl::class cpp::Hierarchy {
	inherit iwidgets::Scrolledcanvas

	constructor {args} {}

    itk_option define -orient orient Orient horizontal

	destructor {}
	method theCanvas {} { return $itk_component(scrCanvas) }
	method update {} { pure_virtual update }
	method draw {} {}
	method clear {} {}
	method add {widget name parents} {}
}

option add *Tree.borderWidth 2 widgetDefault
option add *Tree.relief sunken widgetDefault
option add *Tree.scrollMargin 3 widgetDefault
option add *Tree.vscrollMode static widgetDefault
option add *Tree.hscrollMode static widgetDefault
option add *Tree.width 200 widgetDefault
option add *Tree.height 230 widgetDefault
option add *Tree.labelPos n widgetDefault
option add *Tree.autoResize 1 widgetDefault
#option add *Tree.autoMargin 20 widgetDefault

itk::usual Tree {
	#keep -activebackground -activerelief -background -borderwidth -cursor \
         -elementborderwidth -foreground -highlightcolor \
         -highlightthickness -insertbackground -insertborderwidth \
         -insertofftime -insertontime -insertwidth -jump -labelfont \
         -selectbackground -selectborderwidth -selectforeground \
         -textbackground -troughcolor
}

itcl::class cpp::TreeHierarchy {
	inherit cpp::Hierarchy 

	constructor {args} {}

	destructor {}
	
	public variable layout "horizontal"

	method update {} {}
	method draw {} { $itk_component(tree) draw }
	method clear {} {}

	method add {widget name parent} {}
		
}

body cpp::TreeHierarchy::constructor {args} {
	itk_component add tree {
		tree $itk_interior.tree
	}
	pack $itk_component(tree)
	#
	# Set the bindings for the tree canvas.
	#
	bind text <1> [code $this selectnode]
	bind bitmap <1> [code $this selectbitmap]
	bind text <Shift-1> [code $this selectnode]
	bind bitmap <Shift-1> [code $this selectbitmap]
	#cpxtreeBindings [mycanvas] [mytree]
	#cpxtreeSetupDrag&Drop $canvas $tree

	eval itk_initialize $args
}

body cpp::TreeHierarchy::clear {} { 
	$itk_component(tree) prune "" 
	foreach w [winfo children $itk_component(scrCanvas)] {
		if { $w != $itk_component(tree) } {
			destroy $w
			#delete object $w
		}
	}
}

body cpp::TreeHierarchy::add {widget name parent} {
	$itk_component(scrCanvas) create window -500 -500 \
		-tags "text object $name" \
		-window $widget
	set line [$itk_component(scrCanvas) create line 0 0 0 0 \
			  -tag "line" -width 1 -capstyle round -fill white ]
	tkwait visibility $widget

	#$itk_component(canvas) itemconfig $name \
	#	-width [winfo reqwidth $item] -height [winfo reqheight $item]

    $itk_component(scrCanvas) itemconfig $name -anchor w
	$itk_component(scrCanvas).tree addlink $parent $name $line -border 2

	#$itk_component(scrCanvas).tree nodeconfig $name
	#-remove "$this delete"
	
}

itcl::class cpp::FinderHierarchy {
	inherit cpp::Hierarchy 

	constructor {args} {}

	destructor {}
	
	method update {} {}
	method draw {} { $itk_component(finder) draw }
	method clear {} {}

	method add {widget name parent} {}
		
}
