//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 27th September, 2014
//
//

package worker4math.hktex2;

import java.util.ArrayList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;

public class ParagraphFormatting {
	
	
	public void paragraphformatting(Canvas canvas, ParagraphBlock paragraphblock,  Float pagelength, String paragraph, Integer tid, Float indent, 
			String thisattribute, Typeface tf){
		
		ArrayList<String> line = new ArrayList<String>();
		ArrayList<Float> width = new ArrayList<Float>();
		ArrayList<Float> height = new ArrayList<Float>();
		ArrayList<Float> depth = new ArrayList<Float>();
		ArrayList<Float> xpos = new ArrayList<Float>();
		ArrayList<Float> ypos = new ArrayList<Float>(); 
		ArrayList<String> attribute = new ArrayList<String>();
		ArrayList<Float> tlinelength = new ArrayList<Float>();
		Float linelength = 0.0f;
		Boolean newfirstline = false;
		
        int i=0;
        int ii=0;
        int jj=0;
        int j=0;
        int linenu=0;
        int fontsize = Integer.parseInt(thisattribute.substring(1,4));
        
        boolean dohyphenation=true;
        
        float spacelength = 0.0f;
        float newlinelength = 0.0f;
        float linelength1=0.0f;
        
    	Paint textpaint = new Paint();
	    textpaint.setColor(Color.BLACK);	  	       
	  	textpaint.setTextSize(fontsize); 
	  	textpaint.setTypeface(tf);
	  	synchronized(this){paragraphblock.init(tid);}
	  	
	  	newfirstline=false;

	  	spacelength=textpaint.measureText(" ");
	  	Hyphenator hyphenate = new Hyphenator();	  	

	  	paragraph=paragraph.trim();
	  	String words[] = paragraph.split(" ");
	  	String word="";
	  	int sizej = words.length; 
	  	j=0;
	  	line.add("");linenu=0;width.add(0.0f);height.add((float)fontsize);depth.add(0.0f);xpos.add(indent);ypos.add(0.0f);attribute.add(thisattribute);
	  	linelength=indent;
	  	for (i=0;j<=sizej-1;i++){
	  		word=words[j].trim();
	  		word=words[j];
	  		if (word.equals("")){j++;} else{
	  			String line2=line.get(linenu)+word;
	  			linelength1=linelength;
	  			linelength=indent+textpaint.measureText(line2);
	  			if (linelength  > pagelength){
	
	  				dohyphenation=true;	  
	  				linelength=linelength1;
	  				if (word.contains("-")){
	  					dohyphenation=false;
	  					int sw=word.indexOf("-");
	  					String tword1=word.substring(0,sw+1);
	  					String tword2=word.substring(sw+1);
		  
	  					line2=line.get(linenu)+tword1;
	  					linelength1=linelength;
	  					linelength=indent+textpaint.measureText(line2);
	  					if (linelength  > pagelength){	  
	  						if (linenu==0 && i==0){newfirstline=true;};
	  						linelength=linelength1;
	  						line.add("");linenu++;width.add(0.0f);height.add((float)fontsize);depth.add(0.0f);xpos.add(0.0f);ypos.add(0.0f);attribute.add(thisattribute);
	  						indent=0.0f;
	  						line.set(linenu, word+" ");
	  						linelength=indent+textpaint.measureText(line.get(linenu));
	  						width.set(linenu, linelength);
	  						ypos.set(linenu, ypos.get(linenu-1)+fontsize);
	  					}
	  					else {
	  						line.set(linenu,line.get(linenu)+tword1);	 	    	 
	  						width.set(linenu, linelength-indent);   	  
	  						line.add("");linenu++;width.add(0.0f);height.add((float)fontsize);depth.add(0.0f);xpos.add(0.0f);ypos.add(0.0f);attribute	 .add(thisattribute);
	  						indent=0.0f;
	  						line.set(linenu, tword2+" ");
	  						linelength=textpaint.measureText(line.get(linenu));
	  						width.set(linenu, linelength);
	  						ypos.set(linenu, ypos.get(linenu-1)+fontsize+Header.linegap);
	  					};
	  					j++;
	  				} 
	  				if(dohyphenation){
	  					String hyphenatedword = hyphenate.hyphenate(word);
	  					String splitword[] = hyphenatedword.split("-");
	  					int sizejj=splitword.length;
	  					if (sizejj-1 >=1 && splitword[sizejj-1].length()<=2){splitword[sizejj-2]=splitword[sizejj-2]+splitword[sizejj-1]; sizejj--;};
	  					newlinelength=0;
	  					jj=0;
	  					for (ii=0;jj<=sizejj-1;ii++){
	  						line2=line.get(linenu)+splitword[jj]+"-";
	  						linelength1=indent+textpaint.measureText(line2);
	  						if (linelength1 > pagelength){
	  							if (linenu==0 && i==0 && ii==0){newfirstline=true;};
	  							if (jj!=0){ line.set(linenu,line.get(linenu)+"-");}
	  							line.add("");linenu++;width.add(0.0f);height.add((float)fontsize);depth.add(0.0f);xpos.add(0.0f);ypos.add(0.0f);attribute.add(thisattribute);
	  							indent=0.0f;
	  							for (int iii=0;jj<=sizejj-1 && iii<1000;iii++){
	  								line.set(linenu, line.get(linenu)+splitword[jj]);
	  								newlinelength=textpaint.measureText(line.get(linenu));
	  								jj++;}
	  							line.set(linenu, line.get(linenu)+" ");  		
	  							ypos.set(linenu, ypos.get(linenu-1)+fontsize);
	  						}else {		    			  
	  							line.set(linenu,line.get(linenu)+splitword[jj]);
	  							linelength=indent+textpaint.measureText(line.get(linenu));
	  							width.set(linenu, linelength-indent);
	  							jj++;
	  						}
	  					}
	  					linelength=newlinelength+spacelength;		
	  					width.set(linenu, linelength-indent);
	  					newlinelength=0;
	  					j++;
	  				}
	  			}else{
	  				line.set(linenu,line.get(linenu)+word+" ");
	  				linelength=indent+textpaint.measureText(line.get(linenu));
	  				width.set(linenu, linelength-indent);
	  				j++;}
	  		}}
	  	linelength= linelength+spacelength;width.set(linenu, width.get(linenu)+spacelength);
		
	  	for (i=0;i<=linenu;i++){
	  		tlinelength.add(textpaint.measureText(line.get(i)));
	  	}
	  	synchronized(this){paragraphblock.add(tid, line, width, height, depth, xpos,ypos, attribute, tlinelength, linelength, newfirstline);};
	}
}
