/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import net.sourceforge.texlipse.actions.TexInsertMathSymbolAction;
import net.sourceforge.texlipse.model.TexCommandContainer;
import net.sourceforge.texlipse.model.TexCommandEntry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditorActionContributor;

public class TexEditorActionContributor
extends TextEditorActionContributor {
    private TexInsertMathSymbolAction[] greekSmall = new TexInsertMathSymbolAction[TexCommandContainer.greekSmall.length];
    private TexInsertMathSymbolAction[] greekCapital = new TexInsertMathSymbolAction[TexCommandContainer.greekCapital.length];
    private TexInsertMathSymbolAction[] arrows = new TexInsertMathSymbolAction[TexCommandContainer.stdArrows.length];
    private TexInsertMathSymbolAction[] stdCompare = new TexInsertMathSymbolAction[TexCommandContainer.stdCompare.length];
    private TexInsertMathSymbolAction[] stdBinOp = new TexInsertMathSymbolAction[TexCommandContainer.stdBinOpSymbols.length];
    private TexInsertMathSymbolAction[] stdBraces = new TexInsertMathSymbolAction[TexCommandContainer.stdBraces.length];
    private TexInsertMathSymbolAction[] stdAccents = new TexInsertMathSymbolAction[TexCommandContainer.stdAccents.length];

    private void createMathActions(TexInsertMathSymbolAction[] actions, TexCommandEntry[] commands) {
        int i = 0;
        while (i < commands.length) {
            actions[i] = new TexInsertMathSymbolAction(commands[i]);
            ++i;
        }
    }

    public TexEditorActionContributor() {
        this.createMathActions(this.greekSmall, TexCommandContainer.greekSmall);
        this.createMathActions(this.greekCapital, TexCommandContainer.greekCapital);
        this.createMathActions(this.arrows, TexCommandContainer.stdArrows);
        this.createMathActions(this.stdCompare, TexCommandContainer.stdCompare);
        this.createMathActions(this.stdBinOp, TexCommandContainer.stdBinOpSymbols);
        this.createMathActions(this.stdBraces, TexCommandContainer.stdBraces);
        this.createMathActions(this.stdAccents, TexCommandContainer.stdAccents);
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        IMenuManager gotoMenu = menuManager.findMenuUsingPath("navigate/goTo");
        if (gotoMenu != null) {
            gotoMenu.add((IContributionItem)new Separator("additions2"));
        }
        IMenuManager editMenu = menuManager.findMenuUsingPath("window");
        MenuManager manager = new MenuManager("Latex Symbols");
        if (editMenu != null) {
            menuManager.insertBefore("window", (IContributionItem)manager);
            MenuManager smallGreekMenu = new MenuManager("Greek lower case");
            MenuManager captialGreekMenu = new MenuManager("Greek upper case");
            MenuManager arrowsMenu = new MenuManager("Arrows");
            MenuManager compareMenu = new MenuManager("Compare symbols");
            MenuManager stdBinOpMenu = new MenuManager("Binary Operator");
            MenuManager stdBracesMenu = new MenuManager("Braces");
            MenuManager stdAccentsMenu = new MenuManager("Accents");
            manager.add((IContributionItem)captialGreekMenu);
            manager.add((IContributionItem)smallGreekMenu);
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)arrowsMenu);
            manager.add((IContributionItem)compareMenu);
            manager.add((IContributionItem)stdBinOpMenu);
            manager.add((IContributionItem)stdBracesMenu);
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)stdAccentsMenu);
            int i = 0;
            while (i < this.greekSmall.length) {
                smallGreekMenu.add((IAction)this.greekSmall[i]);
                ++i;
            }
            i = 0;
            while (i < this.greekCapital.length) {
                captialGreekMenu.add((IAction)this.greekCapital[i]);
                ++i;
            }
            i = 0;
            while (i < this.arrows.length) {
                arrowsMenu.add((IAction)this.arrows[i]);
                ++i;
            }
            i = 0;
            while (i < this.stdCompare.length) {
                compareMenu.add((IAction)this.stdCompare[i]);
                ++i;
            }
            i = 0;
            while (i < this.stdBinOp.length) {
                stdBinOpMenu.add((IAction)this.stdBinOp[i]);
                ++i;
            }
            i = 0;
            while (i < this.stdBraces.length) {
                stdBracesMenu.add((IAction)this.stdBraces[i]);
                ++i;
            }
            i = 0;
            while (i < this.stdAccents.length) {
                stdAccentsMenu.add((IAction)this.stdAccents[i]);
                ++i;
            }
        }
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        int i = 0;
        while (i < this.greekSmall.length) {
            this.greekSmall[i].setActiveEditor(part);
            ++i;
        }
        i = 0;
        while (i < this.greekCapital.length) {
            this.greekCapital[i].setActiveEditor(part);
            ++i;
        }
        i = 0;
        while (i < this.arrows.length) {
            this.arrows[i].setActiveEditor(part);
            ++i;
        }
        i = 0;
        while (i < this.stdCompare.length) {
            this.stdCompare[i].setActiveEditor(part);
            ++i;
        }
        i = 0;
        while (i < this.stdBinOp.length) {
            this.stdBinOp[i].setActiveEditor(part);
            ++i;
        }
        i = 0;
        while (i < this.stdBraces.length) {
            this.stdBraces[i].setActiveEditor(part);
            ++i;
        }
        i = 0;
        while (i < this.stdAccents.length) {
            this.stdAccents[i].setActiveEditor(part);
            ++i;
        }
    }
}

