/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.actions.InputQueryDialog;
import net.sourceforge.texlipse.builder.BuilderRegistry;
import org.eclipse.swt.widgets.Display;

public class OutputScanner {
    private BufferedInputStream in;
    private OutputStream out;
    private String[] triggerString;
    private boolean okPressed;
    private String query;
    private StringBuilder sb;
    protected int currentTriggerStringLength;
    private String consoleOutput;

    public OutputScanner(InputStream in, OutputStream out, String[] trig, String console) {
        this.in = new BufferedInputStream(in);
        this.out = out;
        this.triggerString = trig;
        this.okPressed = false;
        this.query = null;
        this.sb = new StringBuilder();
        this.consoleOutput = console;
    }

    public String getText() {
        return this.sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean scanOutput() {
        try {
            int startOfLine = 0;
            int okIndex = 0;
            int maxLength = 0;
            if (this.triggerString != null) {
                int i = 0;
                while (i < this.triggerString.length) {
                    if (maxLength < this.triggerString[i].length()) {
                        maxLength = this.triggerString[i].length();
                    }
                    ++i;
                }
            }
            int avail = 0;
            while (true) {
                int nextByte;
                if ((nextByte = this.in.read()) == -1) {
                    return true;
                }
                this.sb.append((char)nextByte);
                if (--avail <= 0) {
                    avail = this.in.available();
                }
                if (this.triggerString != null && avail == 0) {
                    int i = 0;
                    while (i < this.triggerString.length) {
                        int foundIndex;
                        if (this.sb.length() > maxLength) {
                            okIndex = this.sb.length() - maxLength;
                        }
                        if ((foundIndex = this.sb.indexOf(this.triggerString[i], okIndex)) >= 0) {
                            this.currentTriggerStringLength = this.triggerString[i].length();
                            boolean retry = this.askUserInput();
                            if (!retry) {
                                return false;
                            }
                            okIndex = foundIndex + 1;
                            break;
                        }
                        ++i;
                    }
                }
                if (this.consoleOutput == null || (char)nextByte != '\n') continue;
                int lf = 1;
                if (this.sb.charAt(this.sb.length() - 2) == '\r') {
                    ++lf;
                }
                BuilderRegistry.printToConsole(String.valueOf(this.consoleOutput) + "> " + this.sb.substring(startOfLine, this.sb.length() - lf));
                startOfLine = this.sb.length();
            }
        }
        catch (IOException iOException) {}
        return true;
    }

    private static InputQueryDialog createQueryDialog(String message) {
        return InputQueryDialog.createQuery("Question from an external program", "External program has a question:\n\n" + message, "Enter text", "Cancel build");
    }

    private boolean askUserInput() {
        Display display = TexlipsePlugin.getDefault().getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                int i = OutputScanner.this.sb.lastIndexOf("!");
                i = i < 0 ? OutputScanner.this.currentTriggerStringLength : (i += 2);
                InputQueryDialog dlg = OutputScanner.createQueryDialog(OutputScanner.this.sb.substring(i));
                OutputScanner.this.okPressed = dlg.open() == 0;
                OutputScanner.this.query = dlg.getInput();
            }
        });
        if (this.okPressed) {
            try {
                if (this.query == null) {
                    this.query = "";
                }
                this.query = String.valueOf(this.query) + System.getProperty("line.separator");
                this.out.write(this.query.getBytes());
                this.out.flush();
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
        return false;
    }
}

