/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.jmakepdfx;

import com.dickimawbooks.jmakepdfx.CancelledException;
import com.dickimawbooks.jmakepdfx.InterruptTimerTask;
import com.dickimawbooks.jmakepdfx.Jmakepdfx;
import com.dickimawbooks.jmakepdfx.ProcessListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ProcessInputReaderThread
extends Thread {
    private Process process;
    private ProcessListener listener;
    private Jmakepdfx app;

    public ProcessInputReaderThread(Jmakepdfx jmakepdfx, Process process, ProcessListener processListener) {
        this.app = jmakepdfx;
        this.process = process;
        this.listener = processListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            int n = 0;
            Jmakepdfx.checkForInterrupt();
            while ((string = bufferedReader.readLine()) != null) {
                this.listener.processLine(++n, string);
                Jmakepdfx.checkForInterrupt();
            }
            bufferedReader2 = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            n = 0;
            Jmakepdfx.checkForInterrupt();
            while ((string = bufferedReader2.readLine()) != null) {
                this.listener.processErrorLine(++n, string);
                Jmakepdfx.checkForInterrupt();
            }
        }
        catch (Exception exception) {
            InterruptTimerTask interruptTimerTask = this.listener.getInterruptor();
            if (interruptTimerTask != null) {
                switch (interruptTimerTask.getStatus()) {
                    case 2: {
                        this.listener.error(new CancelledException());
                        return;
                    }
                    case 1: {
                        this.listener.error(new CancelledException(Jmakepdfx.getLabelWithValue("error.timedout", "" + this.app.getMaxProcessTime())));
                        return;
                    }
                }
            }
            this.listener.error(exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    this.listener.error(iOException);
                }
                bufferedReader = null;
            }
            if (bufferedReader2 != null) {
                try {
                    bufferedReader2.close();
                }
                catch (IOException iOException) {
                    this.listener.error(iOException);
                }
                bufferedReader2 = null;
            }
        }
    }
}

