/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.jmakepdfx;

import com.dickimawbooks.jmakepdfx.CancelledException;
import com.dickimawbooks.jmakepdfx.ConvertThread;
import com.dickimawbooks.jmakepdfx.DefaultProcessListener;
import com.dickimawbooks.jmakepdfx.IccSelector;
import com.dickimawbooks.jmakepdfx.InterruptTimerTask;
import com.dickimawbooks.jmakepdfx.JpdfxAppSelector;
import com.dickimawbooks.jmakepdfx.JpdfxProperties;
import com.dickimawbooks.jmakepdfx.JpdfxResources;
import com.dickimawbooks.jmakepdfx.LicenceDialog;
import com.dickimawbooks.jmakepdfx.MenuButtonItem;
import com.dickimawbooks.jmakepdfx.MessageArea;
import com.dickimawbooks.jmakepdfx.PdfFileFilter;
import com.dickimawbooks.jmakepdfx.PdfInfoProcessListener;
import com.dickimawbooks.jmakepdfx.PdfxProcessListener;
import com.dickimawbooks.jmakepdfx.ProcessFailedException;
import com.dickimawbooks.jmakepdfx.ProcessInputReaderThread;
import com.dickimawbooks.jmakepdfx.ProcessListener;
import com.dickimawbooks.jmakepdfx.PropertiesDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class Jmakepdfx
extends JFrame
implements ActionListener,
MenuListener {
    private static final String appVersion = "0.3b";
    private static final String company = "Dickimaw Books";
    private static final String appName = "Jmakepdfx";
    private static final String appDate = "2012-10-22";
    private static Properties dictionary;
    private JToolBar toolBar;
    private HelpBroker mainHelpBroker;
    private CSH.DisplayHelpFromSource csh;
    private static boolean debugMode;
    private JFileChooser pdfFileChooser;
    private PdfFileFilter pdfFileFilter;
    private MenuButtonItem openItem;
    private MenuButtonItem abortItem;
    private JMenuItem clearRecentItem;
    private JMenuItem convertItem;
    private JMenu recentM;
    private ActionListener recentFilesListener;
    private MessageArea messageArea;
    private JRadioButton cmykButton;
    private JRadioButton greyButton;
    private JCheckBox useIccBox;
    private JButton convertButton;
    private JButton inputButton;
    private JButton outputButton;
    private JLabel inputLabel;
    private JLabel outputLabel;
    private JLabel profileLabel;
    private JLabel authorLabel;
    private JLabel titleLabel;
    private JLabel pageCountLabel;
    private JLabel fileSizeLabel;
    private JTextField inputField;
    private JTextField outputField;
    private JTextField authorField;
    private JTextField titleField;
    private JTextField pageCountField;
    private JTextField fileSizeField;
    private Box infoBox;
    private JpdfxProperties properties;
    private JpdfxAppSelector appSelector;
    private IccSelector iccSelector;
    private PropertiesDialog propertiesDialog;
    private Vector<Thread> currentWorkerThreads;
    private Vector<ProcessListener> currentProcessListeners;
    private File currentFile;
    private LicenceDialog licenceDialog;
    protected static DecimalFormat fileSizeFormat;
    private static final String[] fileSizeUnits;

    public Jmakepdfx() {
        super(appName);
        int n;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Jmakepdfx.this.quit();
            }
        });
        try {
            this.loadDictionary();
        }
        catch (IOException iOException) {
            this.error("Unable to load dictionary file:\n" + iOException.getMessage());
        }
        try {
            this.setIconImage(new ImageIcon(this.getClass().getResource("/icons/logosmall.png")).getImage());
        }
        catch (NullPointerException nullPointerException) {
            Jmakepdfx.debug("Can't find /icons/logosmall.png");
        }
        try {
            this.properties = JpdfxProperties.fetchProperties(this);
        }
        catch (IOException iOException) {
            this.error(Jmakepdfx.getLabelWithAlt("error.no_properties", "Unable to load properties") + "\n" + iOException.getMessage(), iOException);
            this.properties = new JpdfxProperties(this);
        }
        this.toolBar = new JToolBar(this.properties.getToolBarOrientation());
        this.getContentPane().add((Component)this.toolBar, this.properties.getToolBarPosition());
        this.initHelp();
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = this.createMenu("file");
        jMenuBar.add(jMenu);
        this.recentFilesListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string == null) {
                    return;
                }
                try {
                    int n = Integer.parseInt(string);
                    File file = new File(Jmakepdfx.this.properties.getRecentFileName(n));
                    Jmakepdfx.this.pdfFileChooser.setCurrentDirectory(file.getParentFile());
                    Jmakepdfx.this.load(file);
                }
                catch (Exception exception) {
                    Jmakepdfx.this.error(exception);
                    Jmakepdfx.this.setInfo(Jmakepdfx.getLabel("message.failedinfo"));
                    Jmakepdfx.this.clear();
                }
            }
        };
        this.recentM = this.createMenu("file", "recent");
        this.recentM.addMenuListener(this);
        jMenu.add(this.recentM);
        this.clearRecentItem = this.createMenuItem("file.recent", "clearrecent");
        this.openItem = this.createMenuButtonItem("file", "open", KeyStroke.getKeyStroke(79, 2), "general/Open24", jMenu);
        jMenu.add(this.createMenuItem("file", "quit", KeyStroke.getKeyStroke(81, 2)));
        JMenu jMenu2 = this.createMenu("tools");
        jMenuBar.add(jMenu2);
        this.convertItem = this.createMenuItem("tools", "convert");
        jMenu2.add(this.convertItem);
        this.abortItem = this.createMenuButtonItem("tools", "abort", KeyStroke.getKeyStroke(27, 0), "general/Stop24", jMenu2);
        this.abortItem.setEnabled(false);
        JMenu jMenu3 = this.createMenu("settings");
        jMenuBar.add(jMenu3);
        MenuButtonItem menuButtonItem = this.createMenuButtonItem("settings", "editsettings", KeyStroke.getKeyStroke(80, 2), "general/Preferences24", jMenu3);
        JMenu jMenu4 = this.createMenu("help");
        jMenuBar.add(jMenu4);
        jMenu4.add(this.createMenuItem("help", "about"));
        jMenu4.add(this.createMenuItem("help", "license"));
        this.createMenuButtonItem("help", "manual", KeyStroke.getKeyStroke(112, 0), "general/Help24", this.csh, jMenu4);
        this.pdfFileChooser = new JFileChooser(new File(this.properties.getDefaultDirectory()));
        this.pdfFileChooser.setFileFilter(new PdfFileFilter());
        this.pdfFileChooser.setAcceptAllFileFilterUsed(false);
        this.propertiesDialog = new PropertiesDialog(this);
        this.appSelector = new JpdfxAppSelector(this);
        this.iccSelector = new IccSelector(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        box.add(new Box.Filler(new Dimension(0, 0), new Dimension(1, 20), new Dimension(Integer.MAX_VALUE, 20)));
        Box box2 = Box.createHorizontalBox();
        box.add(box2);
        this.inputLabel = new JLabel(Jmakepdfx.getLabel("main", "input"));
        this.inputLabel.setDisplayedMnemonic(Jmakepdfx.getMnemonic("main", "input"));
        box2.add(this.inputLabel);
        this.inputField = new JTextField(40);
        this.inputLabel.setLabelFor(this.inputField);
        box2.add(this.inputField);
        this.inputField.setEditable(false);
        this.inputButton = new JButton("...");
        this.inputButton.setActionCommand("open");
        this.inputButton.addActionListener(this);
        box2.add(this.inputButton);
        Box box3 = Box.createHorizontalBox();
        box.add(box3);
        this.outputLabel = new JLabel(Jmakepdfx.getLabel("main", "output"));
        this.outputLabel.setDisplayedMnemonic(Jmakepdfx.getMnemonic("main", "output"));
        box3.add(this.outputLabel);
        this.outputField = new JTextField(40);
        this.outputLabel.setLabelFor(this.outputField);
        box3.add(this.outputField);
        this.outputButton = new JButton("...");
        this.outputButton.setActionCommand("setoutput");
        this.outputButton.addActionListener(this);
        box3.add(this.outputButton);
        Dimension dimension = this.outputLabel.getPreferredSize();
        dimension.width = n = Math.max(dimension.width, (int)this.inputLabel.getPreferredSize().getWidth());
        int n2 = dimension.height + 4;
        this.inputLabel.setPreferredSize(dimension);
        this.outputLabel.setPreferredSize(dimension);
        dimension = this.inputField.getMaximumSize();
        dimension.height = n2;
        this.inputField.setMaximumSize(dimension);
        dimension = this.outputField.getMaximumSize();
        dimension.height = n2;
        this.outputField.setMaximumSize(dimension);
        box.add(new Box.Filler(new Dimension(0, 0), new Dimension(1, 20), new Dimension(Integer.MAX_VALUE, 20)));
        this.infoBox = Box.createVerticalBox();
        box.add(this.infoBox);
        this.infoBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Jmakepdfx.getLabel("main", "info")));
        Box box4 = Box.createHorizontalBox();
        this.infoBox.add(box4);
        this.authorLabel = new JLabel(Jmakepdfx.getLabel("main", "author"));
        this.authorLabel.setDisplayedMnemonic(Jmakepdfx.getMnemonic("main", "author"));
        box4.add(this.authorLabel);
        this.authorField = new JTextField(20);
        this.authorLabel.setLabelFor(this.authorField);
        box4.add(this.authorField);
        box4 = Box.createHorizontalBox();
        this.infoBox.add(box4);
        this.titleLabel = new JLabel(Jmakepdfx.getLabel("main", "title"));
        this.titleLabel.setDisplayedMnemonic(Jmakepdfx.getMnemonic("main", "title"));
        box4.add(this.titleLabel);
        this.titleField = new JTextField(20);
        this.titleLabel.setLabelFor(this.titleField);
        box4.add(this.titleField);
        box4 = Box.createHorizontalBox();
        this.infoBox.add(box4);
        this.pageCountLabel = new JLabel(Jmakepdfx.getLabel("main", "pagecount"));
        box4.add(this.pageCountLabel);
        this.pageCountField = new JTextField(20);
        this.pageCountField.setEditable(false);
        box4.add(this.pageCountField);
        this.fileSizeLabel = new JLabel(Jmakepdfx.getLabel("main", "filesize"));
        box4.add(this.fileSizeLabel);
        this.fileSizeField = new JTextField(20);
        this.fileSizeField.setEditable(false);
        box4.add(this.fileSizeField);
        dimension = this.authorLabel.getPreferredSize();
        dimension.width = (int)Math.max(Math.max((double)dimension.width, this.fileSizeLabel.getPreferredSize().getWidth()), (double)((int)Math.max(this.titleLabel.getPreferredSize().getWidth(), this.pageCountLabel.getPreferredSize().getWidth())));
        this.authorLabel.setPreferredSize(dimension);
        this.titleLabel.setPreferredSize(dimension);
        this.pageCountLabel.setPreferredSize(dimension);
        this.fileSizeLabel.setPreferredSize(dimension);
        box.add(new Box.Filler(new Dimension(0, 0), new Dimension(1, 20), new Dimension(Integer.MAX_VALUE, 20)));
        Box box5 = Box.createHorizontalBox();
        box.add(box5);
        box5.add(Box.createHorizontalGlue());
        this.profileLabel = new JLabel(Jmakepdfx.getLabel("main", "profile"));
        box5.add(this.profileLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean bl = this.properties.isGrayProfile();
        this.greyButton = new JRadioButton(Jmakepdfx.getLabel("main", "grey"), bl);
        this.greyButton.setMnemonic(Jmakepdfx.getMnemonic("main", "grey"));
        buttonGroup.add(this.greyButton);
        box5.add(this.greyButton);
        this.cmykButton = new JRadioButton(Jmakepdfx.getLabel("main", "cmyk"), !bl);
        this.cmykButton.setMnemonic(Jmakepdfx.getMnemonic("main", "cmyk"));
        buttonGroup.add(this.cmykButton);
        box5.add(this.cmykButton);
        this.useIccBox = new JCheckBox(Jmakepdfx.getLabel("main", "useicc"), this.properties.isUseICC());
        this.useIccBox.setMnemonic(Jmakepdfx.getMnemonic("main", "useicc"));
        box5.add(this.useIccBox);
        this.convertButton = new JButton(Jmakepdfx.getLabel("main", "convert"));
        this.convertButton.setMnemonic(Jmakepdfx.getMnemonic("main", "convert"));
        this.convertButton.setActionCommand("convert");
        this.convertButton.addActionListener(this);
        box5.add(this.convertButton);
        box5.add(Box.createHorizontalGlue());
        box.add(new Box.Filler(new Dimension(0, 0), new Dimension(1, 20), new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE)));
        jPanel.add((Component)new JScrollPane(box), "Center");
        this.messageArea = new MessageArea(Jmakepdfx.getLabel("message.init"));
        jPanel.add((Component)this.messageArea, "South");
        this.getContentPane().add(jPanel);
        this.pack();
        this.currentProcessListeners = new Vector();
        this.currentWorkerThreads = new Vector();
        this.clear();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        Object object = menuEvent.getSource();
        if (object == this.recentM) {
            this.properties.setRecentFiles(this.recentM, this.recentFilesListener);
            this.recentM.addSeparator();
            this.recentM.add(this.clearRecentItem);
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("open")) {
            if (this.pdfFileChooser.showOpenDialog(this) == 0) {
                try {
                    this.load(this.pdfFileChooser.getSelectedFile());
                }
                catch (ProcessFailedException processFailedException) {
                    this.error(processFailedException.getMessage());
                    this.setInfo(Jmakepdfx.getLabel("message.failedinfo"));
                    this.clear();
                }
                catch (Exception exception) {
                    this.error(exception);
                    this.setInfo(Jmakepdfx.getLabel("message.failedinfo"));
                    this.clear();
                }
            }
        } else if (string.equals("clearrecent")) {
            this.properties.clearRecentList();
        } else if (string.equals("setoutput")) {
            File file;
            String string2 = this.outputField.getText();
            if (string2.equals("")) {
                String string3 = this.currentFile.getName();
                int n = string3.lastIndexOf(".");
                if (n > -1) {
                    string3 = string3.substring(0, n);
                }
                file = new File(this.currentFile.getParentFile(), string3 + "-pdfx.pdf");
            } else {
                file = new File(string2);
            }
            this.pdfFileChooser.setCurrentDirectory(file.getParentFile());
            this.pdfFileChooser.setSelectedFile(file);
            if (this.pdfFileChooser.showDialog(this, Jmakepdfx.getLabel("button", "select")) == 0) {
                this.setOutput(this.pdfFileChooser.getSelectedFile());
            }
        } else if (string.equals("quit")) {
            this.quit();
        } else if (string.equals("abort")) {
            this.abort();
        } else if (string.equals("convert")) {
            ConvertThread convertThread = new ConvertThread(this);
            this.startWorkerThread(convertThread);
        } else if (string.equals("editsettings")) {
            this.propertiesDialog.display();
        } else if (string.equals("about")) {
            String string4 = dictionary.getProperty("about.translator_info");
            String[] stringArray = string4 == null || string4.equals("") ? new String[]{appName, Jmakepdfx.getLabelWithValue("about.version", appVersion), Jmakepdfx.getLabelWithValues("about.copyright", "Nicola L. C. Talbot", appDate), "http://www.dickimaw-books.com/"} : new String[]{appName, Jmakepdfx.getLabelWithValue("about.version", appVersion), Jmakepdfx.getLabelWithValues("about.copyright", "Nicola L. C. Talbot", appDate), "http://www.dickimaw-books.com/", string4};
            JOptionPane.showMessageDialog(this, stringArray, Jmakepdfx.getLabelWithValue("about.title", appName), -1);
        } else if (string.equals("license")) {
            if (this.licenceDialog == null) {
                try {
                    this.licenceDialog = new LicenceDialog(this);
                }
                catch (IOException iOException) {
                    this.error(iOException);
                    this.licenceDialog = null;
                }
            }
            if (this.licenceDialog != null) {
                this.licenceDialog.setVisible(true);
            }
        }
    }

    public void quit() {
        if (this.currentWorkerThreads.size() > 0) {
            if (JOptionPane.showConfirmDialog(this, Jmakepdfx.getLabel("message.confirm.quit"), Jmakepdfx.getLabel("message.confirm"), 0) != 0) {
                return;
            }
            for (Thread object : this.currentWorkerThreads) {
                Jmakepdfx.debug("Interrupting " + object + " " + object.getClass().toString());
                object.interrupt();
            }
            for (ProcessListener processListener : this.currentProcessListeners) {
                processListener.terminateProcess();
            }
            this.abortItem.setEnabled(false);
            this.currentWorkerThreads.clear();
            this.currentProcessListeners.clear();
        }
        try {
            this.properties.setToolBarPosition((String)((BorderLayout)this.getContentPane().getLayout()).getConstraints(this.toolBar));
            this.properties.setToolBarOrientation(this.toolBar.getOrientation());
            this.properties.setProfile(this.greyButton.isSelected() ? "gray" : "cmyk");
            this.properties.setUseICC(this.useIccBox.isSelected());
            this.properties.save();
        }
        catch (Exception exception) {
            this.error(Jmakepdfx.getLabel("error.propsave_failed") + "\n" + exception.getMessage(), exception);
        }
        System.exit(0);
    }

    public void setOutput(File file) {
        this.outputField.setText(file.getAbsolutePath());
    }

    public String getOutputName() {
        return this.outputField.getText();
    }

    public void clear() {
        this.inputField.setText("");
        this.outputField.setText("");
        this.authorField.setText("");
        this.titleField.setText("");
        this.pageCountField.setText("");
        this.fileSizeField.setText("");
        this.disableFunctions();
        this.abortItem.setEnabled(false);
    }

    public void viewPDF(String string) {
        String string2 = this.properties.getPdfViewer();
        if (string2 == null || string2.equals("")) {
            string2 = this.appSelector.fetchApplicationPath(Jmakepdfx.getLabelWithValue("properties.query.location.viewer", "PDF")).getAbsolutePath();
            if (string2 == null || string2.equals("")) {
                this.error(Jmakepdfx.getLabelWithValue("error.load_type_failed", "PDF"));
                return;
            }
            this.properties.setPdfViewer(string2);
        }
        String[] stringArray = new String[]{string2, string};
        try {
            Process process = this.execCommand(stringArray, false);
        }
        catch (Exception exception) {
            this.error(Jmakepdfx.getLabelWithValue("error.exec_failed", stringArray[0] + " " + stringArray[1]) + "\n" + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException, InterruptedException, ProcessFailedException {
        this.setWaitCursor();
        try {
            this.getPdfInfo(file);
            this.currentFile = file;
            this.setTitle("Jmakepdfx - " + this.currentFile.getName());
            this.properties.addRecentFile(this.currentFile.getAbsolutePath());
            this.resetFunctions();
            String string = this.currentFile.getName();
            int n = string.lastIndexOf(".");
            string = n > -1 ? string.substring(0, n) + "-pdfx" : string + "-pdfx";
            this.outputField.setText(new File(this.currentFile.getParentFile(), string + ".pdf").getAbsolutePath());
            this.inputField.setText(this.currentFile.getAbsolutePath());
            this.revalidate();
            this.setInfo(Jmakepdfx.getLabel("message", "file_loaded"));
        }
        finally {
            this.setDefaultCursor();
        }
    }

    private JMenu createMenu(String string) {
        return this.createMenu(null, string);
    }

    private JMenu createMenu(String string, String string2) {
        JMenu jMenu = new JMenu(Jmakepdfx.getLabel(string, string2));
        jMenu.setMnemonic(Jmakepdfx.getMnemonic(string, string2));
        return jMenu;
    }

    private JMenuItem createMenuItem(String string, String string2) {
        return this.createMenuItem(string, string2, null, null, this);
    }

    private JMenuItem createMenuItem(String string, String string2, KeyStroke keyStroke) {
        return this.createMenuItem(string, string2, keyStroke, null, this);
    }

    private JMenuItem createMenuItem(String string, String string2, String string3) {
        return this.createMenuItem(string, string2, null, string3, this);
    }

    private JMenuItem createMenuItem(String string, String string2, KeyStroke keyStroke, String string3) {
        return this.createMenuItem(string, string2, keyStroke, string3, this);
    }

    private JMenuItem createMenuItem(String string, String string2, KeyStroke keyStroke, String string3, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(Jmakepdfx.getLabel(string, string2));
        jMenuItem.setMnemonic(Jmakepdfx.getMnemonic(string, string2));
        jMenuItem.setActionCommand(string2);
        if (actionListener != null) {
            jMenuItem.addActionListener(actionListener);
        }
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        if (string3 != null) {
            jMenuItem.setToolTipText(string3);
        }
        return jMenuItem;
    }

    private MenuButtonItem createMenuButtonItem(String string, String string2, KeyStroke keyStroke, String string3, JMenu jMenu) {
        return this.createMenuButtonItem(string, string2, keyStroke, string3, this, jMenu);
    }

    private MenuButtonItem createMenuButtonItem(String string, String string2, KeyStroke keyStroke, String string3, ActionListener actionListener, JMenu jMenu) {
        return Jmakepdfx.createMenuButtonItem(string, string2, keyStroke, string3, actionListener, jMenu, this.toolBar);
    }

    public static MenuButtonItem createMenuButtonItem(String string, String string2, KeyStroke keyStroke, String string3, ActionListener actionListener, JMenu jMenu, JComponent jComponent) {
        String string4 = dictionary.getProperty(string + "." + string2 + ".tooltip");
        String string5 = dictionary.getProperty(string + "." + string2 + ".altText");
        String string6 = string3.endsWith(".png") ? "icons/" + string3 : "/toolbarButtonGraphics/" + string3 + ".gif";
        URL uRL = Jmakepdfx.class.getResource(string6);
        MenuButtonItem menuButtonItem = new MenuButtonItem(Jmakepdfx.getLabel(string, string2), Jmakepdfx.getMnemonic(string, string2), uRL, string2, keyStroke, actionListener, string4, string5);
        jComponent.add(menuButtonItem.getButton());
        jMenu.add(menuButtonItem.getItem());
        return menuButtonItem;
    }

    public static String getLabelWithAlt(String string, String string2) {
        if (dictionary == null) {
            return string2;
        }
        String string3 = dictionary.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static String getLabel(String string) {
        return Jmakepdfx.getLabel(null, string);
    }

    public static String getLabel(String string, String string2) {
        String string3;
        if (string != null) {
            string2 = string + "." + string2;
        }
        if ((string3 = dictionary.getProperty(string2)) == null) {
            System.err.println("No such dictionary property '" + string2 + "'");
            return "?" + string2 + "?";
        }
        return string3;
    }

    public static char getMnemonic(String string) {
        return Jmakepdfx.getMnemonic(null, string);
    }

    public static char getMnemonic(String string, String string2) {
        String string3 = Jmakepdfx.getLabel(string, string2 + ".mnemonic");
        if (string3.equals("")) {
            System.err.println("Empty dictionary property '" + string3 + "'");
            return string2.charAt(0);
        }
        return string3.charAt(0);
    }

    public static int getMnemonicInt(String string) {
        return Jmakepdfx.getMnemonicInt(null, string);
    }

    public static int getMnemonicInt(String string, String string2) {
        String string3 = Jmakepdfx.getLabel(string, string2 + ".mnemonic");
        if (string3.equals("")) {
            System.err.println("Empty dictionary property '" + string3 + "'");
            return string2.codePointAt(0);
        }
        return string3.codePointAt(0);
    }

    public static String getLabelWithValue(String string, String string2) {
        String string3 = Jmakepdfx.getLabel(string);
        return string3.replaceAll("\\$1", string2.replaceAll("\\\\", "\\\\\\\\"));
    }

    public static String getLabelWithValue(String string, int n) {
        return Jmakepdfx.getLabelWithValue(string, "" + n);
    }

    public static String getLabelWithValues(String string, String string2, String string3) {
        String string4 = Jmakepdfx.getLabel(string);
        return string4.replaceAll("\\$1", string2.replaceAll("\\\\", "\\\\\\\\")).replaceAll("\\$2", string3.replaceAll("\\\\", "\\\\\\\\"));
    }

    public static String getLabelWithValues(String string, String[] stringArray) {
        String string2 = Jmakepdfx.getLabel(string);
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2.replaceAll("\\$" + (i + 1), stringArray[i].replaceAll("\\\\", "\\\\\\\\"));
        }
        return string2;
    }

    public void setInfo(String string) {
        this.messageArea.update(string);
    }

    public void setInfoAndDebug(String string) {
        Jmakepdfx.debug(string);
        this.setInfo(string);
    }

    public void setWaitCursor() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                Jmakepdfx.this.setCursor(Cursor.getPredefinedCursor(3));
            }
        };
        thread.start();
        thread = null;
    }

    public void setDefaultCursor() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                Jmakepdfx.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        thread.start();
        thread = null;
    }

    public File fetchICCFile() throws IOException, InterruptedException {
        URL uRL = new URL("http://www.colormanagement.org/download_files/ISOcoated_v2_basICC.zip");
        File file = this.pdfFileChooser.getCurrentDirectory();
        JFileChooser jFileChooser = new JFileChooser(file == null ? null : file.getParentFile());
        jFileChooser.setFileSelectionMode(1);
        if (file != null) {
            jFileChooser.setSelectedFile(file);
        }
        if (jFileChooser.showDialog(this, Jmakepdfx.getLabel("button.select")) != 0) {
            return null;
        }
        file = jFileChooser.getSelectedFile();
        File file2 = new File(file, "FOGRA39L.icc");
        this.unpackZipEntry(uRL, file, ".icc", file2.getName());
        return file2;
    }

    public String getCurrentDirectory() {
        return this.pdfFileChooser.getCurrentDirectory().getAbsolutePath();
    }

    public JpdfxProperties getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toPdfX() throws IOException, InterruptedException {
        Object object;
        String string;
        String string2 = null;
        String string3 = null;
        boolean bl = this.useIccBox.isSelected();
        if (bl) {
            string = this.properties.getICCFile();
            if (string == null || string.equals("")) {
                object = this.iccSelector.fetchPath();
                if (object == null) {
                    throw new FileNotFoundException(Jmakepdfx.getLabel("error.no_icc"));
                }
            } else {
                object = new File(string);
            }
            string2 = Jmakepdfx.toFileName((File)object);
            string3 = ((File)object).getName().replaceAll("([\\(\\)])", "\\\\1");
            int n = string3.toLowerCase().lastIndexOf(".icc");
            if (n > 0) {
                string3 = string3.substring(0, n);
            }
        }
        string = this.getGSApp();
        object = this.outputField.getText();
        if (object == null || ((String)object).equals("")) {
            throw new FileNotFoundException(Jmakepdfx.getLabel("error.no_outputfile"));
        }
        File file = new File((String)object);
        if (file.isDirectory()) {
            throw new IOException(Jmakepdfx.getLabelWithValue("error.output_is_dir", (String)object));
        }
        String string4 = this.currentFile.getAbsolutePath();
        File file2 = new File(string4);
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            throw new IOException(Jmakepdfx.getLabel("error.io.outin"));
        }
        if (file.exists() && JOptionPane.showConfirmDialog(this, Jmakepdfx.getLabelWithValue("message.confirm.overwrite", file.getAbsolutePath()), Jmakepdfx.getLabel("message.confirm"), 0) != 0) {
            this.setInfo("message.failed");
            return false;
        }
        Jmakepdfx.checkForInterrupt();
        File file3 = this.currentFile.getParentFile();
        File file4 = File.createTempFile("jmakepdfx", ".ps");
        file4.deleteOnExit();
        PrintWriter printWriter = null;
        this.setInfo(Jmakepdfx.getLabelWithValue("message.writing", file4.getAbsolutePath()));
        try {
            printWriter = new PrintWriter(new FileWriter(file4));
            printWriter.println("systemdict /ProcessColorModel known {");
            printWriter.println("systemdict /ProcessColorModel get dup /DeviceGray ne exch /DeviceCMYK ne and } {");
            printWriter.println("  true");
            printWriter.println("} ifelse");
            printWriter.println("{ (ERROR: ProcessColorModel must be /DeviceGray or DeviceCMYK.)=");
            printWriter.println("  /ProcessColorModel cvx /rangecheck signalerror");
            printWriter.println("} if");
            printWriter.println();
            printWriter.println("% Define entries to the document Info dictionary :");
            printWriter.println();
            if (bl) {
                printWriter.println("/ICCProfile (" + string2 + ") def");
                printWriter.println();
            }
            printWriter.println("[ /GTS_PDFXVersion (PDF/X-3:2002)");
            String string5 = this.titleField.getText();
            if (string5 == null) {
                string5 = "";
            } else {
                string5 = string5.replaceAll("(\\\\)", "\\\\\\1");
                string5 = string5.replaceAll("([\\(\\)])", "\\\\1");
            }
            String string6 = this.authorField.getText();
            if (string6 == null) {
                string6 = "";
            } else {
                string6 = string6.replaceAll("(\\\\)", "\\\\\\1");
                string6 = string6.replaceAll("([\\(\\)])", "\\\\1");
            }
            String string7 = this.cmykButton.isSelected() ? "CMYK" : "Gray";
            printWriter.println("  /Trapped /False");
            printWriter.println("  /DOCINFO pdfmark");
            if (bl) {
                printWriter.println();
                printWriter.println("% Define an ICC profile :");
                printWriter.println();
                printWriter.println("currentdict /ICCProfile known {");
                printWriter.println("  [/_objdef {icc_PDFX} /type /stream /OBJ pdfmark");
                printWriter.print("  [{icc_PDFX} <</N systemdict /ProcessColorModel get ");
                printWriter.print("/Device" + string7);
                printWriter.println(" eq {1} {4} ifelse >> /PUT pdfmark");
                printWriter.println("  [{icc_PDFX} ICCProfile (r) file /PUT pdfmark");
                printWriter.println("} if");
            }
            printWriter.println();
            printWriter.println("% Define the output intent dictionary :");
            printWriter.println();
            printWriter.println("[/_objdef {OutputIntent_PDFX} /type /dict /OBJ pdfmark");
            printWriter.println("[{OutputIntent_PDFX} <<");
            printWriter.println("  /Type /OutputIntent");
            printWriter.println("  /S /GTS_PDFX");
            printWriter.println("  /OutputCondition (Commercial and speciality printing)");
            if (bl) {
                printWriter.println("  /OutputConditionIdentifier (" + string3 + ")");
                printWriter.println("  /RegistryName (http://www.color.org)");
                printWriter.println("  currentdict /ICCProfile known {");
                printWriter.println("    /DestOutputProfile {icc_PDFX}");
                printWriter.println("  } if");
            }
            printWriter.println(">> /PUT pdfmark");
            printWriter.println("[{Catalog} <</OutputIntents [ {OutputIntent_PDFX} ]>> /PUT pdfmark");
            String string8 = Jmakepdfx.toFileName(file4);
            string4 = Jmakepdfx.toFileName(file2);
            object = Jmakepdfx.toFileName(file);
            Jmakepdfx.checkForInterrupt();
            String[] stringArray = new String[]{string, "-dPDFX", "-dBATCH", "-dNOPAUSE", "-dNOOUTERSAVE", "-sDEVICE=pdfwrite", "-sColorConversionStrategy=" + string7, "-dProcessColorModel=/Device" + string7, "-dPDFSETTINGS=/prepress", "-sOutputFile=" + (String)object + "", string8, "-c", "(" + string4 + ") run " + "/pdfmark where {pop} {userdict /pdfmark /cleartomark load put} ifelse " + "[/Title (" + string5 + ") /Author (" + string6 + ") /DOCINFO pdfmark"};
            Jmakepdfx.checkForInterrupt();
            PdfxProcessListener pdfxProcessListener = new PdfxProcessListener(this);
            int n = this.execCommandAndWaitFor(stringArray, pdfxProcessListener);
            Jmakepdfx.checkForInterrupt();
            if (n != 0) {
                String string9 = Jmakepdfx.getLabelWithValue("error.exec_failed", pdfxProcessListener.getErrors());
                this.error(string9);
                System.err.println(string9);
                boolean bl2 = false;
                return bl2;
            }
            Jmakepdfx.checkForInterrupt();
            String string10 = pdfxProcessListener.getMessage();
            if (string10 != null) {
                this.warning(string10);
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
                printWriter = null;
            }
        }
        Jmakepdfx.checkForInterrupt();
        this.setInfo(Jmakepdfx.getLabel("message.completed"));
        JOptionPane.showMessageDialog(this, Jmakepdfx.getLabel("message.done"));
        return true;
    }

    public void processFinished() {
        this.setDefaultCursor();
        this.resetFunctions();
    }

    public static synchronized void checkForInterrupt() throws InterruptedException {
        Thread.yield();
        if (Thread.currentThread().isInterrupted()) {
            throw new CancelledException();
        }
    }

    public synchronized boolean abort() {
        if (JOptionPane.showConfirmDialog(null, Jmakepdfx.getLabel("message.confirm.abort"), Jmakepdfx.getLabel("message.confirm"), 0) == 0) {
            for (Thread object : this.currentWorkerThreads) {
                Jmakepdfx.debug("Interrupting " + object + " " + object.getClass().toString());
                object.interrupt();
            }
            for (ProcessListener processListener : this.currentProcessListeners) {
                processListener.terminateProcess();
            }
            this.abortItem.setEnabled(false);
            this.currentWorkerThreads.clear();
            this.currentProcessListeners.clear();
            return true;
        }
        return false;
    }

    public synchronized void addProcessListener(ProcessListener processListener) {
        this.currentProcessListeners.add(processListener);
    }

    public synchronized void removeProcessListener(ProcessListener processListener) {
        this.currentProcessListeners.remove(processListener);
    }

    public synchronized void startWorkerThread(Thread thread) {
        Jmakepdfx.debug("adding thread to current list");
        this.currentWorkerThreads.add(thread);
        Jmakepdfx.debug("starting thread");
        thread.start();
        this.abortItem.setEnabled(true);
    }

    public synchronized void workerThreadFinished(Thread thread) {
        this.currentWorkerThreads.remove(thread);
        this.updateAbortItem();
    }

    private synchronized void updateAbortItem() {
        this.abortItem.setEnabled(this.currentWorkerThreads.size() > 0 || this.currentProcessListeners.size() > 0);
    }

    public void error(String string) {
        JpdfxResources.error((Component)this, string);
    }

    public void error(String string, Exception exception) {
        JpdfxResources.error(this, string, exception);
    }

    public void error(Exception exception) {
        JpdfxResources.error((Component)this, exception);
    }

    public void warning(String string) {
        JpdfxResources.warning(this, string);
    }

    private void initHelp() {
        if (this.mainHelpBroker == null) {
            HelpSet helpSet = null;
            String string = "jmakepdfx";
            String string2 = "/resources/helpsets/" + string;
            String string3 = Locale.getDefault().getLanguage();
            try {
                URL uRL = this.getClass().getResource(string2 + "-" + string3 + "/" + string + ".hs");
                if (uRL == null && !string3.equals("en")) {
                    uRL = this.getClass().getResource(string2 + "-en/" + string + ".hs");
                }
                helpSet = new HelpSet(null, uRL);
            }
            catch (Exception exception) {
                this.error("/resources/helpsets/" + string + ".hs\n" + Jmakepdfx.getLabel("error.io.helpset") + ":\n" + exception.getMessage());
            }
            if (helpSet != null) {
                this.mainHelpBroker = helpSet.createHelpBroker();
            }
            if (this.mainHelpBroker != null) {
                this.csh = new CSH.DisplayHelpFromSource(this.mainHelpBroker);
            }
        }
    }

    public void enableHelpOnButton(JComponent jComponent, String string) {
        if (this.mainHelpBroker != null) {
            try {
                this.mainHelpBroker.enableHelpOnButton(jComponent, string, this.mainHelpBroker.getHelpSet());
            }
            catch (BadIDException badIDException) {
                this.error(badIDException);
            }
        } else {
            System.err.println("Can't enable help on button (id=" + string + "): null help broker");
        }
    }

    private void loadDictionary() throws IOException {
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        String string2 = "jmakepdfx";
        InputStream inputStream = this.getClass().getResourceAsStream("/resources/dictionaries/" + string2 + "-" + string + ".prop");
        if (inputStream == null && !string.equals("en")) {
            inputStream = this.getClass().getResourceAsStream("/resources/dictionaries/" + string2 + "-en.prop");
        }
        if (inputStream == null) {
            throw new FileNotFoundException("Can't find dictionary resource file /resources/dictionaries/" + string2 + "-en");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        dictionary = new Properties();
        dictionary.load(bufferedReader);
        bufferedReader.close();
        inputStream.close();
    }

    public void unpackArchive(URL uRL, File file) throws IOException, InterruptedException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException(Jmakepdfx.getLabelWithValue("error.io.cant_mkdir", file.getAbsolutePath()));
        }
        this.setInfo(Jmakepdfx.getLabelWithValue("message.downloading", uRL.toString()));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream(), 1024);
        Path path = Files.createTempFile("archive", ".zip", new FileAttribute[0]);
        Files.copy(bufferedInputStream, path, StandardCopyOption.REPLACE_EXISTING);
        File file2 = path.toFile();
        file2.deleteOnExit();
        this.unpackArchive(file2, file);
    }

    public void unpackZipEntries(URL uRL, File file, String string) throws IOException, InterruptedException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException(Jmakepdfx.getLabelWithValue("error.io.cant_mkdir", file.getAbsolutePath()));
        }
        string = string.toLowerCase();
        this.setInfo(Jmakepdfx.getLabelWithValue("message.downloading", uRL.toString()));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream(), 1024);
        Path path = Files.createTempFile("archive", ".zip", new FileAttribute[0]);
        path.toFile().deleteOnExit();
        Files.copy(bufferedInputStream, path, StandardCopyOption.REPLACE_EXISTING);
        ZipFile zipFile = new ZipFile(path.toFile());
        boolean bl = false;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            if (!string2.toLowerCase().endsWith(string)) continue;
            bl = this.unpackFile(file, zipFile, zipEntry, bl);
        }
    }

    public void unpackZipEntry(URL uRL, File file, String string, String string2) throws IOException, InterruptedException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException(Jmakepdfx.getLabelWithValue("error.io.cant_mkdir", file.getAbsolutePath()));
        }
        string = string.toLowerCase();
        this.setInfo(Jmakepdfx.getLabelWithValue("message.downloading", uRL.toString()));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream(), 1024);
        Path path = Files.createTempFile("archive", ".zip", new FileAttribute[0]);
        path.toFile().deleteOnExit();
        Files.copy(bufferedInputStream, path, StandardCopyOption.REPLACE_EXISTING);
        ZipFile zipFile = new ZipFile(path.toFile());
        boolean bl = false;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string3 = zipEntry.getName();
            if (!string3.toLowerCase().endsWith(string)) continue;
            bl = this.unpackFile(file, zipFile, zipEntry, string2, bl);
            break;
        }
    }

    public void unpackArchive(File file, File file2) throws IOException, InterruptedException {
        if (!file.exists()) {
            throw new IOException(Jmakepdfx.getLabelWithValue("error.file_not_found", file.getAbsolutePath()));
        }
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException(Jmakepdfx.getLabelWithValue("error.io.cant_mkdir", file2.getAbsolutePath()));
        }
        boolean bl = false;
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            bl = this.unpackFile(file2, zipFile, zipEntry, bl);
        }
        zipFile.close();
    }

    public boolean unpackFile(File file, ZipFile zipFile, ZipEntry zipEntry, boolean bl) throws IOException, InterruptedException {
        return this.unpackFile(file, zipFile, zipEntry, zipEntry.getName(), bl);
    }

    public boolean unpackFile(File file, ZipFile zipFile, ZipEntry zipEntry, String string, boolean bl) throws IOException, InterruptedException {
        File file2 = new File(file, string);
        this.setInfo(Jmakepdfx.getLabelWithValue("message.unpacking", file2.getAbsolutePath()));
        File file3 = file2.getParentFile();
        if (!file3.exists() && !file3.mkdirs()) {
            throw new IOException(Jmakepdfx.getLabelWithValue("error.io.cant_mkdir", file3.getAbsolutePath()));
        }
        if (zipEntry.isDirectory()) {
            if (!file2.exists() && !file2.mkdirs()) {
                throw new IOException(Jmakepdfx.getLabelWithValue("error.io.cant_mkdir", file2.getAbsolutePath()));
            }
        } else if (bl) {
            Files.copy(zipFile.getInputStream(zipEntry), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } else if (file2.exists()) {
            String string2 = Jmakepdfx.getLabel("message.overwrite.this");
            String string3 = Jmakepdfx.getLabel("message.overwrite.all");
            String string4 = Jmakepdfx.getLabel("message.overwrite.skip");
            Object object = JOptionPane.showInputDialog(this, Jmakepdfx.getLabelWithValue("message.overwrite", file2.getAbsolutePath()), Jmakepdfx.getLabel("message.confirm"), 2, null, new Object[]{string2, string3, string4}, string2);
            if (object == null) {
                throw new CancelledException();
            }
            if (object == string3) {
                bl = true;
            }
            if (object == string3 || object == string2) {
                Files.copy(zipFile.getInputStream(zipEntry), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        } else {
            Files.copy(zipFile.getInputStream(zipEntry), file2.toPath(), new CopyOption[0]);
        }
        return bl;
    }

    public int execCommandAndWaitFor(String[] stringArray) throws IOException, InterruptedException {
        return this.execCommandAndWaitFor(stringArray, null, null, new DefaultProcessListener(this), true);
    }

    public int execCommandAndWaitFor(String[] stringArray, boolean bl) throws IOException, InterruptedException {
        return this.execCommandAndWaitFor(stringArray, null, null, new DefaultProcessListener(this), bl);
    }

    public int execCommandAndWaitFor(String[] stringArray, ProcessListener processListener) throws IOException, InterruptedException {
        return this.execCommandAndWaitFor(stringArray, null, null, processListener, true);
    }

    public int execCommandAndWaitFor(String[] stringArray, String[] stringArray2, File file) throws IOException, InterruptedException {
        return this.execCommandAndWaitFor(stringArray, stringArray2, file, new DefaultProcessListener(this), true);
    }

    public int execCommandAndWaitFor(String[] stringArray, String[] stringArray2, File file, ProcessListener processListener) throws IOException, InterruptedException {
        return this.execCommandAndWaitFor(stringArray, stringArray2, file, processListener, true);
    }

    public int execCommandAndWaitFor(String[] stringArray, String[] stringArray2, File file, ProcessListener processListener, boolean bl) throws IOException, InterruptedException {
        Timer timer = null;
        Process process = null;
        int n = -1;
        InterruptTimerTask interruptTimerTask = null;
        try {
            timer = new Timer(true);
            interruptTimerTask = new InterruptTimerTask(Thread.currentThread());
            timer.schedule((TimerTask)interruptTimerTask, this.properties.getMaxProcessTime());
            processListener.setInterruptor(interruptTimerTask);
            process = this.execCommand(stringArray, stringArray2, file, processListener, bl);
            this.addProcessListener(processListener);
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            process.destroy();
            throw interruptedException;
        }
        finally {
            timer.cancel();
            Thread.interrupted();
            this.removeProcessListener(processListener);
            this.updateAbortItem();
        }
        return n;
    }

    public Process execCommand(String[] stringArray) throws IOException {
        return this.execCommand(stringArray, null, null, new DefaultProcessListener(this), true);
    }

    public Process execCommand(String[] stringArray, boolean bl) throws IOException {
        return this.execCommand(stringArray, null, null, new DefaultProcessListener(this), bl);
    }

    public Process execCommand(String[] stringArray, ProcessListener processListener) throws IOException {
        return this.execCommand(stringArray, null, null, processListener, true);
    }

    public Process execCommand(String[] stringArray, String[] stringArray2, File file) throws IOException {
        return this.execCommand(stringArray, stringArray2, file, new DefaultProcessListener(this), true);
    }

    public Process execCommand(String[] stringArray, String[] stringArray2, File file, ProcessListener processListener) throws IOException {
        return this.execCommand(stringArray, stringArray2, file, processListener, true);
    }

    public Process execCommand(String[] stringArray, String[] stringArray2, File file, ProcessListener processListener, boolean bl) throws IOException {
        String string = "";
        for (int i = 1; i < stringArray.length; ++i) {
            string = string + " \"" + stringArray[i] + "\"";
        }
        String string2 = stringArray[0];
        int n = string2.lastIndexOf(File.separator);
        if (n > -1) {
            string2 = string2.substring(n + 1);
        }
        if (debugMode) {
            System.out.println("Running:");
            if (file != null) {
                System.out.println("  in directory " + file.getAbsolutePath());
            }
            if (stringArray2 != null && stringArray2.length > 0) {
                System.out.println("  with environment:");
                for (int i = 0; i < stringArray2.length; ++i) {
                    System.out.println("  " + stringArray2[i]);
                }
            }
            System.out.println(stringArray[0] + string);
        }
        if (bl) {
            this.setInfo(Jmakepdfx.getLabelWithValue("message.running", string2 + string));
        }
        Process process = Runtime.getRuntime().exec(stringArray, stringArray2, file);
        processListener.setProcess(process);
        ProcessInputReaderThread processInputReaderThread = new ProcessInputReaderThread(this, process, processListener);
        processListener.setThread(processInputReaderThread);
        processInputReaderThread.start();
        processInputReaderThread = null;
        return process;
    }

    public void enableTools() {
        this.resetFunctions();
        this.openItem.setEnabled(true);
        this.recentM.setEnabled(true);
        this.inputLabel.setEnabled(true);
        this.inputField.setEnabled(true);
        this.inputButton.setEnabled(true);
    }

    public void resetFunctions() {
        this.profileLabel.setEnabled(true);
        this.cmykButton.setEnabled(true);
        this.greyButton.setEnabled(true);
        this.useIccBox.setEnabled(true);
        this.convertButton.setEnabled(true);
        this.convertItem.setEnabled(true);
        this.outputLabel.setEnabled(true);
        this.outputField.setEnabled(true);
        this.outputButton.setEnabled(true);
        this.authorLabel.setEnabled(true);
        this.authorField.setEnabled(true);
        this.titleLabel.setEnabled(true);
        this.titleField.setEnabled(true);
        this.pageCountLabel.setEnabled(true);
        this.fileSizeLabel.setEnabled(true);
        this.infoBox.setEnabled(true);
    }

    public void disableTools() {
        this.disableFunctions();
        this.openItem.setEnabled(false);
        this.recentM.setEnabled(false);
        this.inputLabel.setEnabled(false);
        this.inputField.setEnabled(false);
        this.inputButton.setEnabled(false);
    }

    public void disableFunctions() {
        this.profileLabel.setEnabled(false);
        this.cmykButton.setEnabled(false);
        this.greyButton.setEnabled(false);
        this.useIccBox.setEnabled(false);
        this.convertButton.setEnabled(false);
        this.convertItem.setEnabled(false);
        this.outputLabel.setEnabled(false);
        this.outputField.setEnabled(false);
        this.outputButton.setEnabled(false);
        this.authorLabel.setEnabled(false);
        this.authorField.setEnabled(false);
        this.titleLabel.setEnabled(false);
        this.titleField.setEnabled(false);
        this.pageCountLabel.setEnabled(false);
        this.fileSizeLabel.setEnabled(false);
        this.infoBox.setEnabled(false);
    }

    public File getApp(String string) throws FileNotFoundException {
        return this.getApp(string, null);
    }

    public File getApp(String string, String string2) throws FileNotFoundException {
        return this.getApp(string, null, null);
    }

    public File getApp(String string, String string2, String string3) throws FileNotFoundException {
        File file = this.appSelector.fetchApplicationPath(string, string2, string3, Jmakepdfx.getLabelWithValue("properties.query.location.app", string));
        if (file == null || !file.exists()) {
            String string4 = Jmakepdfx.getLabelWithValue("warning.no_build.missing.app", string);
            throw new FileNotFoundException(string4);
        }
        return file;
    }

    public String getGSApp() throws IOException {
        String string = this.properties.getGSApp();
        if (string != null && string.length() > 0) {
            return string;
        }
        File file = null;
        file = this.getApp("gs", "gswin32c", "gsos2");
        if (file == null) {
            throw new FileNotFoundException(Jmakepdfx.getLabel("error.no_gs"));
        }
        this.properties.setGSApp(file.getAbsolutePath());
        return file.getAbsolutePath();
    }

    public static void debug(String string) {
        if (debugMode) {
            System.out.println(string);
        }
    }

    public static boolean inDebugMode() {
        return debugMode;
    }

    public long getMaxProcessTime() {
        return this.properties.getMaxProcessTime();
    }

    public static String toFileName(File file) {
        String string = file.getAbsolutePath();
        if (File.separator.equals("\\")) {
            string = string.replaceAll("\\\\", "/");
        }
        string = string.replaceAll("(\\\\)", "\\\\\\1").replaceAll("([\\(\\)])", "\\\\1");
        return string;
    }

    public void getPdfInfo(File file) throws IOException, InterruptedException, ProcessFailedException {
        String string;
        if (!file.exists()) {
            throw new FileNotFoundException(Jmakepdfx.getLabelWithValue("error.io.file_not_found", file.getAbsolutePath()));
        }
        this.setInfo("message.getinfo");
        String string2 = this.getGSApp();
        String string3 = Jmakepdfx.toFileName(file);
        String[] stringArray = new String[]{string2, "-dNODISPLAY", "-q", "-c", "(" + string3 + ") (r) file runpdfbegin " + "Trailer  /Info known {Trailer /Info get} {0 packedarray} ifelse " + "/pdfinfo exch def " + "pdfinfo /Title known {pdfinfo /Title get} {(unknown)} ifelse = " + "pdfinfo /Author known {pdfinfo /Author get} {(unknown)} ifelse = " + "pdfpagecount = quit"};
        PdfInfoProcessListener pdfInfoProcessListener = new PdfInfoProcessListener(this);
        int n = this.execCommandAndWaitFor(stringArray, pdfInfoProcessListener);
        if (n != 0) {
            String string4 = pdfInfoProcessListener.getErrorMessage();
            if (string4 != null) {
                string4 = Jmakepdfx.getLabelWithValue("error.gsmess", string4);
            }
            throw new ProcessFailedException(Jmakepdfx.getLabelWithValues("error.noinfo", new String[]{string3, string4}));
        }
        String string5 = pdfInfoProcessListener.getTitle();
        if (string5.equals("unknown")) {
            string5 = Jmakepdfx.getLabel("main", "unknown");
        }
        if ((string = pdfInfoProcessListener.getAuthor()).equals("unknown")) {
            string = Jmakepdfx.getLabel("main", "unknown");
        }
        int n2 = pdfInfoProcessListener.getPageCount();
        this.titleField.setText(string5);
        this.authorField.setText(string);
        this.pageCountField.setText(n2 == -1 ? Jmakepdfx.getLabel("main", "unknown") : "" + n2);
        this.fileSizeField.setText(Jmakepdfx.formatFileSize(file.length()));
        this.setInfo("message.done");
    }

    public static String formatFileSize(long l) {
        int n = (int)(Math.log10(l) / Math.log10(1024.0));
        return fileSizeFormat.format((double)l / Math.pow(1024.0, n)) + " " + fileSizeUnits[n];
    }

    public static void main(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-debug")) {
                    debugMode = true;
                    continue;
                }
                if (stringArray[i].equals("-nodebug")) {
                    debugMode = false;
                    continue;
                }
                if (stringArray[i].equals("-version") || stringArray[i].equals("--version")) {
                    System.out.println("Jmakepdfx version 0.3b");
                    System.exit(0);
                    continue;
                }
                if (stringArray[i].equals("-help") || stringArray[i].equals("--help")) {
                    System.out.println("Jmakepdfx version 0.3b");
                    System.out.println("");
                    System.out.println("Syntax:");
                    System.out.println("");
                    System.out.println("jmakepdfx [options]");
                    System.out.println("");
                    System.out.println("Options:");
                    System.out.println("");
                    System.out.println("-debug\t\t\tSwitch on debug mode");
                    System.out.println("-nodebug\t\tSwitch off debug mode (default)");
                    System.out.println("-version\t\tDisplay version number and exit");
                    System.exit(0);
                    continue;
                }
                throw new IllegalArgumentException("Unknown option '" + stringArray[i] + "'.");
            }
        }
        catch (Exception exception) {
            String string = "Jmakepdfx: " + exception.getMessage() + " Use --help for help.";
            JpdfxResources.error(null, string);
            System.err.println(string);
            System.exit(1);
        }
        new Jmakepdfx();
    }

    static {
        debugMode = false;
        fileSizeFormat = new DecimalFormat("#,##0.#");
        fileSizeUnits = new String[]{"B", "KB", "MB", "GB", "TB"};
    }
}

