{$IFDEF WINDOWS}
{$N-,V-,W-,G+,R-}
{$ELSE}
{$E-,N-,V-,R-}
{$ENDIF}

Unit Bibstrg;

Interface

{$IFDEF WINDOWS}
uses WinDos,wobjects;
{$ELSE}
uses DOS,objects;
{$ENDIF}

Type
  NumString = string[15];
  DelimString = string[31];

procedure StrUpr  (VAR LoStr: string);
procedure StrLwr  (VAR LoStr: string);

procedure StrIns  (VAR Dest: string; S: string; DestIndex,MaxLen: byte);

procedure ChrPadL (VAR S: string; Fill: char; Field: integer);
procedure ChrDel  (VAR S: string; Find: char);

procedure ChrDelL (VAR S: string; Find: char);
procedure ChrDelR (VAR S: string; Find: char);

procedure StrCut  (VAR S: string; MaxLen: byte);
procedure PStrCat (VAR Dest: string; S: string; MaxLen: byte);
procedure PStrCopy(VAR Dest: string; S: string; Index,Count: byte);

procedure ChrFill (VAR S: string; Fill: char; Count: integer);

function  ChrPosL  (S: string; Find: char):   byte;
function  ChrPosLI (S: string; Find: char):   byte;
function  ChrPosR  (S: string; Find: char; Nth: byte):   byte;
function  ChrPosRI (S: string; Find: char; Nth: byte):   byte;
function  ChrPosX  (S: string; Find: char; indeX: byte): byte;
function  ChrPosXI (S: string; Find: char; indeX: byte): byte;

function  StrPosL  (S,Find: string): byte;
function  StrPosLI (S,Find: string): byte;
function  StrPosR  (S,Find: string): byte;
function  StrPosRI (S,Find: string): byte;

function  ChrQty   (S: string; Find: char): byte;

function  StrCmpI  (S1,S2: string; Index1,Index2,MaxLen: integer): integer;

function  IsEmpty  (VAR S: string): boolean;
procedure Untabify (VAR S: string);
procedure UnEscape (VAR S: string; Esc: string);
procedure ReEscape (VAR S: string; Esc: string);
procedure StrRepl  (VAR S: string; Find,Repl: string; Index,Qty,MaxLen: integer);
procedure StrReplI (VAR S: string; Find,Repl: string; Index,Qty,MaxLen: integer);

procedure WrdL     (VAR Dest: string; S: string; Nth: integer);
procedure WrdToken (VAR Dest,S: string; Delims: DelimString; VAR Index: byte);
procedure WrdParse (VAR Dest,S: string; Delims: DelimString; VAR Index: byte);

function  IsAlpha(C: char): boolean;
function  IsFile (C: char): boolean;
function  IsDigit(C: char): boolean;

function  Num2Str(i: longint): NumString;
function  Byte2Hex(W: byte)  : NumString;
function  Word2Hex(W: word)  : NumString;
function  MakeIntoDate(t: longint): string;

function  IsOn (S: string): boolean;
function  IsOff(S: string): boolean;

Implementation


{ -- String Operations (5) -- }

PROCEDURE StrUpr(VAR LoStr :STRING ); ASSEMBLER;
                     {  Routine to convert a string to upper case       }
ASM
  Push ES                       {  Save Registers to be used            }
  Push DI
  Push CX
  LES DI,LoStr                  {  Point ES:DI to string to be converted}
  Sub CX,CX                     {  Clear CX                             }
  Mov CL,ES:[DI]                {  Load Length of string for looping    }
  Cmp CX,0                      {  Check for a clear string             }
  JE @Exit                      {  If it was then exit                  }
@ReadStr:
  Inc DI                        {  Point to next Character              }
  Cmp BYTE PTR ES:[DI],'z'      {  If Character above 'Z' jump to end of}
  Ja @LoopEnd                   {  loop.                                }
  Cmp BYTE PTR ES:[DI],'a'      {  if below 'A' jump to end of loop.    }
  Jb @LoopEnd
  Sub BYTE PTR ES:[DI],32       {  If not make it Lower case            }
@LoopEnd:
  Loop @ReadStr                 {  Loop Until done                      }
@Exit:
  Pop CX                        {  Restore registers                    }
  Pop DI
  Pop ES
END;{UpperCase}

PROCEDURE StrLwr(VAR LoStr :STRING ); ASSEMBLER;
                     {  Routine to convert a string to lower case       }
ASM
  Push ES                       {  Save Registers to be used            }
  Push DI
  Push CX
  LES DI,LoStr                  {  Point ES:DI to string to be converted}
  Sub CX,CX                     {  Clear CX                             }
  Mov CL,ES:[DI]                {  Load Length of string for looping    }
  Cmp CX,0                      {  Check for a clear string             }
  JE @Exit                      {  If it was then exit                  }
@ReadStr:
  Inc DI                        {  Point to next Character              }
  Cmp BYTE PTR ES:[DI],'Z'      {  If Character above 'Z' jump to end of}
  Ja @LoopEnd                   {  loop.                                }
  Cmp BYTE PTR ES:[DI],'A'      {  if below 'A' jump to end of loop.    }
  Jb @LoopEnd
  Add BYTE PTR ES:[DI],32       {  If not make it Lower case            }
@LoopEnd:
  Loop @ReadStr                 {  Loop Until done                      }
@Exit:
  Pop CX                        {  Restore registers                    }
  Pop DI
  Pop ES
END;{LowerCase}

{ -- String Insert/Delete (8) -- }

procedure ChrFill (VAR S: string; Fill: char; Count: integer);
begin
  if Count<1 then Exit;
  FillChar(S[1],Count,Fill);
  S[0]:=Chr(Count);
end;

procedure StrIns  (VAR Dest: string; S: string; DestIndex,MaxLen: byte);
begin
  Insert(S,Dest,DestIndex);
  if length(Dest)>MaxLen then Dest[0]:=Chr(Maxlen);
end;

procedure ChrPadL (VAR S: string; Fill: char; Field: integer);
var
  i: integer;
begin
  for i:=length(S)+1 to Field do S:=Fill+S;
end;

FUNCTION StripChar( s: STRING; c: CHAR ): STRING; Assembler;
ASM
      PUSH   DS
      CLD
      LDS    SI, s
      XOR    AX, AX
      LODSB
      XCHG   AX, CX
      LES    DI, @Result
      INC    DI
      JCXZ   @@3
      MOV    BL, c

@@1:  LODSB
      CMP    AL, BL
      JE     @@2
      STOSB

@@2:  LOOP   @@1

@@3:  XCHG   AX, DI
      MOV    DI, WORD PTR @Result
      SUB    AX, DI
      DEC    AX
      STOSB
      POP    DS
END;

procedure ChrDel  (VAR S: string; Find: char);
begin
  S:=StripChar(S,Find);
end;

procedure ChrDel1 (VAR S: string; Find: char);
var
  tmp: string;
  i,j: integer;
begin
  j:=0; tmp[0]:=#0;
  for i:=1 to length(S) do
    if S[i]<>Find then
    begin
      inc(j);
      move(S[i],tmp[j],1);
    end;
  tmp[0]:=Chr(j);
  S:=tmp;
end;

procedure ChrDelL(VAR S : String; Find : Char);
var
  P : integer;
begin
  P := 1;
  while (S[P] = Find) AND (P <= length(S)) do Inc(P);
  if P<=length(S) then Delete(S,1,P-1)
  else S:='';
  exit;
  {!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
  case P of
    0 : S[0] := #0; {string was 255 of C!}
    1 : ; {not found}
    else
      Move(S[P], S[1], succ(length(S) - P));
      Dec(S[0], pred(P));
  end;
  
end;

procedure ChrDelR (VAR S: string; Find: char);
var
  j: integer;
begin
  j:=length(S);
  while (j>0) and (S[j]=Find) do dec(j);
  S[0]:=Chr(j);
end;

procedure StrCut  (VAR S: string; MaxLen: byte);
begin
  if length(S)>MaxLen then S[0]:=Chr(MaxLen);
end;


{ -- String Placement (7) -- }

procedure PStrCat  (VAR Dest: string; S: string; MaxLen: byte);
var
  n: integer;
  l: byte;
begin
  l:=length(Dest);
  n:=maxlen-l;
  if (n>0) then
  begin
    StrCut(S,n);
    Dest[0]:=Chr(l+length(S));
    Move(S[1],Dest[l+1],length(S));
  end;
end;

procedure PStrCopy (VAR Dest: string; S: string; Index,Count: byte);
begin
  Dest:=Copy(S,Index,Count);
end;


{ -- String Position (12) -- }

function  ChrPosL(S : String; Find : Char) : Byte;
begin
  ChrPosL:=Pos(Find,S);
end;

Function ChrPosL1(S : String; Find : Char) : Byte; Assembler;
Asm
  CLD
  LES    DI, s
  xor    CH, CH
  xor    AH, AH
  MOV    CL, ES:[DI]
  JCXZ   @1
  MOV    BX, CX
  inC    DI
  MOV    AL, Find
  REPNE  SCASB
  JCXZ   @1
  SUB    BX, CX
  XCHG   AX, BX
  JMP    @2
@1:
  xor    AX, AX
@2:
end;

function  ChrPosLI (S: string; Find: char):   byte;
begin
  StrUpr(S);
  ChrPosLI:=ChrPosL(S,UpCase(Find));
end;

function  ChrPosR  (S: string; Find: char; Nth: byte):   byte;
var
  i: integer;
begin
  i:=length(S);
  repeat
    while (i>0) and (s[i]<>Find) do Dec(i);
    if i>0 then dec(Nth);
  until (Nth=0) or (i=0);
  ChrPosR:=i;
end;

function  ChrPosRI (S: string; Find: char; Nth: byte):   byte;
begin
  StrUpr(S);
  ChrPosRI:=ChrPosR(S,UpCase(Find),Nth);
end;

function  ChrPosX  (S: string; Find: char; Index: byte): byte;
var
  p: integer;
begin
  P:=ChrPosL(Copy(S,Index,length(S)-Index+1),Find);
  if P=0 then ChrPosX:=0
  else ChrPosX:=P+Index-1;
end;

function  ChrPosXI (S: string; Find: char; Index: byte): byte;
begin
  StrUpr(S);
  ChrPosXI:=ChrPosX(S,UpCase(Find),Index);
end;

procedure ReverseString(var S: string);
var
  i: integer;
  tmp: array[1..255] of char;
begin
  for i:=0 to length(S)-1 do tmp[length(S)-i]:=S[i+1];
  move(tmp[1],S[1],length(S));
end;

function StrPosL  (S,Find: string): byte;
begin
  StrPosL:=Pos(Find,S);
end;

function  StrPosLI (S,Find: string): byte;
begin
  StrUpr(S); StrUpr(Find);
  StrPosLI:=StrPosL(S,Find);
end;

function StrPosR  (S,Find: string): byte;
begin
  if (S='') or (length(S)<length(Find)) then StrPosR:=0
  else begin
    ReverseString(S); ReverseString(Find);
    StrPosR:=length(S)-(StrPosL(S,Find)+length(Find)-1)+1;
  end;
end;

function  StrPosRI (S,Find: string): byte;
begin
  StrUpr(S); StrUpr(Find);
  StrPosRI:=StrPosR(S,Find);
end;

{ -- String Count (4) -- }

function  ChrQty  (S: string; Find: char): byte;
var
  i,j: integer;
begin
  j:=0;
  for i:=1 to length(S) do if s[i]=Find then inc(j);
  ChrQty:=j;
end;

{ -- String Comparison (2) -- }

function  StrCmpI  (S1,S2: string; Index1,Index2,MaxLen: integer): integer;
var
  c: integer;
  ch1,ch2: char;
begin
  if (S1='') and (S2='') then
  begin
    StrCmpI:=0; Exit;
  end else if S1='' then
  begin
    StrCmpI:=-1; Exit;
  end else if S2='' then
  begin
    StrCmpI:=1; Exit;
  end;
  StrCut(S1,MaxLen); StrCut(S2,MaxLen);
  dec(Index1); dec(Index2);
  c:=0;
  while (index1<length(S1)) and (Index2<length(S2)) and (c=0) do
  begin
    inc(Index1); inc(Index2);
    ch1:=UpCase(S1[Index1]); ch2:=UpCase(S2[Index2]);
    if ch1<ch2 then c:=-1
    else if ch1>ch2 then c:=1;
  end;
  if c=0 then
  begin
    index1:=length(S1)-index1; Index2:=Length(S2)-Index2;
    if Index1<Index2 then c:=-1
    else if Index1>Index2 then c:=1;
  end;
  StrCmpI:=c;
end;

function IsEmpty(var S: string): boolean;
var
  Empty: boolean;
  i,j: integer;
begin
  Empty:=true;
  i:=0; j:=length(s);
  while empty and (i<j) do
  begin
    i:=i+1; if (s[i]<>' ') or (s[i]<>#9) then Empty:=false;
  end;
  IsEmpty:=Empty;
end;

procedure Untabify(var S: string);
var
  i: integer;
begin
  for i:=1 to length(S) do if S[i]=#9 then S[i]:=' ';
end;

procedure UnEscape(Var S: string; Esc: string);
var
  i,j: integer;
begin
  for i:=2 to length(S) do
  if S[i-1]='\' then
  begin
    j:=Pos(S[i],Esc);
    if j>0 then S[i]:=Chr(j);
  end;
end;

procedure ReEscape(Var S: string; Esc: string);
var
  i,j: integer;
begin
  for i:=2 to length(S) do
  if (S[i-1]='\') and (S[i]<>#0) and (Ord(S[i])<=length(Esc)) then
    S[i]:=Esc[Ord(S[i])];
end;

procedure StrRepl(VAR S: string; Find,Repl: string; Index,Qty,MaxLen: integer);
var
  add,i: integer;
  tmp: Pstring;
begin
  New(tmp);
  add:=0;
  tmp^:=S;
  if Index>1 then
  begin
    Add:=Index-1;
    Delete(tmp^,1,Add);
  end;
  i:=Pos(Find,tmp^);
  while (qty>0) and (i>0) and (length(tmp^)<>0) do
  begin
    dec(Qty);
    Delete(S,i+Add,length(Find));
    Insert(Repl,S,i+Add);
    Delete(tmp^,1,i+length(Find)-1);
    Add:=Add+i-1+length(Repl);
    i:=Pos(Find,tmp^);
  end;
  Dispose(tmp);
end;

procedure StrReplI (VAR S: string; Find,Repl: string; Index,Qty,MaxLen: integer);
var
  add,i: integer;
  tmp: string;
begin
  add:=0;
  tmp:=S;
  if Index>1 then
  begin
    Add:=Index-1;
    Delete(tmp,1,Add);
  end;
  StrUpr(tmp); StrUpr(Find);
  i:=Pos(Find,tmp);
  while (qty>0) and (i>0) and (length(tmp)<>0) do
  begin
    dec(Qty);
    Delete(S,i+Add,length(Find));
    Insert(Repl,S,i+Add);
    Delete(tmp,1,i+length(Find)-1);
    Add:=Add+i-1+length(Repl);
    i:=Pos(Find,tmp);
  end;
end;

{ -- String Parsing routines (11) -- }

procedure WrdL     (VAR Dest: string; S: string; Nth: integer);
Var
  i,j: integer;
begin
  Dest:='';
  j:=1;
  while (j<=length(S)) and (S[j]=' ') do inc(j);
  while (Nth>0) and (j<=length(S)) do
  begin
    i:=j;
    while (i<=length(S)) and (S[i]<>' ') do inc(i);
    if Nth=1 then Dest:=Copy(S,j,i-j);
    j:=i;
    while (j<=length(S)) and (S[j]=' ') do inc(j);
    Dec(Nth);
  end;
end;

procedure WrdToken (VAR Dest,S: string; Delims: DelimString; VAR Index: byte);
Var
  i,j: integer;
begin
  Dest:='';
  j:=Index; if j=0 then j:=1;
  while (j<=length(S)) and (Pos(S[j],Delims)>0) do inc(j);
  if j<=length(S) then
  begin
    i:=j;
    while (i<=length(S)) and (Pos(S[i],Delims)=0) do inc(i);
    Dest:=Copy(S,j,i-j);
    j:=i;
    while (j<=length(S)) and (Pos(S[j],Delims)>0) do inc(j);
  end;
  if j<=length(S) then Index:=j
  else Index:=0;
end;

procedure Wrdparse (VAR Dest,S: string; Delims: DelimString; VAR Index: byte);
Var
  i,j: integer;
begin
  Dest:='';
  j:=Index; if j=0 then j:=1;
  if (j<=length(S)) and (Pos(S[j],Delims)>0) then inc(j);
  if j<=length(S) then
  begin
    i:=j;
    while (i<=length(S)) and (Pos(S[i],Delims)=0) do inc(i);
    Dest:=Copy(S,j,i-j);
    j:=i;
    if (j<=length(S)) and (Pos(S[j],Delims)>0) then inc(j);
  end;
  if j<=length(S) then Index:=j
  else Index:=0;
end;

function IsAlpha(C: char): boolean;
begin
  IsAlpha:=(C in ['A'..'Z','a'..'z','_']);
end;

function IsFile(C: char): boolean;
begin
  IsFile:=(C in ['!','#'..')',#45,#46,'0'..'9','@'..'Z','^'..#123,#125..'~']);
end;

function IsDigit(C: char): boolean;
begin
  IsDigit:=(C in ['0'..'9']);
end;

function Num2Str(i: LongInt): NumString;
var
  tmp: numstring;
begin
  tmp:='';
  Str(i,tmp);
  Num2Str:=tmp;
end;

function Word2Hex(W: Word): NumString;
var
  T: string[4];
  ch: byte;
  i: integer;
begin
  T:='';
  for i:=1 to 4 do
  begin
    ch:=W AND $F;
    if ch<10 then ch:=ch+Ord('0') else ch:=ch-10+Ord('A');
    T:=Chr(ch)+T;
    W:=W shr 4;
  end;
  Word2Hex:=T;
end;

function byte2Hex(W: byte): NumString;
var
  T: string[2];
  ch: byte;
  i: integer;
begin
  T:='';
  for i:=1 to 2 do
  begin
    ch:=W AND $F;
    if ch<10 then ch:=ch+Ord('0') else ch:=ch-10+Ord('A');
    T:=Chr(ch)+T;
    W:=W shr 4;
  end;
  byte2hex:=T;
end;

function MakeIntoDate(t: longint): string;
var
{$IFDEF WINDOWS}
  DT: TDateTime;
{$ELSE}
  DT: DateTime;
{$ENDIF}

function LeadingZero(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
end;

begin
  UnpackTime(t,dt);
  with DT do
    MakeIntoDate:=LeadingZero(Day)+'/'+LeadingZero(month)+'/'+LeadingZero(year)
    +':'+LeadingZero(Hour)+':'+LeadingZero(min)+':'+LeadingZero(sec);
end;

function IsOn(S: string): boolean;
begin
  StrLwr(S);
  IsOn:=(S='on') or (S='yes') or (S='1') or (S='true');
end;

function IsOff(S: string): boolean;
begin
  StrLwr(S);
  IsOff:=(S='off') or (S='no') or (S='0') or (S='false');
 end;

end.
