/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.AddDelimiterOption;
import com.dickimawbooks.texparserlib.latex.datatool.CsvBlankOption;
import com.dickimawbooks.texparserlib.latex.datatool.CsvContentOption;
import com.dickimawbooks.texparserlib.latex.datatool.DataBase;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import com.dickimawbooks.texparserlib.latex.datatool.EscapeCharsOption;
import com.dickimawbooks.texparserlib.latex.datatool.FileFormatType;
import com.dickimawbooks.texparserlib.latex.datatool.FileOverwriteOption;
import com.dickimawbooks.texparserlib.latex.datatool.IOExpandOption;
import com.dickimawbooks.texparserlib.latex.latex3.PropertyCommand;
import com.dickimawbooks.texparserlib.latex.latex3.SequenceCommand;
import java.io.IOException;
import java.util.Vector;

public class IOSettings {
    DataToolSty sty;
    FileFormatType format = FileFormatType.CSV;
    String defaultName = null;
    String defaultExtension = "csv";
    String fileVersion = "3.0";
    boolean incHeader = true;
    int separator = 44;
    int delimiter = 34;
    FileOverwriteOption fileOverwriteOpt = FileOverwriteOption.ERROR;
    AddDelimiterOption addDelimOpt = AddDelimiterOption.DETECT;
    EscapeCharsOption escCharsOpt = EscapeCharsOption.DOUBLE_DELIM;
    CsvBlankOption csvBlankOpt = CsvBlankOption.IGNORE;
    CsvContentOption csvContentOpt = CsvContentOption.LITERAL;
    IOExpandOption expandOpt = IOExpandOption.NONE;
    boolean appendAllowed = false;
    boolean autoKeys = false;
    int skipLines = 0;
    boolean trimElement = true;
    String[] keys = null;
    TeXObject[] headers = null;
    DatumType[] dataTypes = null;
    int[] onlyAutoReformatCols = null;
    boolean strictQuotes = false;

    public IOSettings(DataToolSty dataToolSty) {
        this.sty = dataToolSty;
    }

    public static IOSettings fetchReadSettings(DataToolSty dataToolSty, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        IOSettings iOSettings = new IOSettings(dataToolSty);
        iOSettings.fetchSettings(true, teXParser, teXObjectList);
        return iOSettings;
    }

    public static IOSettings fetchWriteSettings(DataToolSty dataToolSty, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        IOSettings iOSettings = new IOSettings(dataToolSty);
        iOSettings.fetchSettings(false, teXParser, teXObjectList);
        return iOSettings;
    }

    public void fetchSettings(boolean bl, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        String string;
        this.defaultName = TeXParserUtils.getControlSequenceValue("l__datatool_io_name_tl", null, teXParser, teXObjectList);
        this.defaultExtension = TeXParserUtils.getControlSequenceValue("l__datatool_default_ext_tl", null, teXParser, teXObjectList);
        this.incHeader = !TeXParserUtils.isTrue("ifdtlnoheader", teXParser);
        String string2 = string = TeXParserUtils.getControlSequenceValue("l__datatool_format_tl", "csv", teXParser, teXObjectList);
        int n = string.indexOf(45);
        if (n > -1) {
            this.fileVersion = string.substring(n + 1);
            if (!this.fileVersion.equals("2") && !this.fileVersion.equals("3")) {
                throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", "format=" + string, "datatool/io");
            }
            this.fileVersion = this.fileVersion + ".0";
            string2 = string.substring(0, n);
        }
        if (string2.equals("dbtex")) {
            this.format = FileFormatType.DBTEX;
        } else if (string2.equals("dtltex")) {
            this.format = FileFormatType.DTLTEX;
        } else if (string2.equals("csv")) {
            this.format = FileFormatType.CSV;
        } else if (string2.equals("tsv")) {
            this.format = FileFormatType.TSV;
        } else {
            throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", "format=" + string, "datatool/io");
        }
        if (this.format == FileFormatType.CSV || this.format == FileFormatType.TSV) {
            this.separator = this.sty.getSeparator();
            this.delimiter = this.sty.getDelimiter();
            string = TeXParserUtils.getControlSequenceValue("l__texparser_io_csv_escape_chars_tl", "double-delim", teXParser, teXObjectList);
            object = EscapeCharsOption.fromOptionName(string);
            if (object == null) {
                throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", "csv-escape-chars=" + string, "datatool/io");
            }
            this.escCharsOpt = object;
        }
        if (bl) {
            if (this.format == FileFormatType.CSV || this.format == FileFormatType.TSV) {
                TeXObject teXObject;
                int n2;
                Object object2;
                this.autoKeys = TeXParserUtils.isTrue("ifdtlautokeys", teXParser);
                object = teXParser.getControlSequence("l__datatool_csv_keys_prop");
                if (object != null && !((AbstractTeXObject)object).isEmpty() && object instanceof PropertyCommand) {
                    object2 = (PropertyCommand)object;
                    this.keys = new String[object2.size()];
                    for (n2 = 0; n2 < this.keys.length; ++n2) {
                        teXObject = object2.get(n2 + 1);
                        if (teXObject == null) continue;
                        this.keys[n2] = teXParser.expandToString((TeXObject)teXObject.clone(), teXObjectList);
                    }
                } else {
                    this.keys = null;
                }
                if ((object = teXParser.getControlSequence("l__datatool_csv_headers_prop")) != null && !((AbstractTeXObject)object).isEmpty() && object instanceof PropertyCommand) {
                    object2 = (PropertyCommand)object;
                    this.headers = new TeXObject[object2.size()];
                    for (n2 = 0; n2 < this.headers.length; ++n2) {
                        teXObject = object2.get(n2 + 1);
                        if (teXObject == null) continue;
                        this.headers[n2] = (TeXObject)teXObject.clone();
                    }
                } else {
                    this.headers = null;
                }
                if ((object = teXParser.getControlSequence("l__datatool_csv_types_prop")) != null && !((AbstractTeXObject)object).isEmpty() && object instanceof PropertyCommand) {
                    object2 = (PropertyCommand)object;
                    this.dataTypes = new DatumType[object2.size()];
                    for (n2 = 0; n2 < this.dataTypes.length; ++n2) {
                        teXObject = object2.get(n2 + 1);
                        if (teXObject == null) continue;
                        int n3 = TeXParserUtils.toInt(teXObject, teXParser, teXObjectList);
                        try {
                            this.dataTypes[n2] = DatumType.toDatumType(n3);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new LaTeXSyntaxException((Throwable)illegalArgumentException, teXParser, "datatool.unknown_data_type", n3);
                        }
                    }
                } else {
                    this.dataTypes = null;
                }
                if ((object = teXParser.getControlSequence("l__datatool_csv_only_auto_reformat_seq")) != null && !((AbstractTeXObject)object).isEmpty() && object instanceof SequenceCommand) {
                    object2 = (SequenceCommand)object;
                    this.onlyAutoReformatCols = new int[((SequenceCommand)object2).size()];
                    for (n2 = 0; n2 < this.onlyAutoReformatCols.length; ++n2) {
                        teXObject = ((SequenceCommand)object2).get(n2);
                        try {
                            this.onlyAutoReformatCols[n2] = TeXParserUtils.toInt(teXObject, teXParser, teXObjectList);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new LaTeXSyntaxException((Throwable)illegalArgumentException, teXParser, "latex.invalid.option.value", "only-reformat-columns", teXObject.toString(teXParser));
                        }
                    }
                } else {
                    this.onlyAutoReformatCols = null;
                }
                this.skipLines = TeXParserUtils.toInt(teXParser.getListener().getControlSequence("dtl@omitlines"), teXParser, teXObjectList);
                string = TeXParserUtils.getControlSequenceValue("l__texparser_io_csv_blank_tl", "ignore", teXParser, teXObjectList);
                object2 = CsvBlankOption.fromOptionName(string);
                if (object2 == null) {
                    throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", "csv-blank=" + string, "datatool/io");
                }
                this.csvContentOpt = !TeXParserUtils.isFalse("l__datatool_csv_plain_content_bool", teXParser) ? CsvContentOption.NO_PARSE : (!TeXParserUtils.isFalse("l__datatool_csv_literal_content_bool", teXParser) ? CsvContentOption.LITERAL : CsvContentOption.TEX);
            }
            this.appendAllowed = !TeXParserUtils.isFalse("l__datatool_append_allowed_bool", teXParser);
            this.trimElement = !TeXParserUtils.isFalse("l__datatool_new_element_trim_bool", teXParser);
            this.strictQuotes = !TeXParserUtils.isFalse("l__texparser_io_strict_quotes_tl", teXParser);
        } else {
            if (this.defaultName == null) {
                this.defaultName = TeXParserUtils.getControlSequenceValue("l__datatool_default_dbname_tl", "untitled", teXParser, teXObjectList);
            }
            if ((object = FileOverwriteOption.fromOptionName(string = TeXParserUtils.getControlSequenceValue("l__texparser_io_overwrite_tl", "error", teXParser, teXObjectList))) == null) {
                throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", "overwrite=" + string, "datatool/io");
            }
            this.fileOverwriteOpt = object;
            if (this.format != FileFormatType.DBTEX) {
                string = TeXParserUtils.getControlSequenceValue("l__texparser_io_expand_tl", "none", teXParser, teXObjectList);
                IOExpandOption iOExpandOption = IOExpandOption.fromOptionName(string);
                if (iOExpandOption == null) {
                    throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", "expand=" + string, "datatool/io");
                }
                this.expandOpt = iOExpandOption;
            }
            if (this.format == FileFormatType.CSV || this.format == FileFormatType.TSV) {
                string = TeXParserUtils.getControlSequenceValue("l__texparser_io_add_delimiter_tl", "detect", teXParser, teXObjectList);
                if (string.equals("always")) {
                    this.addDelimOpt = AddDelimiterOption.ALWAYS;
                } else if (string.equals("never")) {
                    this.addDelimOpt = AddDelimiterOption.NEVER;
                } else if (string.equals("detect")) {
                    this.addDelimOpt = AddDelimiterOption.DETECT;
                } else {
                    throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", "add-delimiter=" + string, "datatool/io");
                }
            }
        }
    }

    public void apply(KeyValList keyValList, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        for (String string : keyValList.keySet()) {
            Object object;
            TeXObject teXObject = (TeXObject)keyValList.get(string);
            if (string.equals("name")) {
                if (teXObject == null) {
                    this.defaultName = null;
                    continue;
                }
                this.defaultName = teXParser.expandToString(teXObject, teXObjectList);
                continue;
            }
            if (string.equals("keys")) {
                if (teXObject == null) {
                    this.keys = null;
                    continue;
                }
                object = teXParser.expandToString(teXObject, teXObjectList).trim();
                if (((String)object).isEmpty()) {
                    this.keys = null;
                    continue;
                }
                this.keys = ((String)object).split(" *, *");
                continue;
            }
            if (string.equals("headers")) {
                if (teXObject == null && teXObject.isEmpty()) {
                    this.headers = null;
                    continue;
                }
                object = TeXParserUtils.toCsvList(teXObject, teXParser);
                this.headers = new TeXObject[((Vector)object).size()];
                for (int i = 0; i < this.headers.length; ++i) {
                    TeXObject teXObject2 = ((CsvList)object).getValue(i);
                    if (teXObject2.isEmpty()) continue;
                    this.headers[i] = teXObject2;
                }
                continue;
            }
            if (string.equals("data-types")) {
                if (teXObject == null) {
                    this.dataTypes = null;
                    continue;
                }
                object = teXParser.expandToString(teXObject, teXObjectList).trim();
                if (((String)object).startsWith(",")) {
                    object = ((String)object).substring(1).trim();
                }
                if (((String)object).isEmpty()) {
                    this.dataTypes = null;
                    continue;
                }
                String[] stringArray = ((String)object).split("( *, *)+");
                this.dataTypes = new DatumType[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        if (stringArray[i].isEmpty()) {
                            this.dataTypes[i] = DatumType.UNKNOWN;
                            continue;
                        }
                        this.dataTypes[i] = DatumType.toDatumType(stringArray[i]);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new LaTeXSyntaxException((Throwable)illegalArgumentException, teXParser, "datatool.unknown_data_type", stringArray[i]);
                    }
                }
                continue;
            }
            if (string.equals("only-reformat-columns")) {
                if (teXObject == null) {
                    this.onlyAutoReformatCols = null;
                    continue;
                }
                object = CsvList.getList(teXParser, teXObject);
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    TeXObject teXObject3 = ((CsvList)object).getValue(i, true);
                    if (teXObject3.isEmpty()) continue;
                    try {
                        this.onlyAutoReformatCols[i] = TeXParserUtils.toInt(teXObject3, teXParser, teXObjectList);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new LaTeXSyntaxException((Throwable)illegalArgumentException, teXParser, "latex.invalid.option.value", string, teXObject3.toString(teXParser));
                    }
                }
                continue;
            }
            if (string.equals("expand")) {
                object = teXObject == null ? "protected" : teXParser.expandToString(teXObject, teXObjectList).trim();
                IOExpandOption iOExpandOption = IOExpandOption.fromOptionName((String)object);
                if (iOExpandOption == null) {
                    throw new TeXSyntaxException(teXParser, "latex.invalid.option.value", string, object);
                }
                this.expandOpt = iOExpandOption;
                continue;
            }
            if (string.equals("format")) {
                if (teXObject == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                object = teXParser.expandToString(teXObject, teXObjectList).trim();
                if (((String)object).endsWith("-3")) {
                    this.fileVersion = "3.0";
                    object = ((String)object).substring(0, ((String)object).length() - 2);
                } else if (((String)object).endsWith("-2")) {
                    this.fileVersion = "2.0";
                    object = ((String)object).substring(0, ((String)object).length() - 2);
                } else if (((String)object).equals("tex")) {
                    if ("dtltex".equals(this.defaultExtension)) {
                        object = this.defaultExtension;
                    } else {
                        object = "dbtex";
                        this.fileVersion = "2.0";
                    }
                } else if (!((String)object).equals("tsv") && !((String)object).equals("csv")) {
                    this.fileVersion = "3.0";
                }
                FileFormatType fileFormatType = FileFormatType.valueOf(((String)object).toUpperCase());
                if (fileFormatType == null) {
                    throw new TeXSyntaxException(teXParser, "latex.invalid.option.value", string, object);
                }
                this.format = fileFormatType;
                switch (this.format) {
                    case CSV: {
                        this.defaultExtension = "csv";
                        break;
                    }
                    case TSV: {
                        this.separator = 9;
                        this.defaultExtension = "tsv";
                        break;
                    }
                    case DBTEX: {
                        this.defaultExtension = "dbtex";
                        break;
                    }
                    case DTLTEX: {
                        this.defaultExtension = "dtltex";
                    }
                }
                continue;
            }
            if (string.equals("add-delimiter")) {
                if (teXObject == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                object = teXParser.expandToString(teXObject, teXObjectList).trim();
                AddDelimiterOption addDelimiterOption = AddDelimiterOption.fromOptionName((String)object);
                if (addDelimiterOption == null) {
                    throw new TeXSyntaxException(teXParser, "latex.invalid.option.value", string, object);
                }
                this.addDelimOpt = addDelimiterOption;
                continue;
            }
            if (string.equals("csv-escape-chars")) {
                if (teXObject == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                object = teXParser.expandToString(teXObject, teXObjectList).trim();
                EscapeCharsOption escapeCharsOption = EscapeCharsOption.fromOptionName((String)object);
                if (escapeCharsOption == null) {
                    throw new TeXSyntaxException(teXParser, "latex.invalid.option.value", string, object);
                }
                this.escCharsOpt = escapeCharsOption;
                continue;
            }
            if (string.equals("csv-content")) {
                if (teXObject == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                object = teXParser.expandToString(teXObject, teXObjectList).trim();
                CsvContentOption csvContentOption = CsvContentOption.fromOptionName((String)object);
                if (csvContentOption == null) {
                    throw new TeXSyntaxException(teXParser, "latex.invalid.option.value", string, object);
                }
                this.csvContentOpt = csvContentOption;
                continue;
            }
            if (string.equals("csv-blank")) {
                if (teXObject == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                object = teXParser.expandToString(teXObject, teXObjectList).trim();
                CsvBlankOption csvBlankOption = CsvBlankOption.fromOptionName((String)object);
                if (csvBlankOption == null) {
                    throw new TeXSyntaxException(teXParser, "latex.invalid.option.value", string, object);
                }
                this.csvBlankOpt = csvBlankOption;
                continue;
            }
            if (string.equals("csv-skip-lines") || string.equals("omitlines")) {
                if (teXObject == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                object = teXObject.toString(teXParser).trim();
                if (((String)object).equals("false")) {
                    this.skipLines = 0;
                    continue;
                }
                try {
                    this.skipLines = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    this.skipLines = TeXParserUtils.toInt(teXObject, teXParser, teXObjectList);
                }
                continue;
            }
            if (string.equals("no-header") || string.equals("noheader")) {
                Object object2 = object = teXObject == null ? "" : teXObject.toString(teXParser).trim();
                if (((String)object).equals("") || ((String)object).equals("true")) {
                    this.incHeader = false;
                    continue;
                }
                if (((String)object).equals("false")) {
                    this.incHeader = true;
                    continue;
                }
                throw new TeXSyntaxException(teXParser, "latex.invalid.option.value", string, object);
            }
            if (string.equals("auto-keys") || string.equals("autokeys")) {
                Object object3 = object = teXObject == null ? "" : teXObject.toString(teXParser).trim();
                if (((String)object).equals("") || ((String)object).equals("true")) {
                    this.autoKeys = true;
                    continue;
                }
                if (((String)object).equals("false")) {
                    this.autoKeys = false;
                    continue;
                }
                throw new TeXSyntaxException(teXParser, "latex.invalid.option.value", string, object);
            }
            if (string.equals("overwrite")) {
                if (teXObject == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                object = teXParser.expandToString(teXObject, teXObjectList).trim();
                FileOverwriteOption fileOverwriteOption = FileOverwriteOption.fromOptionName((String)object);
                if (fileOverwriteOption == null) {
                    throw new TeXSyntaxException(teXParser, "latex.invalid.option.value", string, object);
                }
                this.fileOverwriteOpt = fileOverwriteOption;
                continue;
            }
            if (string.equals("load-action")) {
                boolean bl;
                if (teXObject == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                object = teXParser.expandToString(teXObject, teXObjectList).trim();
                if (((String)object).equals("detect") || ((String)object).equals("append")) {
                    bl = true;
                } else if (((String)object).equals("create") || ((String)object).equals("old-style")) {
                    bl = false;
                } else {
                    throw new TeXSyntaxException(teXParser, "latex.invalid.option.value", string, object);
                }
                this.appendAllowed = bl;
                continue;
            }
            if (string.equals("delimiter")) {
                if (teXObject == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                object = teXParser.expandToString(teXObject, teXObjectList);
                this.delimiter = ((String)object).codePointAt(0);
                continue;
            }
            if (string.equals("separator")) {
                if (teXObject == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                object = teXParser.expandToString(teXObject, teXObjectList);
                this.separator = ((String)object).codePointAt(0);
                continue;
            }
            if (string.equals("strict-quotes")) {
                Object object4 = object = teXObject == null ? "" : teXObject.toString(teXParser).trim();
                if (((String)object).equals("") || ((String)object).equals("true")) {
                    this.strictQuotes = true;
                    continue;
                }
                if (((String)object).equals("false")) {
                    this.strictQuotes = false;
                    continue;
                }
                throw new TeXSyntaxException(teXParser, "latex.invalid.option.value", string, object);
            }
            if (string.equals("trim")) {
                Object object5 = object = teXObject == null ? "" : teXObject.toString(teXParser).trim();
                if (((String)object).equals("") || ((String)object).equals("true")) {
                    this.trimElement = true;
                    continue;
                }
                if (((String)object).equals("false")) {
                    this.trimElement = false;
                    continue;
                }
                throw new TeXSyntaxException(teXParser, "latex.invalid.option.value", string, object);
            }
            object = teXParser.getListener().getTeXApp();
            object.warning(teXParser, object.getMessage("latex.unknown.option", string, "datatool/io"));
        }
    }

    public FileFormatType getFormat() {
        return this.format;
    }

    public void setFileFormat(FileFormatType fileFormatType) {
        this.format = fileFormatType;
    }

    public void setFileFormat(FileFormatType fileFormatType, String string) throws TeXSyntaxException {
        this.format = fileFormatType;
        this.setFileVersion(string);
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String string) {
        this.defaultName = string;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public void setDefaultExtension(String string) {
        this.defaultExtension = string;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public TeXParser getParser() {
        return this.sty == null ? null : this.sty.getParser();
    }

    public void setFileVersion(String string) throws TeXSyntaxException {
        if (!(this.format != FileFormatType.DBTEX && this.format != FileFormatType.DTLTEX || string.equals("2.0") || string.equals("3.0"))) {
            throw new LaTeXSyntaxException(this.getParser(), DataBase.ERROR_FILE_FORMAT_VERSION, new Object[]{string, this.format});
        }
        this.fileVersion = string;
    }

    public boolean isHeaderIncluded() {
        return this.incHeader;
    }

    public void setHeaderIncluded(boolean bl) {
        this.incHeader = bl;
    }

    public int getSeparator() {
        return this.separator;
    }

    public void setSeparator(int n) {
        this.separator = n;
    }

    public int getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(int n) {
        this.delimiter = n;
    }

    public FileOverwriteOption getOverwriteOption() {
        return this.fileOverwriteOpt;
    }

    public void setFileOverwriteOption(FileOverwriteOption fileOverwriteOption) {
        this.fileOverwriteOpt = fileOverwriteOption;
    }

    public AddDelimiterOption getAddDelimiterOption() {
        return this.addDelimOpt;
    }

    public void setAddDelimiterOption(AddDelimiterOption addDelimiterOption) {
        this.addDelimOpt = addDelimiterOption;
    }

    public EscapeCharsOption getEscapeCharsOption() {
        return this.escCharsOpt;
    }

    public void setEscapeCharsOption(EscapeCharsOption escapeCharsOption) {
        this.escCharsOpt = escapeCharsOption;
    }

    public boolean isCsvStrictQuotes() {
        return this.strictQuotes;
    }

    public void setCsvStrictQuotes(boolean bl) {
        this.strictQuotes = bl;
    }

    public CsvBlankOption getCsvBlankOption() {
        return this.csvBlankOpt;
    }

    public void setCsvBlankOption(CsvBlankOption csvBlankOption) {
        this.csvBlankOpt = csvBlankOption;
    }

    public boolean isCsvLiteral() {
        return this.csvContentOpt == CsvContentOption.LITERAL;
    }

    public boolean isCsvPlain() {
        return this.csvContentOpt == CsvContentOption.NO_PARSE;
    }

    public CsvContentOption getCsvContentOption() {
        return this.csvContentOpt;
    }

    public void setCsvContentOption(CsvContentOption csvContentOption) {
        this.csvContentOpt = csvContentOption;
    }

    @Deprecated
    public void setCsvLiteral(boolean bl) {
        if (bl) {
            this.csvContentOpt = CsvContentOption.LITERAL;
        } else if (this.csvContentOpt == CsvContentOption.LITERAL) {
            this.csvContentOpt = CsvContentOption.TEX;
        }
    }

    public IOExpandOption getExpandOption() {
        return this.expandOpt;
    }

    public void setExpandOption(IOExpandOption iOExpandOption) {
        this.expandOpt = iOExpandOption;
    }

    public boolean isAppendAllowed() {
        return this.appendAllowed;
    }

    public void setAppendAllowed(boolean bl) {
        this.appendAllowed = bl;
    }

    public boolean isAutoKeysOn() {
        return this.autoKeys;
    }

    public void setAutoKeys(boolean bl) {
        this.autoKeys = bl;
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public void setSkipLines(int n) {
        this.skipLines = n;
    }

    public boolean isTrimElementOn() {
        return this.trimElement;
    }

    public void setTrimElement(boolean bl) {
        this.trimElement = bl;
    }

    public void setColumnKeys(String[] stringArray) {
        this.keys = stringArray;
    }

    public void setColumnHeaders(TeXObject[] teXObjectArray) {
        this.headers = teXObjectArray;
    }

    public void setColumnHeaders(String[] stringArray, TeXParser teXParser) throws IOException {
        if (stringArray == null) {
            this.headers = null;
        } else {
            this.headers = new TeXObject[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                TeXObjectList teXObjectList = teXParser.getListener().createStack();
                teXParser.scan(stringArray[i], teXObjectList);
                this.headers[i] = teXObjectList;
            }
        }
    }

    public int getColumnKeyCount() {
        return this.keys == null ? 0 : this.keys.length;
    }

    public String getColumnKey(int n) {
        if (this.keys == null || this.keys.length < n) {
            return null;
        }
        String string = this.keys[n - 1];
        return string == null || "".equals(string) ? null : string;
    }

    public int getColumnHeaderCount() {
        return this.headers == null ? 0 : this.headers.length;
    }

    public TeXObject getColumnHeader(int n) {
        if (this.headers == null || this.headers.length < n) {
            return null;
        }
        return this.headers[n - 1];
    }

    public void setColumnTypes(DatumType[] datumTypeArray) {
        this.dataTypes = datumTypeArray;
    }

    public int getColumnTypeCount() {
        return this.dataTypes == null ? 0 : this.dataTypes.length;
    }

    public DatumType getColumnType(int n) {
        if (this.dataTypes == null || this.dataTypes.length < n) {
            return DatumType.UNKNOWN;
        }
        return this.dataTypes[n - 1];
    }

    public DatumType getLastColumnType() {
        return this.getColumnTypeCount() == 0 ? DatumType.UNKNOWN : this.dataTypes[this.dataTypes.length - 1];
    }

    public boolean isOnlyAutoReformatColsEnabled() {
        return this.onlyAutoReformatCols != null;
    }

    public boolean isOnlyAutoReformatColumnSet(int n) {
        if (this.onlyAutoReformatCols != null) {
            for (int i = 0; i < this.onlyAutoReformatCols.length; ++i) {
                if (this.onlyAutoReformatCols[i] != n) continue;
                return true;
            }
        }
        return false;
    }

    public DataToolSty getSty() {
        return this.sty;
    }

    public void setSty(DataToolSty dataToolSty) {
        this.sty = dataToolSty;
    }
}

