/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class Bib2GlsDualAbbrev
extends Bib2GlsDualEntry {
    public Bib2GlsDualAbbrev(Bib2Gls bib2Gls) {
        this(bib2Gls, "dualabbreviation");
    }

    public Bib2GlsDualAbbrev(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    @Override
    public HashMap<String, String> getMappings() {
        return this.getResource().getDualAbbrevMap();
    }

    @Override
    public String getFirstMap() {
        return this.getResource().getFirstDualAbbrevMap();
    }

    @Override
    public boolean backLink() {
        return this.getResource().backLinkFirstDualAbbrevMap();
    }

    @Override
    protected Bib2GlsDualEntry createDualEntry() {
        return new Bib2GlsDualAbbrev(this.bib2gls, this.getEntryType());
    }

    @Override
    public void checkRequiredFields() {
        if (this.getField("short") == null) {
            this.missingFieldWarning("short");
        }
        if (this.getField("long") == null) {
            this.missingFieldWarning("long");
        }
        if (this.getField("dualshort") == null) {
            this.missingFieldWarning("dualshort");
        }
        if (this.getField("duallong") == null) {
            this.missingFieldWarning("duallong");
        }
    }

    @Override
    public String getSortFallbackField() {
        String string = this.resource.getCustomEntryDefaultSortField(this.getOriginalEntryType());
        if (string != null) {
            return string;
        }
        return this.resource.getAbbrevDefaultSortField();
    }

    @Override
    public String getFallbackValue(String string) {
        if (string.equals("sort")) {
            return this.getSortFallbackValue();
        }
        if (string.equals("name")) {
            String string2 = this.resource.getAbbrevDefaultNameField();
            String string3 = this.getFieldValue(string2);
            return string3 == null ? this.getFallbackValue(string2) : string3;
        }
        if (string.equals("text")) {
            String string4 = this.resource.getAbbrevDefaultTextField();
            String string5 = this.getFieldValue(string4);
            return string5 == null ? this.getFallbackValue(string4) : string5;
        }
        return super.getFallbackValue(string);
    }

    @Override
    public BibValueList getFallbackContents(String string) {
        if (string.equals("sort")) {
            return this.getSortFallbackContents();
        }
        if (string.equals("name")) {
            String string2 = this.resource.getAbbrevDefaultNameField();
            BibValueList bibValueList = this.getField(string2);
            return bibValueList == null ? this.getFallbackContents(string2) : bibValueList;
        }
        if (string.equals("text")) {
            String string3 = this.resource.getAbbrevDefaultTextField();
            BibValueList bibValueList = this.getField(string3);
            return bibValueList == null ? this.getFallbackContents(string3) : bibValueList;
        }
        return super.getFallbackContents(string);
    }

    @Override
    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("\\%s{%s}%%%n{", this.getCsName(), this.getId());
        String string = "";
        String string2 = "";
        String string3 = "";
        Set<String> set = this.getFieldSet();
        Vector<String> vector = this.resource.getOmitFieldList(this);
        for (String string4 : set) {
            if (vector != null && vector.contains(string4)) {
                this.bib2gls.verboseMessage("message.omitting.field", new Object[]{string4, this.getId()});
                continue;
            }
            if (string4.equals("short")) {
                string2 = this.getFieldValue(string4);
                continue;
            }
            if (string4.equals("long")) {
                string3 = this.getFieldValue(string4);
                continue;
            }
            if (this.bib2gls.isKnownField(string4)) {
                printWriter.format("%s", string);
                string = String.format(",%n", new Object[0]);
                printWriter.format("%s={%s}", string4, this.getFieldValue(string4));
                continue;
            }
            if (!this.bib2gls.isDebuggingOn() || this.bib2gls.isInternalField(string4) || this.bib2gls.isKnownSpecialField(string4)) continue;
            this.bib2gls.debugMessage("warning.ignoring.unknown.field", new Object[]{string4});
        }
        printWriter.println(String.format("}%%%n{%s}%%%n{%s}", string2, string3));
        this.writeInternalFields(printWriter);
    }

    @Override
    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        printWriter.println("\\glsxtrprovidestoragekey{dualshort}{}{}");
        printWriter.println("\\glsxtrprovidestoragekey{dualshortplural}{}{}");
        printWriter.println("\\glsxtrprovidestoragekey{duallong}{}{}");
        printWriter.println("\\glsxtrprovidestoragekey{duallongplural}{}{}");
        printWriter.format("\\providecommand{\\%s}[4]{%%%n", this.getCsName());
        String string = this.getEntryType();
        string = string.endsWith("acronym") ? "acronym" : "abbreviation";
        printWriter.format("  \\new%s[#2]{#1}{#3}{#4}%%%n", string);
        printWriter.println("}");
    }
}

