/* ppmcmap.h - header file for colormap routines in libppm
*/

/* Color histogram stuff. */

typedef struct colorhist_item* colorhist_vector;
struct colorhist_item
    {
    pixel color;
    int value;
    };

typedef struct colorhist_list_item* colorhist_list;
struct colorhist_list_item
    {
    struct colorhist_item ch;
    colorhist_list next;
    };

NETPBMDLL colorhist_vector
ppm_computecolorhist( pixel ** const pixels, 
                      const int cols, const int rows, const int maxcolors, 
                      int * const colorsP );
NETPBMDLL colorhist_vector
ppm_computecolorhist2(FILE * const ifp,
                      const int cols, const int rows, 
                      const pixval maxval, const int format, 
                      const int maxcolors, int * const colorsP );

NETPBMDLL void
ppm_addtocolorhist( colorhist_vector chv, 
                    int * const colorsP, const int maxcolors, 
                    const pixel * const colorP, 
                    const int value, const int position );

NETPBMDLL void
ppm_freecolorhist( colorhist_vector chv );


/* Color hash table stuff. */

typedef colorhist_list* colorhash_table;

NETPBMDLL colorhash_table
ppm_computecolorhash( pixel ** const pixels, 
                      const int cols, const int rows, 
                      const int maxcolors, int * const colorsP );

NETPBMDLL colorhash_table
ppm_computecolorhash2(FILE * const ifp,
                      const int cols, const int rows, 
                      const pixval maxval, const int format, 
                      const int maxcolors, int * const colorsP );

NETPBMDLL int
ppm_lookupcolor( const colorhash_table cht, const pixel * const colorP );

NETPBMDLL colorhist_vector
ppm_colorhashtocolorhist( const colorhash_table cht, const int maxcolors );

NETPBMDLL colorhash_table
ppm_colorhisttocolorhash( const colorhist_vector chv, const int colors );

NETPBMDLL int
ppm_addtocolorhash( colorhash_table cht, const pixel * const colorP, 
                    const int value );
/* Returns -1 on failure. */

NETPBMDLL colorhash_table
ppm_alloccolorhash( );

NETPBMDLL void
ppm_freecolorhash( colorhash_table cht );



NETPBMDLL colorhash_table ppm_colorrowtocolorhash ARGS((pixel *colorrow, int ncolors));
NETPBMDLL pixel * ppm_computecolorrow ARGS((pixel **pixels, int cols, int rows, int maxcolors, int *ncolorsP));
NETPBMDLL pixel * ppm_mapfiletocolorrow ARGS((FILE *file, int maxcolors, int *ncolorsP, pixval *maxvalP));
NETPBMDLL void    ppm_colorrowtomapfile ARGS((FILE *ofp, pixel *colormap, int ncolors, pixval maxval));
NETPBMDLL void    ppm_sortcolorrow (pixel * const colorrow, const int ncolors, 
                          int (* cmpfunc)(pixel *, pixel *) );
NETPBMDLL int     ppm_addtocolorrow ARGS((pixel *colorrow, int *ncolorsP, int maxcolors, pixel *pixelP));
NETPBMDLL int     ppm_findclosestcolor ARGS((pixel *colorrow, int ncolors, pixel *pP));

/* standard sort function for ppm_sortcolorrow() */
#define PPM_STDSORT     (int (*)(pixel *, pixel *))0
