import geometry; 
import Header;

unitsize(x=1cm);
thinpen;
currentpen += roundcap;
currentpen += roundjoin;

pair P0,V,VR; 
pair A,Ar,B,Br;
pair a,ar,b,br;
pair vs1,vr1,vs2,vr2;
pair vRs1,vRr1,vRs2,vRr2;

real L   = 4.0;
real re  = 1.5;
real rv  = 0.85*L;
real tet = 30.0;
real tetv = tet+15.0;

P0 = (0,0);
A  = P0 + L*dir(0);
Ar = P0 + L*dir(tet);
B  = P0 + L*dir(90);
Br = P0 + L*dir(90+tet);

a  = P0 + re*dir(0);
ar = P0 + re*dir(tet);
b  = P0 + re*dir(90);
br = P0 + re*dir(90+tet);

V = P0 +rv*dir(tetv);

draw(A--P0--B,  thinpen);
draw(Ar--P0--Br,thinpen);
label("$s_1$",A, dir(0));
label("$r_1$",Ar,dir(tet));
label("$s_2$",B, dir(90));
label("$r_2$",Br,dir(90+tet));
draw(P0--a,  uvecpen, Arrow(HookHead, size=Asize));
draw(P0--ar, uvecpen, Arrow(HookHead, size=Asize));
draw(P0--b,  uvecpen, Arrow(HookHead, size=Asize));
draw(P0--br, uvecpen, Arrow(HookHead, size=Asize));
label("$\aS{e}_{s1}$",a, dir(-90));
label("$\aS{e}_{r1}$",ar,dir(-90+tet));
label("$\aS{e}_{s2}$",b, dir(180));
label("$\aS{e}_{r2}$",br,dir(180+tet));

draw(P0--V, uvecpen, Arrow(HookHead, size=Asize));
label("$\aS{x}$",V, dir(tetv));

vs1=projection(P0,A)*V;
vr1=projection(P0,Ar)*V;
vs2=projection(P0,B)*V;
vr2=projection(P0,Br)*V;

draw(V--vs1,thinpen+dashed);
draw(V--vr1,thinpen+dashed);
draw(V--vs2,thinpen+dashed);
draw(V--vr2,thinpen+dashed);
dot("$x_{s1}$",vs1, unit(vs1-V));
dot("$x_{r1}$",vr1, unit(vr1-V));
dot("$x_{s2}$",vs2, unit(vs2-V));
dot("$x_{r1}$",vr2, unit(vr2-V));



//----------------------------------------------
P0 = P0+(1.5*L,0);
A  = P0 + L*dir(0);
Ar = P0 + L*dir(tet);
B  = P0 + L*dir(90);
Br = P0 + L*dir(90+tet);

a  = P0 + re*dir(0);
ar = P0 + re*dir(tet);
b  = P0 + re*dir(90);
br = P0 + re*dir(90+tet);

draw(A--P0--B,  thinpen);
draw(Ar--P0--Br,thinpen);
label("$s_1$",A, dir(0));
label("$r_1$",Ar,dir(tet));
label("$s_2$",B, dir(90));
label("$r_2$",Br,dir(90+tet));
draw(P0--a,  uvecpen, Arrow(HookHead, size=Asize));
draw(P0--ar, uvecpen, Arrow(HookHead, size=Asize));
draw(P0--b,  uvecpen, Arrow(HookHead, size=Asize));
draw(P0--br, uvecpen, Arrow(HookHead, size=Asize));
label("$\aS{e}_{s1}$",a, dir(-90));
//label("$\aS{e}_{r1}$",ar,dir(-90+tet));
label("$\aS{e}_{s2}$",b, dir(180));
label("$\aS{e}_{r2}$",br,dir(180+tet));

tetv = 10.0;

V  = P0 + rv*dir(tetv);
VR = P0 + rv*dir(tet+tetv);

draw(P0--V, uvecpen, Arrow(HookHead, size=Asize));
draw(P0--VR, uvecpen, Arrow(HookHead, size=Asize));
label("$\aS{x}$",  V,  dir(tetv));
label("$\aS{x}_R$",VR, dir(tetv+tet));

vs1=projection(P0,A)*V;
vr1=projection(P0,Ar)*V;
vs2=projection(P0,B)*V;
vr2=projection(P0,Br)*V;

vRs1=projection(P0,A)*VR;
vRr1=projection(P0,Ar)*VR;
vRs2=projection(P0,B)*VR;
vRr2=projection(P0,Br)*VR;

draw(V--vs1,thinpen+dashed);
draw(VR--vRs1,thinpen+dashed);
draw(VR--vRr1,thinpen+dashed);
dot("$x_{s1}$",vs1,  unit(vs1-V));
dot("$x_{{s1}_R}$",vRs1, unit(vRs1-VR));
dot("$x_{{r1}_R}$",vRr1, unit(vRr1-VR));


