# chklref

Written by Jerome Lelong <jerome.lelong@gmail.com> and distributed under the terms of GNU GPLv3.

## Installation

### System wide installation

#### Installation into the TeX structure

This package follows the TDS[1]

- put the TeX package `chklref.sty` into `$(texmf_prefix)/tex/latex/chklref`
- put the documentation `doc/chklref.pdf` into `$(texmf_prefix)/doc/latex/chklref`
- put the man page `doc/chklref.1` into `$(texmf_prefix)/doc/man/man1`
- put the Perl parser `chklref.pl` into `$(texmf_prefix)/scripts/chklref`

Note that you will also need to make a link or copy `chklref.pl` to a location in your `PATH`. On Unix systems, you may need to set the script as executable.

Depending on your OS and TeX distribution, the `TEXMF` directory `texmf_prefix` can have different values

- **Single account installation under Linux** `~/texmf`.
- **Single account installation under Mac OS X** `~/texmf` or `$HOME/Library/texmf`.
- **System wide installation under Linux** `/usr/share/texmf-local/`.
- **System wide installation under Mac OS X** `/usr/local/texlive/texmf-local/`.
- **Under Windows** something like `C:\localtexmf\`. Check in your distribution settings.

**You may need to run `texhash` to update your TeX Directory Structure.**

The fastest way to carry out the installation is to use the file `chklref.tds.zip` included in the numbered releases (not available inside the git repository). You just have to unzip it inside the proper `texmf_prefix`. Alternatively, you can copy the files by hand. On Unix systems, you may need to set the script as executable.

#### Local installation

Instead of carrying out a system wide installation, you can simply copy the package file `chklref.sty` next to your main LaTeX file and put the Perl script `chklref.pl` next to it or in anywhere in your `PATH`. On Unix systems, you may need to set the script as executable.

## Requirements

The `chklref` tool is mainly written in TeX with a small Perl script to parse the output generated by the TeX package. It should be working with any standard Perl installation.

The Perl script calls a LaTeX compiler to extract labels related information.

## Usage

You typically just run: `perl chklref.pl file.tex`

The full calling syntax is `perl chklref.pl [options] file.tex`, where `options` can be

- `--tex <compiler>`, `-t`: Specify the TeX compiler to be used. Default is `pdflatex`.
- `--tex-options`: List of options to pass to the TeX compiler. It should be a quoted string of white space delimited options. Note that we always add `-interaction nonstopmode` on top of these options.
- `--debug`, `-d`: Run in debug mode. Do not clean the generated `.chk` file.
- `--quiet`, `-q`: Run in quiet mode. Do not print the output of the TeX compiler.
- `--parse-only`: Do not run the LaTeX compiler but use the already existing `.chk` file. When this option is passed, the following other options are meaningless: `--tex`, `--tex-options`, `--quiet`, `--debug`.
- `--version`, `-v`: Print the version of this script.
- `--help,h`: Print this help.

Alternatively, you can directly add `\usepackage{chklref}` to your main LaTeX file and compile it normally. This will create a file with extension `.chk`, which can then be parsed by the Perl script:

    perl chklref.pl --parse-only file.tex

Note that you need to pass the \verb!.tex! file to the parser not the `.chk` file.

## Bugs

Report bugs to https://github.com/jlelong/chklref.

`chklref` is known not to work with `cleveref`. If you would like to contribute to `chklref`, feel free to open a PR on https://github.com/jlelong/chklref.

[1] : TeX Directory Structure http://www.tug.org/twg/tds/
