require("lTpX")

pic = TpXpic:Create(
  {PicScale=1, Border=2, TeXFormat="none", PdfTeXFormat="none",
  BitmapRes=11811, PicMagnif=1, IncludePath="",
  MiterLimit=10, LineWidth=0.35})
pic:setComment("A sample TpXpy picture: Roulette")

--pic:addCurve({{60,45}, {55,45}, {50,40}, {36,45}}, {lw=0.5})

function TransformPoint(P,T)
  return {T[1][1]*P[1] + T[2][1]*P[2] + T[3][1],
   T[1][2]*P[1] + T[2][2]*P[2] + T[3][2]}
end

function TransformPoints(PP,T)
  PP2 = {}
  for i,P in ipairs(PP) do
    table.insert(PP2, TransformPoint(P,T))
  end
  return PP2
end

digits = {}
digits[0] = {{62,104}, {62,102}, {62,87}, {62,85}, {62,83}, {60,83}, {60,85}, {60,87}, {60,117}, {60,119}, {60,121}, {62,121}, {62,119}, {62,117}, {62,105}, {62,103}, {64,103}, {66,103}, {68,103}, {68,105}, {68,118}, {68,120}, {68,122}, {66,124}, {64,124}, {62,124}, {60,124}, {58,124}, {56,124}, {54,122}, {54,120}, {54,118}, {54,86}, {54,84}, {54,82}, {56,80}, {58,80}, {60,80}, {62,80}, {64,80}, {66,80}, {68,82}, {68,84}, {68,86}, {68,102}, {68,104}, {66,104}, {64,104}}
digits[1] = {{74,80}, {76,80}, {78,80}, {80,80}, {80,82}, {80,122}, {80,124}, {78,124}, {77,124}, {75,124}, {75,122}, {73,118}, {70,117}, {70,115}, {70,114}, {70,112}, {70,112}, {73,113}, {74,114}, {74,112}, {74,82}}
digits[2] = {{86,80}, {88,80}, {98,80}, {100,80}, {100,81}, {100,83}, {100,84}, {98,84}, {94,84}, {92,84}, {92,85}, {92,84}, {92,86}, {92,90}, {100,102}, {100,106}, {100,108}, {100,118}, {100,120}, {100,122}, {98,124}, {96,124}, {94,124}, {92,124}, {90,124}, {88,124}, {86,122}, {86,120}, {86,118}, {86,110}, {86,108}, {88,108}, {90,108}, {92,108}, {92,110}, {92,117}, {92,119}, {92,121}, {94,121}, {94,119}, {94,117}, {94,108}, {94,106}, {94,102}, {86,90}, {86,86}, {86,83}, {86,82}}
digits[3] = {{108,80}, {110,80}, {112,80}, {114,80}, {116,80}, {118,82}, {118,84}, {118,86}, {118,96}, {118,98}, {118,100}, {116,102.4}, {114,102.4}, {114,102.8}, {114,102.8}, {114,102.8}, {116,102.8}, {118,105}, {118,107}, {118,109}, {118,118}, {118,120}, {118,122}, {116,124}, {114,124}, {112,124}, {110,124}, {108,124}, {106,124}, {104,122}, {104,120}, {104,118}, {104,111}, {104,109}, {106,109}, {108,109}, {110,109}, {110,111}, {110,117}, {110,119}, {110,121}, {112,121}, {112,119}, {112,117}, {112,109}, {112,107}, {112,105}, {110,104}, {108,104}, {108,103}, {108,102}, {108,101}, {110,101}, {112,100}, {112,98}, {112,96}, {112,87}, {112,85}, {112,83}, {110,83}, {110,85}, {110,87}, {110,94}, {110,96}, {108,96}, {106,96}, {104,96}, {104,94}, {104,86}, {104,84}, {104,82}, {106,80}}
digits[4] = {{130,80}, {131.5,80}, {134.5,80}, {136,80}, {136,91}, {136,113}, {136,124}, {133.75,124}, {129.25,124}, {127,124}, {125.5,116.75}, {122.5,102.25}, {121,95}, {121,94}, {121,92}, {121,91}, {125.25,91}, {133.75,91}, {138,91}, {138,92}, {138,94}, {138,95}, {135,95}, {129,95}, {126,95}, {127,100.5}, {129,111.5}, {130,117}, {130,107.75}, {130,89.25}}
digits[5] = {{142,124}, {144,124}, {154,124}, {156,124}, {156,123}, {156,121}, {156,120}, {154,120}, {150,120}, {148,120}, {148,118}, {148,112}, {148,111}, {149,112}, {150,112}, {152,112}, {154,112}, {156,110}, {156,108}, {156,106}, {156,86}, {156,84}, {156,82}, {154,80}, {152,80}, {150,80}, {148,80}, {146,80}, {144,80}, {142,82}, {142,84}, {142,86}, {142,94}, {142,96}, {144,96}, {146,96}, {148,96}, {148,94}, {148,87}, {148,85}, {148,83}, {150,83}, {150,85}, {150,87}, {150,104}, {150,106}, {150,108}, {148,108}, {148,106}, {148,105}, {148,103}, {148,102}, {146,102}, {144,102}, {142,102}, {142,104}, {142,122}}
digits[6] = {{165,124}, {167,124}, {169,124}, {171,124}, {173,124}, {175,122}, {175,120}, {175,118}, {175,113}, {175,111}, {173,111}, {171,111}, {169,111}, {169,113}, {169,117}, {169,119}, {169,121}, {167,121}, {167,119}, {167,117}, {167,107}, {167,106}, {168,107}, {169,107}, {171,107}, {173,107}, {175,105}, {175,103}, {175,101}, {175,86}, {175,84}, {175,82}, {173,80}, {171,80}, {169,80}, {167,80}, {165,80}, {163,80}, {161,82}, {161,84}, {161,86}, {161,94}, {161,96}, {163,96}, {165,96}, {167,96}, {167,94}, {167,87}, {167,85}, {167,83}, {169,83}, {169,85}, {169,87}, {169,99}, {169,101}, {169,103}, {167,103}, {167,101}, {167,100}, {167,95}, {167,93}, {165,93}, {163,93}, {161,93}, {161,95}, {161,118}, {161,120}, {161,122}, {163,124}}
digits[7] = {{180,80}, {181.5,80}, {184.5,80}, {186,80}, {188,90}, {192,110}, {194,120}, {194,121}, {194,123}, {194,124}, {190,124}, {182,124}, {178,124}, {178,123}, {178,121}, {178,120}, {180.5,120}, {185.5,120}, {188,120}, {186,110}, {182,90}}
digits[8] = {{202,80}, {204,80}, {206,80}, {208,80}, {210,80}, {212,82}, {212,84}, {212,86}, {212,96}, {212,98}, {212,100}, {210,102.4}, {208,102.4}, {208,102.8}, {208,102.8}, {208,102.8}, {210,102.8}, {212,105}, {212,107}, {212,109}, {212,118}, {212,120}, {212,122}, {210,124}, {208,124}, {206,124}, {204,124}, {202,124}, {200,124}, {198,122}, {198,120}, {198,118}, {198,113}, {198,111}, {200,111}, {202,111}, {204,111}, {204,113}, {204,117}, {204,119}, {204,121}, {206,121}, {206,119}, {206,117}, {206,109}, {206,107}, {206,105}, {204,105}, {204,107}, {204,109}, {204,114}, {204,116}, {202,116}, {200,116}, {198,116}, {198,114}, {198,109}, {198,107}, {198,105}, {200,102.8}, {202,102.8}, {202,102.4}, {202,102.4}, {202,102.4}, {200,102.4}, {198,100}, {198,98}, {198,96}, {198,92}, {198,90}, {200,90}, {202,90}, {204,90}, {204,92}, {204,96}, {204,98}, {204,100}, {206,100}, {206,98}, {206,96}, {206,87}, {206,85}, {206,83}, {204,83}, {204,85}, {204,87}, {204,93}, {204,95}, {202,95}, {200,95}, {198,95}, {198,93}, {198,86}, {198,84}, {198,82}, {200,80}}
digits[9] = {{227,80}, {225,80}, {223,80}, {221,80}, {219,80}, {217,82}, {217,84}, {217,86}, {217,91}, {217,93}, {219,93}, {221,93}, {223,93}, {223,91}, {223,87}, {223,85}, {223,83}, {225,83}, {225,85}, {225,87}, {225,97}, {225,98}, {224,97}, {223,97}, {221,97}, {219,97}, {217,99}, {217,101}, {217,103}, {217,118}, {217,120}, {217,122}, {219,124}, {221,124}, {223,124}, {225,124}, {227,124}, {229,124}, {231,122}, {231,120}, {231,118}, {231,110}, {231,108}, {229,108}, {227,108}, {225,108}, {225,110}, {225,117}, {225,119}, {225,121}, {223,121}, {223,119}, {223,117}, {223,105}, {223,103}, {223,101}, {225,101}, {225,103}, {225,105}, {225,109}, {225,111}, {227,111}, {229,111}, {231,111}, {231,109}, {231,86}, {231,84}, {231,82}, {229,80}}
digits_width = {}
for d = 0, 9 do
  dd = digits[d]
  minX = 1000000; minY = 1000000
  maxX = -1000000
  for i = 1, #dd do
    if dd[i][1]<minX then minX = dd[i][1] end
    if dd[i][2]<minY then minY = dd[i][2] end
    if dd[i][1]>maxX then maxX = dd[i][1] end
  T = {{1,0},{0,1},{-minX,-minY}}
  digits[d] = TransformPoints(dd,T)
  digits_width[d] = maxX-minX
  end
end

numbers = {-1,1,13,36,24,3,15,34,22,5,17,32,20,7,11,30,26,9,28,0,2,14,35,23,4,16,33,21,6,18,31,19,8,12,29,25,10,27}

cos = {}; sin = {}
for i = 1, 39 do
  table.insert(cos, math.cos(math.pi/19*(i-1)))
  table.insert(sin, math.sin(math.pi/19*(i-1)))
end
pic:addCircle(0,0,146, {lc='gray',lw=2, fill='#A94E2C'}) --li='none'
for i = 1, 38 do
  j=i+1
  if (i==1) or (i==20) then tmpfill = 'mediumseagreen'
  elseif i%2==1 then tmpfill = 'crimson'
  else tmpfill = 'black' end
  pic:addPolygon({{31*cos[i],31*sin[i]}, {48*cos[i],48*sin[i]},
   {48*cos[j],48*sin[j]}, {31*cos[j],31*sin[j]}}, 
   {li='none', fill=tmpfill})
end
for i = 1, 38 do
  pic:addLine(31*cos[i],31*sin[i], 48*cos[i],48*sin[i], {lc='gray', lw=3})
end
pic:addCircle(0,0,124, {lc='gray', lw=4})
pic:addCircle(0,0,96, {lc='gray', lw=4})
pic:addCircle(0,0,80, {lc='gray', lw=2})
pic:addCircle(0,0,62, {lc='gray', lw=4, fill='wheat'})
pic:addCircle(-25,-28,4, {lc='wheat', lw=1, fill='lightslategray'})

function DigitRender(acos,asin,s,PP,T)
  PP = TransformPoints(PP,T)
  T = {{asin*s,-acos*s},{acos*s,asin*s},{41.7*acos, 41.7*asin}}
  PP = TransformPoints(PP,T)
  pic:addBezier(PP, {closed=1, li='none', fill='beige'}) --fill='white'
end

for i = 1, 38 do
  j=i+1
  acos = (cos[i]+cos[j])/2
  asin = (sin[i]+sin[j])/2
  s = 0.1
  d1 = math.floor(numbers[i]/10)
  d2 = numbers[i]%10
  if d1==0 then d1 = -2 end
  if d1==-1 then d1 = 0; d2 = 0 end
  if d1>-2 then
    w1 = digits_width[d1]
    w2 = digits_width[d2]
    w = w1 + w2 + 4
  else
    w = digits_width[d2]
    d1 = d2
    w2 = 0
  end
  PP = digits[d1]
  T = {{1,0},{0,1},{-w/2, 0}}
  DigitRender(acos,asin,s,PP,T)
  if w2 > 0 then
    PP = digits[d2]
    T = {{1,0},{0,1},{w/2-w2, 0}}
    DigitRender(acos,asin,s,PP,T)
  end
end
fname = "Roulette.TpX"
pic:write(fname)
os.execute(fname)
