# The QWorld Package

## Overview

### A TeX-native framework for string diagram typesetting

**QWorld** is a LaTeX package designed for the typesetting of **graphical languages** grounded in **monoidal category theory** and its extensions. It provides a declarative, LaTeX-native interface for rendering **string diagrams**, eliminating the need for any external graphics software or manual image management.

The package supports a wide spectrum of categorical structures frequently encountered in **categorical quantum mechanics**, algebraic structures, and diagrammatic reasoning, including but not limited to:

- Monoidal and symmetric monoidal categories
- Dual objects and pivotal / rigid categories 
- Dagger categories
- Frobenius algebras and Hopf algebras
- Braided, balanced, and ribbon categories

Internally, QWorld builds upon the TikZ graphics framework, but introduces a domain-specific layer of abstraction that aligns diagram syntax closely with categorical semantics. This design facilitates accurate and transparent visual representations of morphisms, tensor products, and composition, thereby supporting both formal exposition and pedagogical use.

QWorld is intended for researchers and educators working in categorical logic, quantum foundations, **topological quantum field theory** (**TQFT**), and related domains where graphical calculi constitute an essential mode of reasoning.

## Installation

Once the package is available in a TeX distribution via [CTAN](https://ctan.org/pkg/qworld), you can use it in your document by adding:

```\usepackage{qworld}
```

Alternatively, to install it manually:

1. Download the package's `.sty` file.
2. Place it in your LaTeX working directory or an appropriate directory within your TeX distribution.
3. Add `\usepackage{qworld}` to the preamble of your document.
4. Run `texhash` if necessary to update the file database.

## Usage

Below is a basic example of how to use qworld

```\documentclass{article}
\usepackage{qworld}

\begin{document}
    \[\q{\qbox\qbox}=\q{\qbox}\otimes\q{\qbox}\]
\end{document}
```

For more detailed usage instructions, refer to the package documentation.

## License

This package is distributed under the [LaTeX Project Public License (LPPL)](https://www.latex-project.org/lppl.txt), version 1.3c or later.

## Copyright

© 2025 Niina Ryota

This Package consists of the following files:

- `qworld.sty` (the main package file)
- `qworld.pdf` (documentation compiled from `qworld.tex`)
- `qworld.tex` (LaTeX source file for documentation)
- `qworld_en.tex` (LaTeX source file for the English version of the documentation; compiled into `qworld_en.pdf`)
- `qworld_en.pdf` (compiled English documentation; English version of `qworld.pdf`)

The current maintainer of this package is **Niina Ryota**.

## Modification Policy

Under the terms of the LPPL:

- Any modifications must **not** be distributed under the original package name.
- Any modified versions must clearly state that they are derived from this package.
- The original author (Niina Ryota) must always be credited in derived works.

## Contact

Author: Niina Ryota
Email: qworld-package@googlegroups.com

## Change Log

### 1.1.2 (2025-07-28)

- Fixed typos in the English documentation (qworld_en.pdf) and the corresponding TeX source file (qworld_en.tex).
This change only affects the English documentation (qworld_en.pdf) and the TeX source file (qworld_en.tex), and does not impact the style file.

### 1.1.1 (2025-04-14)

- Color annotation for wires and tangles
  - The `frame color` attribute is now supported for CAP and CUP structures, allowing wires to express object identity through color.
  - Additionally BRAIDING now supports separate `L color` and `R color` options for independently coloring the left and right wires.
- Improved wire rendering
  - The rendering of curves has been refined to produce smoother and more aesthetically coherent diagrams.

### 1.1.0 (2025-04-03)

- Argument structure revised for symbol commands
  - The following commands were updated to support key-value-style optional arguments instead of mandatory positional arguments:
    - `\symbolI`
    - `\symbols`
    - `\symbolS`
    - `\symbolO`
    - `\symboln`
    - `\symbolN`
  - Specific changes:
    - Old format: `\symbolI[i]{ID}{text}[position options]`
    - New format: `\symbolI[i]{text}[position opotions, id=ID]`
  - With this revision, the `ID` parameter is now optional. In simple cases, `\symbolI{text}` suffices. This change enables more concise and readable definitions.
- English documentation
  - An English version of the user guide has been added.

### 1.0.0 (2025-04-01)

- Initial release.

## Contributions

Bug reports, feature requests, and contributions are welcome. Please contact qworld-package@googlegroups.com for inquires or to submit issues.