// CreateBBDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include <shlobj.h>
#include <direct.h>
#include "CreateBB.h"
#include "CreateBBDlg.h"
#include "FileTypeDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int CALLBACK SHBrowseProc( HWND, UINT, LPARAM, LPARAM );

#define BMP 1
#define WMF 2
#define EMF 4
#define JPG 8
#define MAG 16
#define EPS 32

/////////////////////////////////////////////////////////////////////////////
// AvP[Ṽo[WŎgĂ CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CEdit	m_editInformation;
	//}}AFX_DATA

	// ClassWizard ͉z֐̃I[o[Ch𐶐܂
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV ̃T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_EDIT_INFORMATION, m_editInformation);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCreateBBDlg _CAO

CCreateBBDlg::CCreateBBDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCreateBBDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCreateBBDlg)
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCreateBBDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCreateBBDlg)
	DDX_Control(pDX, IDC_CHECK_SELECT_ONLY, m_buttonSelectOnly);
	DDX_Control(pDX, IDC_CHECK_STOP, m_buttonStop);
	DDX_Control(pDX, IDC_CHECK_REPRESS, m_buttonRepress);
	DDX_Control(pDX, IDC_CHECK_RECURSIVE, m_buttonRecursive);
	DDX_Control(pDX, IDC_CHECK_COMPRESS, m_buttonCompress);
	DDX_Control(pDX, IDC_EDIT_PROGRESS, m_editProgress);
	DDX_Control(pDX, IDC_STATIC_DIRNAME, m_staticDirName);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCreateBBDlg, CDialog)
	//{{AFX_MSG_MAP(CCreateBBDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_BROWSE, OnButtonBrowse)
	ON_BN_CLICKED(IDC_BUTTON_FILE_TYPE, OnButtonFileType)
	ON_BN_CLICKED(IDC_CHECK_SELECT_ONLY, OnCheckSelectOnly)
	ON_BN_CLICKED(IDC_CHECK_RECURSIVE, OnCheckRecursive)
	ON_BN_CLICKED(IDC_BUTTON_SELECT_FILE, OnButtonSelectFile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCreateBBDlg bZ[W nh

BOOL CCreateBBDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// "o[W..." j[ڂVXe j[֒ǉ܂B

	// IDM_ABOUTBOX ̓R}h j[͈̔͂łȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	m_buttonStop.EnableWindow( FALSE );

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	m_nFileType = AfxGetApp()->GetProfileInt( "Settings", "FileType", BMP | WMF | EMF | EPS );
	m_strTranslateDirectory = AfxGetApp()->GetProfileString( "Settings", "directory", "*DEFAULT*" );
	if( m_strTranslateDirectory == "*DEFAULT*" )
		if( GetMyDocumentFolder() == FALSE )
			m_strTranslateDirectory = "c:\\";
	m_buttonCompress.SetCheck(
		AfxGetApp()->GetProfileInt("Settings", "compress", FALSE) );
	m_buttonRecursive.SetCheck(
		AfxGetApp()->GetProfileInt("Settings", "recursive", FALSE) );
	if( m_buttonRecursive.GetCheck() )
	{
		m_buttonSelectOnly.SetCheck( FALSE );
		m_buttonSelectOnly.EnableWindow( FALSE );
	}
	m_buttonRepress.SetCheck(
		AfxGetApp()->GetProfileInt("Settings", "repress", TRUE) );
	m_buttonSelectOnly.SetCheck(
		AfxGetApp()->GetProfileInt("Settings", "selectonly", FALSE) );
	if( m_buttonSelectOnly.GetCheck() )
	{
		m_buttonRecursive.SetCheck( FALSE );
		m_buttonRecursive.EnableWindow( FALSE );
	}

	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIcon, FALSE);		// ACRݒ
	
	// TODO: ʂȏs͂̏ꏊɒǉĂB
	m_staticDirName.SetWindowText( m_strTranslateDirectory );
	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

void CCreateBBDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CCreateBBDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CCreateBBDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCreateBBDlg::OnButtonBrowse() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	BROWSEINFO bi;
	ITEMIDLIST* pidl;

	ZeroMemory( &bi, sizeof(BROWSEINFO) );

	char temp[MAX_PATH];
	lstrcpy( temp, m_strTranslateDirectory );

	bi.hwndOwner = m_hWnd;
	bi.lpfn = SHBrowseProc;
	bi.lParam = (LPARAM)temp;
	bi.lpszTitle = "Select a folder to create BoundingBox file";
	pidl = SHBrowseForFolder( &bi );
	if( pidl )
	{
		SHGetPathFromIDList( pidl, temp );
		IMalloc* pMalloc;
		SHGetMalloc( &pMalloc );
		if( pMalloc )
		{
			pMalloc->Free( pidl );
			pMalloc->Release();
		}
		if( (DWORD)lstrlen(temp) < MAX_PATH )
			m_strTranslateDirectory = temp;
		m_staticDirName.SetWindowText( m_strTranslateDirectory );
		return;
	}
	
}

int CALLBACK SHBrowseProc( HWND hWnd, UINT uMsg, LPARAM lParam, LPARAM lpData )
{
	if( uMsg == BFFM_INITIALIZED && lpData )
		SendMessage( hWnd, BFFM_SETSELECTION, TRUE, lpData );
	return 0;
}

BOOL CCreateBBDlg::GetMyDocumentFolder()
{
	char szPath[MAX_PATH];
	ITEMIDLIST* pidl;
	IMalloc* pMalloc;
	if( SUCCEEDED( SHGetMalloc(&pMalloc) ) )
	{
		SHGetSpecialFolderLocation( m_hWnd, CSIDL_PERSONAL, &pidl );
		if( SHGetPathFromIDList( pidl, szPath ) == FALSE ) return FALSE;
		pMalloc->Free( pidl );
		pMalloc->Release();
	}
	m_strTranslateDirectory = szPath;
	return TRUE; 
}

void CCreateBBDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	m_strProgress = "";
	m_buttonStop.SetCheck( FALSE );
	m_buttonStop.EnableWindow();
	ProgressMessage( "OK, start to create Bounding Box file(s).\r\n" );
	SearchGraphicFile( m_strTranslateDirectory );
	if( m_buttonStop.GetCheck() )
		ProgressMessage( "Stopped by you.\r\n" );
	else
		ProgressMessage( "Complete.\r\n" );
	m_buttonStop.SetCheck( FALSE );
	m_buttonStop.EnableWindow( FALSE );
	//CDialog::OnOK();
}

void CCreateBBDlg::ProgressMessage(CString str)
{
	m_strProgress += str;
	m_editProgress.SetWindowText( m_strProgress );
	m_editProgress.LineScroll( max( 0, m_editProgress.GetLineCount() - 4 ) );
	return;
}

BOOL CCreateBBDlg::CreateBB(CString filename, const char* ext)
{
	if( lstrcmpi(ext, "EPS") == 0 ) return CreatePfi(filename);

	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	ZeroMemory( &pi, sizeof(PROCESS_INFORMATION) );
	ZeroMemory( &si, sizeof(STARTUPINFO) );

	si.cb = sizeof(STARTUPINFO);
	si.dwFlags = STARTF_USESHOWWINDOW;
	si.wShowWindow = SW_HIDE;

	char bmc[MAX_PATH];
	wsprintf( bmc, "bmc.exe -b \"%s\"", filename );
	BOOL bSuccess = CreateProcess( 
		NULL, bmc, NULL, NULL, FALSE, 
		CREATE_NEW_CONSOLE, NULL, NULL, &si, &pi );
	if( bSuccess )
	{
		CloseHandle( pi.hThread );
		if( WaitForSingleObject(pi.hProcess, INFINITE) != WAIT_FAILED )
		{
			DWORD dwExitCode;
			char errcode[32];
			if( GetExitCodeProcess(pi.hProcess,&dwExitCode) )
			{
				if( dwExitCode != 0 ) // ERRLEVEL != 0 --- error may occur
				{
					wsprintf( errcode, "ERROR CODE=%d\r\n", dwExitCode );
					ProgressMessage( errcode );
				}
				else // ERRLEVEL = 0
					ProgressMessage( "done.\r\n" );
			}
			else // ERRLEVEL didn't return
				ProgressMessage( "unexpected error!\r\n" );
		}
		CloseHandle( pi.hProcess );
		return TRUE;
	}
	else // CreateProcess failed.
	{
		ProgressMessage( "Cannot run BMC.EXE, why?\r\n" );
		return FALSE;
	}
} 

BOOL CCreateBBDlg::CompressBMP(CString filename)
{
	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	ZeroMemory( &pi, sizeof(PROCESS_INFORMATION) );
	ZeroMemory( &si, sizeof(STARTUPINFO) );

	si.cb = sizeof(STARTUPINFO);
	si.dwFlags = STARTF_USESHOWWINDOW;
	si.wShowWindow = SW_HIDE;

	char bmc[MAX_PATH];
	wsprintf( bmc, "bmc.exe \"%s\"", filename );
	BOOL bSuccess = CreateProcess( 
		NULL, bmc, NULL, NULL, FALSE, 
		CREATE_NEW_CONSOLE, NULL, NULL, &si, &pi );
	if( bSuccess )
	{
		CloseHandle( pi.hThread );
		if( WaitForSingleObject(pi.hProcess, INFINITE) != WAIT_FAILED )
			ProgressMessage( "done.\r\n" );
		CloseHandle( pi.hProcess );
		return TRUE;
	}
	else
	{
		ProgressMessage( "Cannot run BMC.EXE, why?\r\n" );
		return FALSE;
	}
}

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	CString strInf;
	strInf.LoadString(IDS_STRING_INFORMATION);
	m_editInformation.SetWindowText( strInf );
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CCreateBBDlg::SearchGraphicFile(const char *folder)
{
	WIN32_FIND_DATA ffd;
	_chdir( folder );

	if( m_buttonSelectOnly.GetCheck() == FALSE )
	{
		if( m_nFileType & BMP )
			TranslateGraphicFile( m_strTranslateDirectory, "BMP", m_buttonCompress.GetCheck() );
		if( (m_nFileType & BMP) && m_buttonCompress.GetCheck() == FALSE )
			TranslateGraphicFile( m_strTranslateDirectory, "BMC" );
		if( m_nFileType & WMF )
			TranslateGraphicFile( m_strTranslateDirectory, "WMF" );
		if( m_nFileType & EMF )
			TranslateGraphicFile( m_strTranslateDirectory, "EMF" );
		if( m_nFileType & JPG )
		{
			TranslateGraphicFile( m_strTranslateDirectory, "JPG" );
			TranslateGraphicFile( m_strTranslateDirectory, "JPEG" );
		}
		if( m_nFileType & MAG )
			TranslateGraphicFile( m_strTranslateDirectory, "MAG" );
		if( m_nFileType & EPS ) 
			TranslateGraphicFile( m_strTranslateDirectory, "EPS" );
	}
	if( m_buttonRecursive.GetCheck() )
	{
		HANDLE hFind = FindFirstFile( "*.*", &ffd );
		if( hFind == INVALID_HANDLE_VALUE ) return;
		do
		{
			if( ffd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
			{
				if( lstrcmp(ffd.cFileName, ".") == 0
				 || lstrcmp(ffd.cFileName, "..") == 0 ) continue;
				if( m_buttonRepress.GetCheck() == FALSE )
				{
					char msg[MAX_PATH];
					wsprintf( msg, "find a folder %s.\r\n", ffd.cFileName );
					ProgressMessage( msg );
				}
				char todir[MAX_PATH];
				wsprintf( todir, "%s\\%s", folder, ffd.cFileName );
				MSG msg;
				while ( ::PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) ) 
				{ 
					if ( !AfxGetApp()->PumpMessage( ) ) break; 
				} 
				if( m_buttonStop.GetCheck() ) break;
				SearchGraphicFile( todir );
			}
		} while( FindNextFile(hFind, &ffd) != FALSE );
		FindClose( hFind );
	}
}

void CCreateBBDlg::TranslateGraphicFile(const char* folder, const char *ext, BOOL compress)
{
	WIN32_FIND_DATA ffd;
	char file[16];
	wsprintf( file, "*.%s", ext );
	HANDLE hFind = FindFirstFile( file, &ffd );
	if( hFind == INVALID_HANDLE_VALUE )
	{
		if( m_buttonRepress.GetCheck() == FALSE )
		{
			char errmsg[48];
			wsprintf( errmsg, "There's no %s file in the folder.\r\n", ext );
			ProgressMessage( errmsg );
		}
		return;
	}
	do
	{
		if( ffd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY	)
			continue;
		if( m_buttonRepress.GetCheck() )
		{
			char fullpath[MAX_PATH];
			wsprintf( fullpath, "%s\\%s . . . ", folder, ffd.cFileName );
			ProgressMessage( fullpath );
		}
		else
		{
			ProgressMessage( ffd.cFileName );
			ProgressMessage( " . . . " );
		}
		CreateBB( ffd.cFileName, ext );
	    MSG msg;
		while ( ::PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) ) 
		{ 
			if ( !AfxGetApp()->PumpMessage( ) ) break; 
		} 
		if( m_buttonStop.GetCheck() ) break;
		if( compress )
		{
			ProgressMessage( "\tcompress..." );
			CompressBMP( ffd.cFileName );
		}
		while ( ::PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) ) 
		{
			if ( !AfxGetApp()->PumpMessage( ) ) break;
		}
		if( m_buttonStop.GetCheck() ) break;
	} while( FindNextFile(hFind, &ffd) != FALSE );
	FindClose( hFind );
	return;
}

void CCreateBBDlg::OnButtonFileType() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CFileTypeDlg dlg;
	dlg.m_bBMP = (m_nFileType & BMP)?TRUE:FALSE;
	dlg.m_bWMF = (m_nFileType & WMF)?TRUE:FALSE;
	dlg.m_bEMF = (m_nFileType & EMF)?TRUE:FALSE;
	dlg.m_bJPG = (m_nFileType & JPG)?TRUE:FALSE;
	dlg.m_bMAG = (m_nFileType & MAG)?TRUE:FALSE;
	dlg.m_bEPS = (m_nFileType & EPS)?TRUE:FALSE;
	if( dlg.DoModal() == IDOK )
	{
		m_nFileType = 0;
		ASSERT( TRUE == 1 );
		m_nFileType += BMP*dlg.m_bBMP;
		m_nFileType += WMF*dlg.m_bWMF;
		m_nFileType += EMF*dlg.m_bEMF;
		m_nFileType += JPG*dlg.m_bJPG;
		m_nFileType += MAG*dlg.m_bMAG;
		m_nFileType += EPS*dlg.m_bEPS;
	}
}


void CCreateBBDlg::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	AfxGetApp()->WriteProfileInt( "Settings", "FileType", m_nFileType );
	AfxGetApp()->WriteProfileString( "Settings", "directory", m_strTranslateDirectory );
	AfxGetApp()->WriteProfileInt( "Settings", "compress", m_buttonCompress.GetCheck() );
	AfxGetApp()->WriteProfileInt( "Settings", "recursive", m_buttonRecursive.GetCheck() );
	AfxGetApp()->WriteProfileInt( "Settings", "repress", m_buttonRepress.GetCheck() );
	AfxGetApp()->WriteProfileInt( "Settings", "selectonly", m_buttonSelectOnly.GetCheck() );
	CDialog::OnCancel();
}



void CCreateBBDlg::OnCheckSelectOnly() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	if( m_buttonSelectOnly.GetCheck() == FALSE )
	{
		m_buttonRecursive.EnableWindow();
		return;
	}
	m_buttonRecursive.SetCheck( FALSE );
	m_buttonRecursive.EnableWindow( FALSE );
	return;
}

void CCreateBBDlg::OnCheckRecursive() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	if( m_buttonRecursive.GetCheck() == TRUE )
	{
		m_buttonSelectOnly.SetCheck( FALSE );
		m_buttonSelectOnly.EnableWindow( FALSE );
	}
	else
		m_buttonSelectOnly.EnableWindow( TRUE );
	return;
}

void CCreateBBDlg::OnButtonSelectFile() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CFileDialog dlg( TRUE,
		NULL,
		NULL,
		 OFN_ALLOWMULTISELECT | OFN_FILEMUSTEXIST | OFN_NOREADONLYRETURN
		 | OFN_PATHMUSTEXIST ,
		 _T( "All Files (*.*)|*.*||" ),
		 this );
	dlg.m_ofn.lpstrTitle = "Select Files to Create BB Files";
	char files[MAX_PATH];
	ZeroMemory( files, MAX_PATH );
	dlg.m_ofn.lpstrFile = files;
	dlg.m_ofn.nMaxFile = MAX_PATH;
	if( dlg.DoModal() == IDOK )
	{
		/* files = aaa<NULL>bbb<NULL>ccc<NULL><NULL> */
		m_strProgress = "";
		m_buttonStop.SetCheck( FALSE );
		m_buttonStop.EnableWindow();
		ProgressMessage( "OK, start to create Bounding Box file(s).\r\n" );
		char* f = files + dlg.m_ofn.nFileOffset;
		int l = lstrlen( f );
		do
		{
			ProgressMessage( f );
			ProgressMessage( " . . . " );
			
			char ext[12];
			char* p;
			if( (p = strrchr(f,'.')) != NULL ) lstrcpy( ext, p + 1 );
			else ext[0] = NULL;

			CreateBB( f, ext );
		    MSG msg;
			while ( ::PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) ) 
			{ 
				if ( !AfxGetApp()->PumpMessage( ) ) break; 
			} 
			if( m_buttonStop.GetCheck() ) break;
			f += (l+1);
			l = lstrlen( f );
		} while( l != 0 );
		SearchGraphicFile( m_strTranslateDirectory );
		if( m_buttonStop.GetCheck() )
			ProgressMessage( "Stopped by you.\r\n" );
		else
			ProgressMessage( "Complete.\r\n" );
		m_buttonStop.SetCheck( FALSE );
		m_buttonStop.EnableWindow( FALSE );
	}
	return;
}


BOOL CCreateBBDlg::CreatePfi(CString filename)
{
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	SECURITY_ATTRIBUTES sa;

	char* temp = filename.GetBuffer( MAX_PATH );
	temp[lstrlen(temp) - 4] = NULL;
	filename.ReleaseBuffer();

	ZeroMemory( &pi, sizeof(PROCESS_INFORMATION) );
	ZeroMemory( &si, sizeof(STARTUPINFO) );

	si.cb = sizeof(STARTUPINFO);
	si.dwFlags = STARTF_USESHOWWINDOW;
	si.wShowWindow = SW_HIDE;
	sa.nLength = sizeof(SECURITY_ATTRIBUTES);
	sa.bInheritHandle = TRUE;
	sa.lpSecurityDescriptor = NULL;

	char bmc[512];

	OSVERSIONINFO ovi;
	ovi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx( &ovi );
	if( ovi.dwPlatformId == VER_PLATFORM_WIN32_NT )
		wsprintf( bmc, "cmd.exe /Cgswin32c.exe -dNODISPLAY -dBATCH -q ps2frag.ps \"%s.eps\" > \"%s.pfi\"", filename, filename );
	else
		wsprintf( bmc, "command.com /cgswin32c.exe -dNODISPLAY -dBATCH -q ps2frag.ps \"%s.eps\" > \"%s.pfi\"", filename, filename );

	BOOL bSuccess = CreateProcess(
		NULL, bmc, &sa, &sa, TRUE, 
		CREATE_NEW_CONSOLE, NULL, NULL, &si, &pi );
	if( bSuccess )
	{
		CloseHandle( pi.hThread );
		if( WaitForSingleObject(pi.hProcess, INFINITE) != WAIT_FAILED )
		{
			DWORD dwExitCode;
			char errcode[32];
			if( GetExitCodeProcess(pi.hProcess,&dwExitCode) )
			{
				if( dwExitCode != 0 ) // ERRLEVEL != 0 --- error may occur
				{
					wsprintf( errcode, "ERROR CODE=%d\r\n", dwExitCode );
					ProgressMessage( errcode );
				}
				else // ERRLEVEL = 0
					ProgressMessage( "done.\r\n" );
			}
			else // ERRLEVEL didn't return
				ProgressMessage( "unexpected error!\r\n" );
		}
		CloseHandle( pi.hProcess );
//		CloseHandle( hFile );
		return TRUE;
	}
	else // CreateProcess failed.
	{
		ProgressMessage( "Cannot run gswin32c.exe, why?\r\n" );
		return FALSE;
	}
}
