/* options.h - command line arguments processing
   $Id: options.h,v 0.2 1997/03/28 03:17:18 tjchol01 Exp $
   Authors: Andrew Trevorrow, Ian Dall, Geoffrey Tobin, Tomasz J. Cholewo
 */

#ifndef __OPTIONS_H__
#define __OPTIONS_H__

#include "dvgt.h"

/*
   Units of measure:
   inch, centimetre, millimetre, big point, pica, TeX point,
   scaled point, paper pixel.
 */

typedef enum
  {
    ic, cm, mm, bp, pc, pt, sp, px
  }
units;

extern double xres;		/* X resolution in pixels per inch   */
extern double yres;		/* Y resolution in pixels per inch   */
extern int mag;			/* override DVI mag; 0 = use DVI mag */
extern int hoffset;		/* horizontal margin shift in pixels */
extern int voffset;		/* vertical   margin shift in pixels */
extern int paperwd;		/* paper width in pixels             */
extern int paperht;		/* paper height in pixels            */
extern String vdu;		/* type of terminal                  */
extern String dummy_tfm;	/* dummy TFM file                    */
extern String dummy_pk;		/* dummy PK  file                    */

extern string DVIname;		/* DVI file name                     */


extern int InitOptions PARAMS ((int argc, char **argv));
extern int Len PARAMS ((char *str));
extern char *stringcopy PARAMS ((String s, const char *ct));
extern char *strMcpy PARAMS ((char *s, const char *ct, size_t maxlen));
extern void WriteReal PARAMS ((char *name, double value));

#endif /* __OPTIONS_H__ */

/* end options.h */
