/*
 * Copyright (c) 2001, 2004 IBM Corp and others.  All rights reserved.
 * This file is made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * 	  Andre Weinand (OTI Labs)
 */
#include <pwd.h>
#include <stdlib.h>

#include "util.h"

#define APP_PACKAGE "APP_PACKAGE"
#define JAVAROOT "JAVAROOT"

static char *append(char *buffer, const char *s);
static char *appendc(char *buffer, char c);

/*
 * Expand $APP_PACKAGE, $JAVA_HOME, and does tilde expansion.
 
	A word beginning with an unquoted tilde character (~) is
	subject to tilde expansion. All the characters up to a
	slash (/) or the end of the word are treated as a username
	and are replaced with the user's home directory. If the
	username is missing (as in ~/foobar), the tilde is
	replaced with the value of the HOME variable (the current
	user's home directory).
 */
char *expandShell(char *arg, const char *appPackage, const char *javaRoot) {
	
	if (index(arg, '~') == NULL && index(arg, '$') == NULL)
		return arg;
	
	char *buffer= strsave("");
	char c, lastChar= ' ';
	const char *cp= arg;
	while (c= *cp++) {
		if (isspace(lastChar) && c == '~') {
			char name[100], *dir= NULL;
			int j= 0;
			for (; c= *cp; cp++) {
				if (! isalnum(c))
					break;
				name[j++]= c;
				lastChar= c;
			}
			name[j]= '\0';
			if (j > 0) {
				struct passwd *pw= getpwnam(name);
				if (pw != NULL)
					dir= pw->pw_dir;
			} else {
				dir= getenv("HOME");
			}
			if (dir != NULL)
				buffer= append(buffer, dir);
				
		} else if (c == '$') {
			int l= strlen(APP_PACKAGE);
			if (appPackage != NULL && strncmp(cp, APP_PACKAGE, l) == 0) {
				cp+= l;
				buffer= append(buffer, appPackage);
			} else {
				int l= strlen(JAVAROOT);
				if (javaRoot != NULL && strncmp(cp, JAVAROOT, l) == 0) {
					cp+= l;
					buffer= append(buffer, javaRoot);
				} else {
					buffer= appendc(buffer, c);
				}
			}
		} else
			buffer= appendc(buffer, c);
		lastChar= c;
	}
	return buffer;
}

char *strsave(const char *s) {
	return strcpy(malloc(strlen(s)+1), s);
}

char *strconcat(const char *s1, const char *s2) {
	return strcat(strcpy(malloc(strlen(s1)+strlen(s2)+1), s1), s2);
}

char *my_strcasestr(const char *big, const char *little) {
    char *cp, *s, *t;
    for (cp= (char*) big; *cp; cp++) {
        for (s= cp, t= (char*) little; *s && *t; s++, t++)
            if (toupper(*s) != toupper(*t))
                break;
        if (*t == '\0')
            return cp;
    }
    return NULL;
}

static char *append(char *buffer, const char *s) {
	int bl= strlen(buffer);
	int sl= strlen(s);
	buffer= realloc(buffer, bl+sl+1);
	strcpy(&buffer[bl], s);
	return buffer;
}

static char *appendc(char *buffer, char c) {
	int bl= strlen(buffer);
	buffer= realloc(buffer, bl+2);
	buffer[bl++]= c;
	buffer[bl]= '\0';
	return buffer;
}
