#**********************************************************************
# Copyright (c) 2001, 2004 IBM Corp. and others.  All rights reserved.
# This file is made available under the terms of the Common Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/cpl-v10.html
#   
# Contributors: 
#     Kevin Cornell (Rational Software Corporation)
#********************************************************************** 
 
# Makefile for creating the eclipse launcher program.

# This script expects the following environment variables set:
#
# PROGRAM_OUTPUT - the filename of the output executable
# PROGRAM_NAME - the title of the splash screen program

# Define the object modules to be compiled and flags.
OBJS = eclipse.o eclipseUtil.o eclipseShm.o eclipseCarbon.o util.o NgImageData.o NgWinBMPFileFormat.o NgCommon.o
EXEC = $(PROGRAM_OUTPUT)
LIBS = -framework Carbon
CFLAGS = -O -s \
	-DPROGRAM_NAME="\"$(PROGRAM_NAME)\"" \
	-DDEFAULT_OS="\"$(DEFAULT_OS)\"" \
	-DDEFAULT_OS_ARCH="\"$(DEFAULT_OS_ARCH)\"" \
	-DDEFAULT_WS="\"$(DEFAULT_WS)\"" \
	-I.. -I../motif

all: $(EXEC) swt_launcher/java_swt.h
	cp eclipse ../../bin/macosx/Eclipse.app/Contents/MacOS/
	rm *.o

.c.o:
	$(CC) $(CFLAGS) -c $< -o $@

eclipseUtil.o: ../eclipseUtil.c
	$(CC) $(CFLAGS) -c ../eclipseUtil.c -o $@

eclipseShm.o: ../eclipseShm.c
	$(CC) $(CFLAGS) -c ../eclipseShm.c -o $@

util.o: swt_launcher/util.c
	$(CC) $(CFLAGS) -c swt_launcher/util.c -o $@

NgCommon.o: ../motif/NgCommon.c
	$(CC) $(CFLAGS) -c ../motif/NgCommon.c -o $@

NgWinBMPFileFormat.o: ../motif/NgWinBMPFileFormat.c
	$(CC) $(CFLAGS) -c ../motif/NgWinBMPFileFormat.c -o $@

NgImageData.o: ../motif/NgImageData.c
	$(CC) $(CFLAGS) -c ../motif/NgImageData.c -o $@

$(EXEC): $(OBJS)
	$(CC) -o $(EXEC) $(OBJS) $(LIBS)

clean:
	rm -f $(EXEC) $(OBJS)
