/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ui.internal.commands.CommandRegistryEvent;
import org.eclipse.ui.internal.commands.ICommandRegistry;
import org.eclipse.ui.internal.commands.ICommandRegistryListener;

abstract class AbstractCommandRegistry
implements ICommandRegistry {
    protected List activeKeyConfigurationDefinitions = Collections.EMPTY_LIST;
    protected List categoryDefinitions = Collections.EMPTY_LIST;
    protected List commandDefinitions = Collections.EMPTY_LIST;
    private CommandRegistryEvent commandRegistryEvent;
    private List commandRegistryListeners;
    protected List handlers = Collections.EMPTY_LIST;
    protected List imageBindingDefinitions = Collections.EMPTY_LIST;
    protected List keyConfigurationDefinitions = Collections.EMPTY_LIST;
    protected List keySequenceBindingDefinitions = Collections.EMPTY_LIST;

    protected AbstractCommandRegistry() {
    }

    public void addCommandRegistryListener(ICommandRegistryListener commandRegistryListener) {
        if (commandRegistryListener == null) {
            throw new NullPointerException();
        }
        if (this.commandRegistryListeners == null) {
            this.commandRegistryListeners = new ArrayList();
        }
        if (!this.commandRegistryListeners.contains(commandRegistryListener)) {
            this.commandRegistryListeners.add(commandRegistryListener);
        }
    }

    protected void fireCommandRegistryChanged() {
        if (this.commandRegistryListeners != null) {
            for (int i = 0; i < this.commandRegistryListeners.size(); ++i) {
                if (this.commandRegistryEvent == null) {
                    this.commandRegistryEvent = new CommandRegistryEvent(this);
                }
                ((ICommandRegistryListener)this.commandRegistryListeners.get(i)).commandRegistryChanged(this.commandRegistryEvent);
            }
        }
    }

    public List getActiveKeyConfigurationDefinitions() {
        return this.activeKeyConfigurationDefinitions;
    }

    public List getCategoryDefinitions() {
        return this.categoryDefinitions;
    }

    public List getCommandDefinitions() {
        return this.commandDefinitions;
    }

    public List getHandlers() {
        return this.handlers;
    }

    public List getImageBindingDefinitions() {
        return this.imageBindingDefinitions;
    }

    public List getKeyConfigurationDefinitions() {
        return this.keyConfigurationDefinitions;
    }

    public List getKeySequenceBindingDefinitions() {
        return this.keySequenceBindingDefinitions;
    }

    public void removeCommandRegistryListener(ICommandRegistryListener commandRegistryListener) {
        if (commandRegistryListener == null) {
            throw new NullPointerException();
        }
        if (this.commandRegistryListeners != null) {
            this.commandRegistryListeners.remove(commandRegistryListener);
        }
    }
}

