/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.osgi.framework.Bundle;

public class StorageDocumentProvider
extends AbstractDocumentProvider
implements IStorageDocumentProvider {
    protected static final int DEFAULT_FILE_SIZE = 15360;

    protected void setDocumentContent(IDocument document, InputStream contentStream) throws CoreException {
        this.setDocumentContent(document, contentStream, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        Reader in = null;
        try {
            try {
                if (encoding == null) {
                    encoding = this.getDefaultEncoding();
                }
                in = new BufferedReader(new InputStreamReader(contentStream, encoding), 15360);
                StringBuffer buffer = new StringBuffer(15360);
                char[] readBuffer = new char[2048];
                int n = in.read(readBuffer);
                while (n > 0) {
                    buffer.append(readBuffer, 0, n);
                    n = in.read(readBuffer);
                }
                document.set(buffer.toString());
            }
            catch (IOException x) {
                String message = x.getMessage() != null ? x.getMessage() : "";
                Status s = new Status(4, "org.eclipse.ui", 0, message, (Throwable)x);
                throw new CoreException((IStatus)s);
            }
            Object var9_11 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException x) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException x) {}
        in.close();
        return;
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput) throws CoreException {
        return this.setDocumentContent(document, editorInput, null);
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        if (editorInput instanceof IStorageEditorInput) {
            IStorage storage = ((IStorageEditorInput)editorInput).getStorage();
            this.setDocumentContent(document, storage.getContents(), encoding);
            return true;
        }
        return false;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    protected IDocument createEmptyDocument() {
        return new Document();
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document;
        if (element instanceof IEditorInput && this.setDocumentContent(document = this.createEmptyDocument(), (IEditorInput)element, this.getEncoding(element))) {
            this.setupDocument(element, document);
            return document;
        }
        return null;
    }

    protected void setupDocument(Object element, IDocument document) {
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (element instanceof IStorageEditorInput) {
            IDocument document = null;
            IStatus status = null;
            try {
                document = this.createDocument(element);
            }
            catch (CoreException x) {
                status = x.getStatus();
                document = this.createEmptyDocument();
            }
            StorageInfo info = new StorageInfo(document, this.createAnnotationModel(element));
            info.fStatus = status;
            info.fEncoding = this.getPersistedEncoding(element);
            return info;
        }
        return super.createElementInfo(element);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
    }

    protected void handleCoreException(CoreException exception, String message) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog log = Platform.getLog((Bundle)bundle);
        if (message != null) {
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, message, (Throwable)exception));
        } else {
            log.log(exception.getStatus());
        }
    }

    protected void updateCache(IStorageEditorInput input) throws CoreException {
        StorageInfo info = (StorageInfo)this.getElementInfo(input);
        if (info != null) {
            try {
                IStorage storage = input.getStorage();
                if (storage != null) {
                    boolean readOnly;
                    info.fIsReadOnly = readOnly = storage.isReadOnly();
                    info.fIsModifiable = !readOnly;
                }
            }
            catch (CoreException x) {
                this.handleCoreException(x, TextEditorMessages.getString("StorageDocumentProvider.updateCache"));
            }
            info.fUpdateCache = false;
        }
    }

    public boolean isReadOnly(Object element) {
        StorageInfo info;
        if (element instanceof IStorageEditorInput && (info = (StorageInfo)this.getElementInfo(element)) != null) {
            if (info.fUpdateCache) {
                try {
                    this.updateCache((IStorageEditorInput)element);
                }
                catch (CoreException x) {
                    this.handleCoreException(x, TextEditorMessages.getString("StorageDocumentProvider.isReadOnly"));
                }
            }
            return info.fIsReadOnly;
        }
        return super.isReadOnly(element);
    }

    public boolean isModifiable(Object element) {
        StorageInfo info;
        if (element instanceof IStorageEditorInput && (info = (StorageInfo)this.getElementInfo(element)) != null) {
            if (info.fUpdateCache) {
                try {
                    this.updateCache((IStorageEditorInput)element);
                }
                catch (CoreException x) {
                    this.handleCoreException(x, TextEditorMessages.getString("StorageDocumentProvider.isModifiable"));
                }
            }
            return info.fIsModifiable;
        }
        return super.isModifiable(element);
    }

    protected void doUpdateStateCache(Object element) throws CoreException {
        StorageInfo info;
        if (element instanceof IStorageEditorInput && (info = (StorageInfo)this.getElementInfo(element)) != null) {
            info.fUpdateCache = true;
        }
        super.doUpdateStateCache(element);
    }

    public String getDefaultEncoding() {
        return ResourcesPlugin.getEncoding();
    }

    public String getEncoding(Object element) {
        if (element instanceof IStorageEditorInput) {
            StorageInfo info = (StorageInfo)this.getElementInfo(element);
            if (info != null) {
                return info.fEncoding;
            }
            return this.getPersistedEncoding(element);
        }
        return null;
    }

    public void setEncoding(Object element, String encoding) {
        StorageInfo info;
        if (element instanceof IStorageEditorInput && (info = (StorageInfo)this.getElementInfo(element)) != null) {
            info.fEncoding = encoding;
            try {
                this.persistEncoding(element, encoding);
            }
            catch (CoreException ex) {
                // empty catch block
            }
        }
    }

    protected String getPersistedEncoding(Object element) {
        if (element instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)element).getStorage();
                if (storage instanceof IEncodedStorage) {
                    return ((IEncodedStorage)storage).getCharset();
                }
            }
            catch (CoreException e) {
                return null;
            }
        }
        return null;
    }

    protected void persistEncoding(Object element, String encoding) throws CoreException {
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    protected class StorageInfo
    extends AbstractDocumentProvider.ElementInfo {
        public boolean fIsModifiable = false;
        public boolean fIsReadOnly = true;
        public boolean fUpdateCache = true;
        public String fEncoding = null;

        public StorageInfo(IDocument document, IAnnotationModel model) {
            super((AbstractDocumentProvider)StorageDocumentProvider.this, document, model);
        }
    }
}

