/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.templates;

import org.eclipse.jface.text.Assert;

public class TemplateVariable {
    private final String fType;
    private final String fName;
    private int[] fOffsets;
    private boolean fIsUnambiguous;
    private String[] fValues;

    public TemplateVariable(String type, String defaultValue, int[] offsets) {
        this(type, new String[]{defaultValue}, offsets);
    }

    public TemplateVariable(String type, String name, String defaultValue, int[] offsets) {
        this(type, name, new String[]{defaultValue}, offsets);
    }

    public TemplateVariable(String type, String[] values, int[] offsets) {
        this(type, type, values, offsets);
    }

    public TemplateVariable(String type, String name, String[] values, int[] offsets) {
        Assert.isNotNull(type);
        Assert.isNotNull(name);
        this.fType = type;
        this.fName = name;
        this.setValues(values);
        this.setOffsets(offsets);
        this.setUnambiguous(false);
    }

    public String getType() {
        return this.fType;
    }

    public String getName() {
        return this.fName;
    }

    public String getDefaultValue() {
        return this.getValues()[0];
    }

    public String[] getValues() {
        return this.fValues;
    }

    public int getLength() {
        return this.getDefaultValue().length();
    }

    public void setOffsets(int[] offsets) {
        this.fOffsets = offsets;
    }

    public int[] getOffsets() {
        return this.fOffsets;
    }

    public final void setValue(String value) {
        this.setValues(new String[]{value});
    }

    public void setValues(String[] values) {
        Assert.isTrue(values.length > 0);
        this.fValues = values;
    }

    public void setUnambiguous(boolean unambiguous) {
        this.fIsUnambiguous = unambiguous;
    }

    public boolean isUnambiguous() {
        return this.fIsUnambiguous;
    }
}

