/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.core.ListenerList;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class LazyModelPresentation
implements IDebugModelPresentation,
IDebugEditorPresentation {
    protected HashMap fAttributes = new HashMap(3);
    protected IConfigurationElement fConfig = null;
    protected IDebugModelPresentation fPresentation = null;
    protected ListenerList fListeners = new ListenerList(5);

    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
        IDebugModelPresentation presentation = this.getPresentation();
        if (presentation instanceof IDebugEditorPresentation) {
            ((IDebugEditorPresentation)((Object)presentation)).removeAnnotations(editorPart, thread);
        }
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        IDebugModelPresentation presentation = this.getPresentation();
        if (presentation instanceof IDebugEditorPresentation) {
            return ((IDebugEditorPresentation)((Object)presentation)).addAnnotations(editorPart, frame);
        }
        return false;
    }

    public LazyModelPresentation(IConfigurationElement configElement) {
        this.fConfig = configElement;
    }

    public Image getImage(Object element) {
        return this.getPresentation().getImage(element);
    }

    public String getText(Object element) {
        return this.getPresentation().getText(element);
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        this.getPresentation().computeDetail(value, listener);
    }

    public IEditorInput getEditorInput(Object element) {
        return this.getPresentation().getEditorInput(element);
    }

    public String getEditorId(IEditorInput input, Object inputObject) {
        return this.getPresentation().getEditorId(input, inputObject);
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fPresentation != null) {
            this.getPresentation().addListener(listener);
        }
        this.fListeners.add((Object)listener);
    }

    public void dispose() {
        if (this.fPresentation != null) {
            this.getPresentation().dispose();
        }
        this.fListeners = null;
    }

    public boolean isLabelProperty(Object element, String property) {
        if (this.fPresentation != null) {
            return this.getPresentation().isLabelProperty(element, property);
        }
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fPresentation != null) {
            this.getPresentation().removeListener(listener);
        }
        this.fListeners.remove((Object)listener);
    }

    protected IDebugModelPresentation getPresentation() {
        if (this.fPresentation == null) {
            try {
                this.fPresentation = (IDebugModelPresentation)DebugUIPlugin.createExtension(this.fConfig, "class");
                if (this.fListeners != null) {
                    Object[] list = this.fListeners.getListeners();
                    for (int i = 0; i < list.length; ++i) {
                        this.fPresentation.addListener((ILabelProviderListener)list[i]);
                    }
                }
                Iterator keys = this.fAttributes.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    this.fPresentation.setAttribute(key, this.fAttributes.get(key));
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return this.fPresentation;
    }

    public void setAttribute(String id, Object value) {
        if (value == null) {
            return;
        }
        if (this.fPresentation != null) {
            this.getPresentation().setAttribute(id, value);
        }
        this.fAttributes.put(id, value);
    }

    public String getDebugModelIdentifier() {
        return this.fConfig.getAttribute("id");
    }

    public SourceViewerConfiguration newDetailsViewerConfiguration() throws CoreException {
        String attr = this.fConfig.getAttribute("detailsViewerConfiguration");
        if (attr != null) {
            return (SourceViewerConfiguration)this.fConfig.createExecutableExtension("detailsViewerConfiguration");
        }
        return null;
    }

    public Map getAttributeMap() {
        return (Map)this.fAttributes.clone();
    }
}

