/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.runtime.AdapterFactoryProxy;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;

public final class AdapterManager
implements IAdapterManager,
IRegistryChangeListener {
    protected final HashMap factories = new HashMap(5);
    protected HashMap lookup = null;

    public AdapterManager() {
        this.registerFactoryProxies();
        Platform.getExtensionRegistry().addRegistryChangeListener(this);
    }

    private void addFactoriesFor(String typeName, Map table) {
        List factoryList = (List)this.factories.get(typeName);
        if (factoryList == null) {
            return;
        }
        int imax = factoryList.size();
        for (int i = 0; i < imax; ++i) {
            int j;
            Object[] adapters;
            IAdapterFactory factory = (IAdapterFactory)factoryList.get(i);
            if (factory instanceof AdapterFactoryProxy) {
                adapters = ((AdapterFactoryProxy)factory).getAdapterNames();
                for (j = 0; j < adapters.length; ++j) {
                    if (table.get(adapters[j]) != null) continue;
                    table.put(adapters[j], factory);
                }
                continue;
            }
            adapters = factory.getAdapterList();
            for (j = 0; j < adapters.length; ++j) {
                String adapterName = ((Class)adapters[j]).getName();
                if (table.get(adapterName) != null) continue;
                table.put(adapterName, factory);
            }
        }
    }

    private Class classForName(IAdapterFactory factory, String typeName) {
        try {
            if (factory instanceof AdapterFactoryProxy) {
                factory = ((AdapterFactoryProxy)factory).loadFactory(false);
            }
            if (factory != null) {
                return factory.getClass().getClassLoader().loadClass(typeName);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private Map computeClassOrder(Class adaptable) {
        HashMap table = new HashMap(4);
        HashSet seen = new HashSet(4);
        for (Class clazz = adaptable; clazz != null; clazz = clazz.getSuperclass()) {
            this.addFactoriesFor(clazz.getName(), table);
            this.computeInterfaceOrder(clazz.getInterfaces(), table, seen);
        }
        return table;
    }

    private void computeInterfaceOrder(Class[] interfaces, Map table, Set seen) {
        ArrayList<Class> newInterfaces = new ArrayList<Class>(interfaces.length);
        for (int i = 0; i < interfaces.length; ++i) {
            Class interfac = interfaces[i];
            if (!seen.add(interfac)) continue;
            this.addFactoriesFor(interfac.getName(), table);
            newInterfaces.add(interfac);
        }
        Iterator it = newInterfaces.iterator();
        while (it.hasNext()) {
            this.computeInterfaceOrder(((Class)it.next()).getInterfaces(), table, seen);
        }
    }

    public synchronized void flushLookup() {
        this.lookup = null;
    }

    public Object getAdapter(Object adaptable, Class adapterType) {
        IAdapterFactory factory = this.getFactory(adaptable.getClass(), adapterType.getName());
        Object result = null;
        if (factory != null) {
            result = factory.getAdapter(adaptable, adapterType);
        }
        if (result == null && adapterType.isInstance(adaptable)) {
            return adaptable;
        }
        return result;
    }

    public Object getAdapter(Object adaptable, String adapterType) {
        return this.getAdapter(adaptable, adapterType, false);
    }

    private Object getAdapter(Object adaptable, String adapterType, boolean force) {
        Class clazz;
        IAdapterFactory factory = this.getFactory(adaptable.getClass(), adapterType);
        if (force && factory instanceof AdapterFactoryProxy) {
            factory = ((AdapterFactoryProxy)factory).loadFactory(true);
        }
        Object result = null;
        if (factory != null && (clazz = this.classForName(factory, adapterType)) != null) {
            result = factory.getAdapter(adaptable, clazz);
        }
        if (result == null && adaptable.getClass().getName().equals(adapterType)) {
            return adaptable;
        }
        return result;
    }

    private synchronized IAdapterFactory getFactory(Class adaptable, String adapterName) {
        Map table;
        if (this.lookup != null && (table = (Map)this.lookup.get(adaptable.getName())) != null) {
            return (IAdapterFactory)table.get(adapterName);
        }
        table = this.computeClassOrder(adaptable);
        if (this.lookup == null) {
            this.lookup = new HashMap(30);
        }
        this.lookup.put(adaptable.getName(), table);
        return (IAdapterFactory)table.get(adapterName);
    }

    public boolean hasAdapter(Object adaptable, String adapterTypeName) {
        return this.getFactory(adaptable.getClass(), adapterTypeName) != null;
    }

    public Object loadAdapter(Object adaptable, String adapterTypeName) {
        return this.getAdapter(adaptable, adapterTypeName, true);
    }

    public synchronized void registerAdapters(IAdapterFactory factory, Class adaptable) {
        this.registerFactory(factory, adaptable.getName());
        this.flushLookup();
    }

    private void registerExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        for (int j = 0; j < elements.length; ++j) {
            AdapterFactoryProxy proxy = AdapterFactoryProxy.createProxy(elements[j]);
            if (proxy == null) continue;
            this.registerFactory(proxy, proxy.getAdaptableType());
        }
    }

    private void registerFactory(IAdapterFactory factory, String adaptableType) {
        ArrayList<IAdapterFactory> list = (ArrayList<IAdapterFactory>)this.factories.get(adaptableType);
        if (list == null) {
            list = new ArrayList<IAdapterFactory>(5);
            this.factories.put(adaptableType, list);
        }
        list.add(factory);
    }

    private void registerFactoryProxies() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.core.runtime", "adapters");
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            this.registerExtension(extensions[i]);
        }
    }

    public synchronized void registryChanged(IRegistryChangeEvent event) {
        HashSet<IExtension> toRemove = null;
        IExtensionDelta[] deltas = event.getExtensionDeltas();
        String adapterId = "org.eclipse.core.runtime.adapters";
        boolean found = false;
        for (int i = 0; i < deltas.length; ++i) {
            if (!adapterId.equals(deltas[i].getExtensionPoint().getUniqueIdentifier())) continue;
            found = true;
            if (deltas[i].getKind() == 1) {
                this.registerExtension(deltas[i].getExtension());
                continue;
            }
            if (toRemove == null) {
                toRemove = new HashSet<IExtension>();
            }
            toRemove.add(deltas[i].getExtension());
        }
        if (found) {
            this.flushLookup();
        }
        if (toRemove == null) {
            return;
        }
        Iterator it = this.factories.values().iterator();
        while (it.hasNext()) {
            Iterator it2 = ((List)it.next()).iterator();
            while (it2.hasNext()) {
                IExtension ext;
                IAdapterFactory factory = (IAdapterFactory)it2.next();
                if (!(factory instanceof AdapterFactoryProxy) || !toRemove.contains(ext = ((AdapterFactoryProxy)factory).getExtension())) continue;
                it2.remove();
            }
        }
    }

    public synchronized void unregisterAdapters(IAdapterFactory factory) {
        Iterator it = this.factories.values().iterator();
        while (it.hasNext()) {
            ((List)it.next()).remove(factory);
        }
        this.flushLookup();
    }

    public synchronized void unregisterAdapters(IAdapterFactory factory, Class adaptable) {
        List factoryList = (List)this.factories.get(adaptable.getName());
        if (factoryList == null) {
            return;
        }
        factoryList.remove(factory);
        this.flushLookup();
    }

    public synchronized void unregisterAllAdapters() {
        this.factories.clear();
        this.flushLookup();
        Platform.getExtensionRegistry().removeRegistryChangeListener(this);
    }
}

