/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class ThreadJob
extends Job {
    private final JobManager manager;
    protected boolean acquireRule = false;
    private RuntimeException lastPush = null;
    protected Job realJob;
    private ISchedulingRule[] ruleStack;
    protected boolean running = false;
    private int top;

    ThreadJob(JobManager manager, ISchedulingRule rule) {
        super("Implicit Job");
        this.manager = manager;
        this.setSystem(true);
        this.setPriority(10);
        this.ruleStack = new ISchedulingRule[2];
        this.top = -1;
        this.setRule(rule);
    }

    private void illegalPop(ISchedulingRule rule) {
        StringBuffer buf = new StringBuffer("Attempted to endRule: ");
        buf.append(rule);
        if (this.top >= 0 && this.top < this.ruleStack.length) {
            buf.append(", does not match most recent begin: ");
            buf.append(this.ruleStack[this.top]);
        } else if (this.top < 0) {
            buf.append(", but there was no matching beginRule");
        } else {
            buf.append(", but the rule stack was out of bounds: " + this.top);
        }
        buf.append(".  See log for trace information if rule tracing is enabled.");
        String msg = buf.toString();
        if (JobManager.DEBUG || JobManager.DEBUG_BEGIN_END) {
            System.out.println(msg);
            RuntimeException t = this.lastPush == null ? new IllegalArgumentException() : this.lastPush;
            Status error = new Status(4, "org.eclipse.core.runtime", 1, msg, t);
            InternalPlatform.getDefault().log(error);
        }
        Assert.isLegal(false, msg);
    }

    private void illegalPush(ISchedulingRule pushRule, ISchedulingRule baseRule) {
        StringBuffer buf = new StringBuffer("Attempted to beginRule: ");
        buf.append(pushRule);
        buf.append(", does not match outer scope rule: ");
        buf.append(baseRule);
        String msg = buf.toString();
        if (JobManager.DEBUG) {
            System.out.println(msg);
            Status error = new Status(4, "org.eclipse.core.runtime", 1, msg, new IllegalArgumentException());
            InternalPlatform.getDefault().log(error);
        }
        Assert.isLegal(false, msg);
    }

    private boolean isCanceled(IProgressMonitor monitor) {
        try {
            return monitor.isCanceled();
        }
        catch (RuntimeException e) {
            String msg = Policy.bind("jobs.internalError");
            Status status = new Status(4, "org.eclipse.core.runtime", 2, msg, e);
            InternalPlatform.getDefault().log(status);
            return false;
        }
    }

    synchronized boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void joinRun(IProgressMonitor monitor) {
        Thread blocker;
        if (this.isCanceled(monitor)) {
            throw new OperationCanceledException();
        }
        InternalJob blockingJob = this.manager.findBlockingJob(this);
        Thread thread = blocker = blockingJob == null ? null : blockingJob.getThread();
        if (!this.manager.getLockManager().aboutToWait(blocker)) {
            try {
                this.waitStart(monitor, blockingJob);
                while (true) {
                    if (this.isCanceled(monitor)) {
                        throw new OperationCanceledException();
                    }
                    if (this.manager.runNow(this)) break;
                    blockingJob = this.manager.findBlockingJob(this);
                    Thread thread2 = blocker = blockingJob == null ? null : blockingJob.getThread();
                    if (this.manager.getLockManager().aboutToWait(blocker)) break;
                    ThreadJob threadJob = this;
                    synchronized (threadJob) {
                        try {
                            this.wait(250L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
            }
            finally {
                this.waitEnd(monitor);
            }
        }
        this.manager.getLockManager().aboutToRelease();
    }

    boolean pop(ISchedulingRule rule) {
        if (this.top < 0 || this.ruleStack[this.top] != rule) {
            this.illegalPop(rule);
        }
        this.ruleStack[this.top--] = null;
        return this.top < 0;
    }

    void push(ISchedulingRule rule) {
        ISchedulingRule baseRule = this.getRule();
        if (++this.top >= this.ruleStack.length) {
            ISchedulingRule[] newStack = new ISchedulingRule[this.ruleStack.length * 2];
            System.arraycopy(this.ruleStack, 0, newStack, 0, this.ruleStack.length);
            this.ruleStack = newStack;
        }
        this.ruleStack[this.top] = rule;
        if (JobManager.DEBUG_BEGIN_END) {
            this.lastPush = (RuntimeException)new RuntimeException().fillInStackTrace();
        }
        if (baseRule != null && rule != null && !baseRule.contains(rule)) {
            this.illegalPush(rule, baseRule);
        }
    }

    boolean recycle() {
        if (this.getState() != 0) {
            return false;
        }
        this.running = false;
        this.acquireRule = false;
        this.realJob = null;
        this.setRule(null);
        this.setThread(null);
        if (this.ruleStack.length != 2) {
            this.ruleStack = new ISchedulingRule[2];
        } else {
            this.ruleStack[1] = null;
            this.ruleStack[0] = null;
        }
        this.top = -1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        ThreadJob threadJob = this;
        synchronized (threadJob) {
            this.running = true;
        }
        return ASYNC_FINISH;
    }

    void setRealJob(Job realJob) {
        this.realJob = realJob;
    }

    boolean shouldInterrupt() {
        return this.realJob == null ? true : !this.realJob.isSystem();
    }

    private void waitEnd(IProgressMonitor monitor) {
        if (this.isRunning()) {
            this.manager.getLockManager().addLockThread(Thread.currentThread(), this.getRule());
            this.manager.getLockManager().resumeSuspendedLocks(Thread.currentThread());
        } else {
            this.manager.getLockManager().removeLockWaitThread(Thread.currentThread(), this.getRule());
        }
        this.manager.reportUnblocked(monitor);
    }

    private void waitStart(IProgressMonitor monitor, InternalJob blockingJob) {
        this.manager.getLockManager().addLockWaitThread(Thread.currentThread(), this.getRule());
        this.manager.reportBlocked(monitor, blockingJob);
    }
}

