/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleCombinedPermissions;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.BundlePermissions;
import org.eclipse.osgi.framework.internal.core.BundleResourcePermission;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.UnresolvedPermission;
import org.eclipse.osgi.framework.util.SecurePermissionStorage;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

public class PermissionAdminImpl
implements PermissionAdmin {
    protected Framework framework;
    protected PermissionStorage storage;
    protected PermissionInfo[] defaultDefaultPermissionInfos;
    protected PermissionInfo[] baseImpliedPermissionInfos;
    protected BundleCombinedPermissions defaultAssignedPermissions;

    protected PermissionAdminImpl(Framework framework, PermissionStorage storage) {
        this.framework = framework;
        this.storage = storage;
        this.defaultDefaultPermissionInfos = this.getPermissionInfos("default.permissions");
        this.baseImpliedPermissionInfos = this.getPermissionInfos("implied.permissions");
        if (Debug.DEBUG_SECURITY) {
            int i;
            Debug.println("Default default assigned bundle permissions");
            if (this.defaultDefaultPermissionInfos == null) {
                Debug.println("  <none>");
            } else {
                for (i = 0; i < this.defaultDefaultPermissionInfos.length; ++i) {
                    Debug.println("  " + this.defaultDefaultPermissionInfos[i]);
                }
            }
            Debug.println("Base implied bundle permissions");
            if (this.baseImpliedPermissionInfos == null) {
                Debug.println("  <none>");
            } else {
                for (i = 0; i < this.baseImpliedPermissionInfos.length; ++i) {
                    Debug.println("  " + this.baseImpliedPermissionInfos[i]);
                }
            }
        }
        this.defaultAssignedPermissions = new BundleCombinedPermissions(null);
        this.defaultAssignedPermissions.setAssignedPermissions(this.createDefaultAssignedPermissions(this.getDefaultPermissions()));
    }

    public PermissionInfo[] getPermissions(String location) {
        if (location == null) {
            throw new NullPointerException();
        }
        SecurePermissionStorage storage = new SecurePermissionStorage(this.storage);
        try {
            String[] data = storage.getPermissionData(location);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Getting permissions for location: " + location);
                if (data == null) {
                    Debug.println("  <none>");
                } else {
                    for (int i = 0; i < data.length; ++i) {
                        Debug.println("  " + data[i]);
                    }
                }
            }
            return this.makePermissionInfo(data);
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return null;
        }
    }

    public void setPermissions(String location, PermissionInfo[] permissions) {
        ProtectionDomain domain;
        this.framework.checkAdminPermission();
        if (location == null) {
            throw new NullPointerException();
        }
        SecurePermissionStorage storage = new SecurePermissionStorage(this.storage);
        try {
            String[] data = this.makePermissionData(permissions);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Setting permissions for location: " + location);
                if (data == null) {
                    Debug.println("  <none>");
                } else {
                    for (int i = 0; i < data.length; ++i) {
                        Debug.println("  " + data[i]);
                    }
                }
            }
            storage.setPermissionData(location, data);
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return;
        }
        AbstractBundle bundle = this.framework.getBundleByLocation(location);
        if (bundle != null && bundle.getBundleId() != 0L && (domain = bundle.getProtectionDomain()) != null) {
            BundleCombinedPermissions combined = (BundleCombinedPermissions)domain.getPermissions();
            if (permissions == null) {
                combined.setAssignedPermissions(this.defaultAssignedPermissions);
            } else {
                combined.setAssignedPermissions(this.createPermissions(permissions, bundle));
            }
        }
    }

    public String[] getLocations() {
        SecurePermissionStorage storage = new SecurePermissionStorage(this.storage);
        try {
            String[] locations = storage.getLocations();
            return locations;
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return null;
        }
    }

    public PermissionInfo[] getDefaultPermissions() {
        SecurePermissionStorage storage = new SecurePermissionStorage(this.storage);
        try {
            String[] data = storage.getPermissionData(null);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Getting default permissions");
                if (data == null) {
                    Debug.println("  <none>");
                } else {
                    for (int i = 0; i < data.length; ++i) {
                        Debug.println("  " + data[i]);
                    }
                }
            }
            return this.makePermissionInfo(data);
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return null;
        }
    }

    public void setDefaultPermissions(PermissionInfo[] permissions) {
        this.framework.checkAdminPermission();
        SecurePermissionStorage storage = new SecurePermissionStorage(this.storage);
        try {
            String[] data = this.makePermissionData(permissions);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Setting default permissions");
                if (data == null) {
                    Debug.println("  <none>");
                } else {
                    for (int i = 0; i < data.length; ++i) {
                        Debug.println("  " + data[i]);
                    }
                }
            }
            storage.setPermissionData(null, data);
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return;
        }
        this.defaultAssignedPermissions.setAssignedPermissions(this.createDefaultAssignedPermissions(permissions));
    }

    protected PermissionInfo[] makePermissionInfo(String[] data) {
        if (data == null) {
            return null;
        }
        int size = data.length;
        PermissionInfo[] permissions = new PermissionInfo[size];
        for (int i = 0; i < size; ++i) {
            permissions[i] = new PermissionInfo(data[i]);
        }
        return permissions;
    }

    protected String[] makePermissionData(PermissionInfo[] permissions) {
        if (permissions == null) {
            return null;
        }
        int size = permissions.length;
        String[] data = new String[size];
        for (int i = 0; i < size; ++i) {
            data[i] = permissions[i].getEncoded();
        }
        return data;
    }

    protected PermissionCollection createPermissionCollection(AbstractBundle bundle) {
        BundlePermissionCollection implied = this.getImpliedPermissions(bundle);
        BundleCombinedPermissions combined = new BundleCombinedPermissions(implied);
        BundlePermissionCollection assigned = this.getAssignedPermissions(bundle);
        combined.setAssignedPermissions(assigned);
        return combined;
    }

    protected BundlePermissionCollection createDefaultAssignedPermissions(PermissionInfo[] info) {
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Creating default assigned permissions");
        }
        if (info == null) {
            info = this.defaultDefaultPermissionInfos;
        }
        return this.createPermissions(info, null);
    }

    protected BundlePermissionCollection getAssignedPermissions(AbstractBundle bundle) {
        String location = bundle.getLocation();
        PermissionInfo[] info = this.getPermissions(location);
        if (info == null) {
            return this.defaultAssignedPermissions;
        }
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Creating assigned permissions for " + bundle);
        }
        return this.createPermissions(info, bundle);
    }

    protected BundlePermissionCollection getImpliedPermissions(AbstractBundle bundle) {
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Creating implied permissions for " + bundle);
        }
        BundlePermissionCollection collection = this.createPermissions(this.baseImpliedPermissionInfos, bundle);
        BundleResourcePermission permission = new BundleResourcePermission(bundle.getBundleId());
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Created permission: " + permission);
        }
        collection.add(permission);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PermissionInfo[] getPermissionInfos(String resource) {
        Object[] info = null;
        InputStream in = this.getClass().getResourceAsStream(resource);
        if (in != null) {
            try {
                String line;
                BufferedReader reader;
                Vector<PermissionInfo> permissions = new Vector<PermissionInfo>();
                try {
                    reader = new BufferedReader(new InputStreamReader(in, "UTF8"));
                }
                catch (UnsupportedEncodingException e) {
                    reader = new BufferedReader(new InputStreamReader(in));
                }
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("//")) continue;
                    try {
                        permissions.addElement(new PermissionInfo(line));
                    }
                    catch (IllegalArgumentException iae) {
                        this.framework.publishFrameworkEvent(2, this.framework.systemBundle, iae);
                    }
                }
                int size = permissions.size();
                if (size > 0) {
                    info = new PermissionInfo[size];
                    permissions.copyInto(info);
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ee) {}
            }
        }
        return info;
    }

    protected BundlePermissionCollection createPermissions(PermissionInfo[] info, AbstractBundle bundle) {
        BundlePermissions collection = new BundlePermissions(this.framework.packageAdmin);
        int size = info.length;
        for (int i = 0; i < size; ++i) {
            File file;
            String name;
            PermissionInfo perm = info[i];
            String type = perm.getType();
            if (type.equals("java.io.FilePermission") && !(name = perm.getName()).equals("<<ALL FILES>>") && !(file = new File(name)).isAbsolute()) {
                File target;
                if (bundle == null || (target = this.framework.getDataFile(bundle, name)) == null) continue;
                perm = new PermissionInfo(type, target.getPath(), perm.getActions());
            }
            ((PermissionCollection)collection).add(this.createPermission(perm));
        }
        return collection;
    }

    protected Permission createPermission(PermissionInfo info) {
        String type = info.getType();
        String name = info.getName();
        String actions = info.getActions();
        UnresolvedPermission permission = new UnresolvedPermission(type, name, actions);
        try {
            Class<?> clazz = Class.forName(type);
            Permission resolved = permission.resolve(clazz);
            if (resolved != null) {
                if (Debug.DEBUG_SECURITY) {
                    Debug.println("Created permission: " + resolved);
                }
                return resolved;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Created permission: " + permission);
        }
        return permission;
    }
}

