/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.reliablefile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.zip.Checksum;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile;

public class ReliableFileOutputStream
extends FilterOutputStream {
    private ReliableFile reliable;
    private Checksum crc;

    public ReliableFileOutputStream(File file) throws IOException {
        this(ReliableFile.getReliableFile(file), false);
    }

    public ReliableFileOutputStream(File file, boolean append) throws IOException {
        this(ReliableFile.getReliableFile(file), append);
    }

    public ReliableFileOutputStream(String name) throws IOException {
        this(ReliableFile.getReliableFile(name), false);
    }

    public ReliableFileOutputStream(String name, boolean append) throws IOException {
        this(ReliableFile.getReliableFile(name), append);
    }

    private ReliableFileOutputStream(ReliableFile reliable, boolean append) throws IOException {
        super(reliable.getOutputStream(append));
        this.reliable = reliable;
        this.crc = append ? reliable.getFileChecksum() : ReliableFile.getChecksumCalculator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.reliable != null) {
            try {
                this.out.write(ReliableFile.identifier1);
                byte[] crcStr = ReliableFile.intToHex((int)this.crc.getValue()).getBytes();
                this.out.write(crcStr);
                this.out.write(ReliableFile.identifier2);
                try {
                    this.out.flush();
                    ((FileOutputStream)this.out).getFD().sync();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                super.close();
            }
            finally {
                this.reliable.closeOutputFile();
                this.reliable = null;
            }
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.crc.update(b, off, len);
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        this.crc.update((byte)b);
    }
}

