/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;

public class SearchResultUpdater
implements IElementChangedListener,
IQueryListener {
    JavaSearchResult fResult;
    private static final int REMOVED_FLAGS = 1185;

    public SearchResultUpdater(JavaSearchResult result) {
        this.fResult = result;
        NewSearchUI.addQueryListener((IQueryListener)this);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        HashSet removedElements = new HashSet();
        HashSet potentiallyRemovedElements = new HashSet();
        this.collectRemoved(potentiallyRemovedElements, removedElements, delta);
        if (removedElements.size() > 0) {
            this.handleRemoved(removedElements);
        }
        if (potentiallyRemovedElements.size() > 0) {
            this.handleRemoved(potentiallyRemovedElements);
        }
    }

    private void handleRemoved(Set removedElements) {
        Object[] elements = this.fResult.getElements();
        for (int i = 0; i < elements.length; ++i) {
            IResource resource;
            int j;
            Match[] matches;
            if (!this.isContainedInRemoved(removedElements, elements[i])) continue;
            if (elements[i] instanceof IJavaElement) {
                IJavaElement je = (IJavaElement)elements[i];
                if (je.exists()) continue;
                matches = this.fResult.getMatches(elements[i]);
                for (j = 0; j < matches.length; ++j) {
                    this.fResult.removeMatch(matches[j]);
                }
                continue;
            }
            if (!(elements[i] instanceof IResource) || (resource = (IResource)elements[i]).exists()) continue;
            matches = this.fResult.getMatches(elements[i]);
            for (j = 0; j < matches.length; ++j) {
                this.fResult.removeMatch(matches[j]);
            }
        }
    }

    private boolean isContainedInRemoved(Set removedElements, Object object) {
        Iterator elements = removedElements.iterator();
        while (elements.hasNext()) {
            if (!this.isParentOf(elements.next(), object)) continue;
            return true;
        }
        return false;
    }

    private boolean isParentOf(Object ancestor, Object descendant) {
        while (descendant != null && !ancestor.equals(descendant)) {
            descendant = this.getParent(descendant);
        }
        return descendant != null;
    }

    private Object getParent(Object object) {
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).getParent();
        }
        if (object instanceof IResource) {
            return ((IResource)object).getParent();
        }
        return null;
    }

    private void collectRemoved(Set potentiallyRemovedSet, Set removedElements, IJavaElementDelta delta) {
        if (delta.getKind() == 2) {
            removedElements.add(delta.getElement());
        } else if (delta.getKind() == 4) {
            int flags = delta.getFlags();
            if ((flags & 0x4A1) != 0) {
                potentiallyRemovedSet.add(delta.getElement());
            } else {
                IJavaElementDelta[] childDeltas = delta.getAffectedChildren();
                for (int i = 0; i < childDeltas.length; ++i) {
                    this.collectRemoved(potentiallyRemovedSet, removedElements, childDeltas[i]);
                }
            }
        }
        IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
        if (resourceDeltas != null) {
            for (int i = 0; i < resourceDeltas.length; ++i) {
                this.collectRemovals(removedElements, resourceDeltas[i]);
            }
        }
    }

    public void queryAdded(ISearchQuery query) {
    }

    public void queryRemoved(ISearchQuery query) {
        if (((Object)((Object)this.fResult)).equals(query.getSearchResult())) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            NewSearchUI.removeQueryListener((IQueryListener)this);
        }
    }

    private void collectRemovals(Set removals, IResourceDelta delta) {
        if (delta.getKind() == 2) {
            removals.add(delta.getResource());
        } else {
            IResourceDelta[] children = delta.getAffectedChildren();
            for (int i = 0; i < children.length; ++i) {
                this.collectRemovals(removals, children[i]);
            }
        }
    }

    public void queryStarting(ISearchQuery query) {
    }

    public void queryFinished(ISearchQuery query) {
    }
}

